/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.ws.internal.common.J2EEActionAdapterFactory;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.converter.IIFile2UriConverter;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.ui.utils.AdapterUtils;
import org.eclipse.wst.ws.internal.util.UniversalPathTransformer;
import org.eclipse.wst.ws.internal.wsfinder.WSDLURLStringWrapper;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class WSDLSelectionWidgetDefaultingCommand
extends AbstractDataModelOperation {
    private IStructuredSelection selection_;
    private String uri_;

    public String getWebServiceURI() {
        if (this.uri_ != null) {
            return this.uri_;
        }
        this.uri_ = "";
        if (this.selection_ != null && !this.selection_.isEmpty()) {
            Object firstSel = this.selection_.getFirstElement();
            if (firstSel instanceof IFile) {
                IFile ifile = (IFile)firstSel;
                String ext = ifile.getFileExtension();
                if (ext != null && (ext.equalsIgnoreCase("wsdl") || ext.equalsIgnoreCase("wsil") || ext.equalsIgnoreCase("html"))) {
                    IIFile2UriConverter converter = WSPlugin.getInstance().getIFile2UriConverter();
                    boolean allowBaseConversionOnFailure = true;
                    if (converter != null) {
                        this.uri_ = converter.convert(ifile);
                        if (this.uri_ == null) {
                            allowBaseConversionOnFailure = converter.allowBaseConversionOnFailure();
                        }
                    }
                    if ((this.uri_ == null || this.uri_.length() == 0) && allowBaseConversionOnFailure) {
                        this.uri_ = ifile.getFullPath().toString();
                    }
                }
            } else if (Platform.getAdapterManager().hasAdapter(firstSel, WSDLURLStringWrapper.class.getName())) {
                Object adaptedObject = Platform.getAdapterManager().loadAdapter(firstSel, WSDLURLStringWrapper.class.getName());
                WSDLURLStringWrapper wrapper = (WSDLURLStringWrapper)adaptedObject;
                this.uri_ = wrapper.getWSDLURLString();
            } else if (firstSel instanceof ServiceImpl) {
                ServiceImpl serviceImpl = (ServiceImpl)firstSel;
                this.uri_ = J2EEActionAdapterFactory.getWSDLURI((ServiceImpl)serviceImpl);
            } else if (firstSel instanceof ServiceRef) {
                ServiceRef serviceRef = (ServiceRef)firstSel;
                this.uri_ = J2EEActionAdapterFactory.getWSDLURI((ServiceRef)serviceRef);
            } else if (firstSel instanceof WSDLResourceImpl) {
                WSDLResourceImpl wsdlRI = (WSDLResourceImpl)firstSel;
                this.uri_ = J2EEActionAdapterFactory.getWSDLURI((WSDLResourceImpl)wsdlRI);
            } else if (firstSel instanceof String) {
                this.uri_ = (String)firstSel;
            } else {
                String adaptedUri = AdapterUtils.getAdaptedWSDL((Object)firstSel);
                if (adaptedUri != null) {
                    this.uri_ = adaptedUri;
                }
            }
            this.uri_ = UniversalPathTransformer.toPath((String)this.uri_);
        }
        return this.uri_;
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.selection_ = selection;
        this.uri_ = null;
    }

    public boolean getGenWSIL() {
        return false;
    }

    public String getWsilURI() {
        String wsURI = this.getWebServiceURI();
        if (wsURI != null && wsURI.length() > 0 && wsURI.toLowerCase().endsWith("wsdl")) {
            StringBuffer sb = new StringBuffer(wsURI.substring(0, wsURI.length() - 4));
            sb.append("wsil");
            return sb.toString();
        }
        return "";
    }

    public IProject getProject() {
        IProject p = this.getProjectFromInitialSelection(this.selection_);
        return p;
    }

    public String getComponentName() {
        String cname = this.getComponentNameFromInitialSelection(this.selection_);
        return cname;
    }

    private boolean hasProtocol(String url) {
        return url.indexOf(":") != -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IProject getProjectFromInitialSelection(IStructuredSelection selection) {
        String uri;
        block3: {
            Object obj;
            if (selection == null || selection.size() != 1 || (obj = selection.getFirstElement()) == null) return null;
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                if (resource != null) return ResourceUtils.getProjectOf((IPath)resource.getFullPath());
                uri = this.getWebServiceURI();
                if (!this.hasProtocol(uri)) break block3;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return ResourceUtils.getProjectOf((IPath)new Path(uri));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getComponentNameFromInitialSelection(IStructuredSelection selection) {
        if (selection == null) return null;
        if (selection.size() != 1) return null;
        Object obj = selection.getFirstElement();
        if (obj == null) return null;
        try {
            IVirtualComponent comp;
            IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
            if (resource == null) {
                String uri = this.getWebServiceURI();
                if (this.hasProtocol(uri)) {
                    return null;
                }
                comp = ResourceUtils.getComponentOf((IPath)new Path(uri));
            } else {
                comp = ResourceUtils.getComponentOf((IResource)resource);
            }
            if (comp == null) return null;
            return comp.getName();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.OK_STATUS;
    }
}

