/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaTemporalConverter;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.AbstractJavaConverter;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.java.AbstractJavaElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.java.TemporalAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaTemporalConverter
extends AbstractJavaConverter
implements JavaTemporalConverter {
    protected final TemporalAnnotation temporalAnnotation;
    protected TemporalType temporalType;

    public GenericJavaTemporalConverter(JavaAttributeMapping parent, TemporalAnnotation temporalAnnotation) {
        super(parent);
        this.temporalAnnotation = temporalAnnotation;
        this.temporalType = this.buildTemporalType();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setTemporalType_(this.buildTemporalType());
    }

    @Override
    public TemporalType getTemporalType() {
        return this.temporalType;
    }

    @Override
    public void setTemporalType(TemporalType temporalType) {
        if (this.valuesAreDifferent((Object)this.temporalType, (Object)temporalType)) {
            this.temporalAnnotation.setValue(TemporalType.toJavaResourceModel(temporalType));
            this.removeTemporalAnnotationIfUnset();
            this.setTemporalType_(temporalType);
        }
    }

    protected void setTemporalType_(TemporalType temporalType) {
        TemporalType old = this.temporalType;
        this.temporalType = temporalType;
        this.firePropertyChanged("temporalType", (Object)old, (Object)temporalType);
    }

    protected TemporalType buildTemporalType() {
        return TemporalType.fromJavaResourceModel(this.temporalAnnotation.getValue());
    }

    @Override
    public Class<? extends Converter> getType() {
        return TemporalConverter.class;
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.Temporal";
    }

    protected void removeTemporalAnnotationIfUnset() {
        if (this.temporalAnnotation.isUnset()) {
            this.temporalAnnotation.removeAnnotation();
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateAttributeTypeWithTemporal(messages, astRoot);
    }

    protected void validateAttributeTypeWithTemporal(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getAttributeMapping().getKey() == "elementCollection") {
            String typeName = ((AbstractJavaElementCollectionMapping2_0)this.getAttributeMapping()).getFullyQualifiedTargetClass();
            if (!ArrayTools.contains((Object[])TEMPORAL_MAPPING_SUPPORTED_TYPES, (Object)typeName)) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_ELEMENT_COLLECTION_INVALID_VALUE_TYPE", EMPTY_STRING_ARRAY, this, this.getValidationTextRange(astRoot)));
            }
        } else {
            String typeName = this.getAttributeMapping().getPersistentAttribute().getTypeName();
            if (!ArrayTools.contains((Object[])TEMPORAL_MAPPING_SUPPORTED_TYPES, (Object)typeName)) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_TEMPORAL_MAPPING_TYPE", EMPTY_STRING_ARRAY, this, this.getValidationTextRange(astRoot)));
            }
        }
    }

    @Override
    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        return this.temporalAnnotation.getTextRange(astRoot);
    }
}

