/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlGeneratorContainer;
import org.eclipse.jpt.jpa.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTableGenerator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmGeneratorContainer
extends AbstractOrmXmlContextNode
implements OrmGeneratorContainer {
    protected final XmlGeneratorContainer xmlGeneratorContainer;
    protected OrmSequenceGenerator sequenceGenerator;
    protected OrmTableGenerator tableGenerator;

    public GenericOrmGeneratorContainer(XmlContextNode parent, XmlGeneratorContainer xmlGeneratorContainer) {
        super(parent);
        this.xmlGeneratorContainer = xmlGeneratorContainer;
        this.sequenceGenerator = this.buildSequenceGenerator();
        this.tableGenerator = this.buildTableGenerator();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSequenceGenerator();
        this.syncTableGenerator();
    }

    @Override
    public void update() {
        super.update();
        if (this.sequenceGenerator != null) {
            this.sequenceGenerator.update();
        }
        if (this.tableGenerator != null) {
            this.tableGenerator.update();
        }
    }

    @Override
    public OrmSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator() {
        if (this.sequenceGenerator != null) {
            throw new IllegalStateException("sequence generator already exists: " + this.sequenceGenerator);
        }
        XmlSequenceGenerator xmlGenerator = this.buildXmlSequenceGenerator();
        OrmSequenceGenerator generator = this.buildSequenceGenerator(xmlGenerator);
        this.setSequenceGenerator_(generator);
        this.xmlGeneratorContainer.setSequenceGenerator(xmlGenerator);
        return generator;
    }

    protected XmlSequenceGenerator buildXmlSequenceGenerator() {
        return OrmFactory.eINSTANCE.createXmlSequenceGenerator();
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.sequenceGenerator == null) {
            throw new IllegalStateException("sequence generator does not exist");
        }
        this.setSequenceGenerator_(null);
        this.xmlGeneratorContainer.setSequenceGenerator(null);
    }

    protected OrmSequenceGenerator buildSequenceGenerator() {
        XmlSequenceGenerator xmlGenerator = this.getXmlSequenceGenerator();
        return xmlGenerator == null ? null : this.buildSequenceGenerator(xmlGenerator);
    }

    protected XmlSequenceGenerator getXmlSequenceGenerator() {
        return this.xmlGeneratorContainer.getSequenceGenerator();
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator xmlSequenceGenerator) {
        return this.getContextNodeFactory().buildOrmSequenceGenerator(this, xmlSequenceGenerator);
    }

    protected void syncSequenceGenerator() {
        XmlSequenceGenerator xmlGenerator = this.getXmlSequenceGenerator();
        if (xmlGenerator == null) {
            if (this.sequenceGenerator != null) {
                this.setSequenceGenerator_(null);
            }
        } else if (this.sequenceGenerator != null && this.sequenceGenerator.getXmlGenerator() == xmlGenerator) {
            this.sequenceGenerator.synchronizeWithResourceModel();
        } else {
            this.setSequenceGenerator_(this.buildSequenceGenerator(xmlGenerator));
        }
    }

    protected void setSequenceGenerator_(OrmSequenceGenerator sequenceGenerator) {
        OrmSequenceGenerator old = this.sequenceGenerator;
        this.sequenceGenerator = sequenceGenerator;
        this.firePropertyChanged("sequenceGenerator", old, sequenceGenerator);
    }

    @Override
    public OrmTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    @Override
    public OrmTableGenerator addTableGenerator() {
        if (this.tableGenerator != null) {
            throw new IllegalStateException("table generator already exists: " + this.tableGenerator);
        }
        XmlTableGenerator xmlGenerator = this.buildXmlTableGenerator();
        OrmTableGenerator generator = this.buildTableGenerator(xmlGenerator);
        this.setTableGenerator_(generator);
        this.xmlGeneratorContainer.setTableGenerator(xmlGenerator);
        return generator;
    }

    protected XmlTableGenerator buildXmlTableGenerator() {
        return OrmFactory.eINSTANCE.createXmlTableGenerator();
    }

    @Override
    public void removeTableGenerator() {
        if (this.tableGenerator == null) {
            throw new IllegalStateException("table generator does not exist");
        }
        this.setTableGenerator_(null);
        this.xmlGeneratorContainer.setTableGenerator(null);
    }

    protected OrmTableGenerator buildTableGenerator() {
        XmlTableGenerator xmlGenerator = this.getXmlTableGenerator();
        return xmlGenerator == null ? null : this.buildTableGenerator(xmlGenerator);
    }

    protected XmlTableGenerator getXmlTableGenerator() {
        return this.xmlGeneratorContainer.getTableGenerator();
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator xmlTableGenerator) {
        return this.getContextNodeFactory().buildOrmTableGenerator(this, xmlTableGenerator);
    }

    protected void syncTableGenerator() {
        XmlTableGenerator xmlGenerator = this.getXmlTableGenerator();
        if (xmlGenerator == null) {
            if (this.tableGenerator != null) {
                this.setTableGenerator_(null);
            }
        } else if (this.tableGenerator != null && this.tableGenerator.getXmlGenerator() == xmlGenerator) {
            this.tableGenerator.synchronizeWithResourceModel();
        } else {
            this.setTableGenerator_(this.buildTableGenerator(xmlGenerator));
        }
    }

    protected void setTableGenerator_(OrmTableGenerator tableGenerator) {
        OrmTableGenerator old = this.tableGenerator;
        this.tableGenerator = tableGenerator;
        this.firePropertyChanged("tableGenerator", old, tableGenerator);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlGeneratorContainer.getValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }
}

