/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.document.DOMMessages;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class CharacterDataImpl
extends NodeImpl
implements CharacterData {
    private char[] data = null;

    protected CharacterDataImpl() {
    }

    protected CharacterDataImpl(CharacterDataImpl that) {
        super(that);
        if (that != null) {
            this.data = that.getData().toCharArray();
        }
    }

    public void appendData(String arg) throws DOMException {
        if (arg == null) {
            return;
        }
        String data = this.getData();
        data = data == null ? arg : String.valueOf(data) + arg;
        this.setData(data);
    }

    public void deleteData(int offset, int count) throws DOMException {
        if (count == 0) {
            return;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        if (count < 0 || offset < 0) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        String data = this.getData();
        if (data == null) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        int length = data.length();
        if (offset > length) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        if (offset == 0) {
            if (count > length) {
                throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
            }
            data = count == length ? "" : data.substring(count);
        } else {
            int end = offset + count;
            if (end > length) {
                throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
            }
            data = end == length ? data.substring(0, offset) : String.valueOf(data.substring(0, offset)) + data.substring(end);
        }
        this.setData(data);
    }

    protected final char[] getCharacterData() {
        return this.data;
    }

    public String getData() throws DOMException {
        char[] cdata = this.getCharacterData();
        if (cdata != null) {
            return new String(cdata);
        }
        return null;
    }

    public int getLength() {
        String data = this.getData();
        if (data == null) {
            return 0;
        }
        return data.length();
    }

    public String getNodeValue() {
        return this.getData();
    }

    public void insertData(int offset, String arg) throws DOMException {
        if (arg == null) {
            return;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        if (offset < 0) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        String data = this.getData();
        if (data == null) {
            if (offset > 0) {
                throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
            }
            data = arg;
        } else if (offset == 0) {
            data = String.valueOf(arg) + data;
        } else {
            int length = data.length();
            if (offset > length) {
                throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
            }
            data = offset == length ? String.valueOf(data) + arg : String.valueOf(data.substring(0, offset)) + arg + data.substring(offset);
        }
        this.setData(data);
    }

    public boolean isJSPContent() {
        Node parent = this.getParentNode();
        if (parent == null || parent.getNodeType() != 1) {
            return false;
        }
        ElementImpl element = (ElementImpl)parent;
        return element.isJSPContainer();
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        if (arg == null) {
            this.deleteData(offset, count);
            return;
        }
        if (count == 0) {
            this.insertData(offset, arg);
            return;
        }
        if (offset < 0 || count < 0) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        String data = this.getData();
        if (data == null) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        if (offset == 0) {
            int length = data.length();
            if (count > length) {
                throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
            }
            data = count == length ? arg : String.valueOf(arg) + data.substring(count);
        } else {
            int end = offset + count;
            int length = data.length();
            if (end > length) {
                throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
            }
            data = end == length ? String.valueOf(data.substring(0, offset)) + arg : String.valueOf(data.substring(0, offset)) + arg + data.substring(end);
        }
        this.setData(data);
    }

    void resetStructuredDocumentRegions() {
        this.data = this.getData().toCharArray();
        this.setStructuredDocumentRegion(null);
    }

    public void setData(String data) throws DOMException {
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        this.data = data != null ? data.toCharArray() : null;
        this.notifyValueChanged();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.setData(nodeValue);
    }

    void setStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        super.setStructuredDocumentRegion(flatNode);
        if (flatNode != null) {
            this.data = null;
        }
    }

    public String substringData(int offset, int count) throws DOMException {
        if (count == 0) {
            return "";
        }
        if (offset < 0 || count < 0) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        String data = this.getData();
        if (data == null) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        int length = data.length();
        if (offset == 0 && count == length) {
            return data;
        }
        if (offset > length) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        int end = offset + count;
        if (end > length) {
            end = length;
        }
        return data.substring(offset, end);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getNodeName());
        buffer.append('(');
        buffer.append(this.getData());
        buffer.append(')');
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode != null) {
            buffer.append('@');
            buffer.append(flatNode.toString());
        }
        return buffer.toString();
    }
}

