/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceParametersReturnTypesRule
extends AbstractAnnotationProcessor {
    private static final Set<String> JAVA_TYPES = new HashSet<String>();
    private static final Set<String> ALLOWED_IN_MULTIPLE_INHERITANCE = new HashSet<String>();
    private static final String REMOTE_OBJECT = "java.rmi.Remote";

    static {
        JAVA_TYPES.add("java.util.Calendar");
        JAVA_TYPES.add("java.util.Date");
        JAVA_TYPES.add("java.util.GregorianCalendar");
        JAVA_TYPES.add("javax.xml.datatype.XMLGregorianCalendar");
        JAVA_TYPES.add("java.util.ArrayList");
        JAVA_TYPES.add("java.util.HashSet");
        JAVA_TYPES.add("java.util.LinkedList");
        JAVA_TYPES.add("java.util.List");
        JAVA_TYPES.add("java.util.Stack");
        JAVA_TYPES.add("java.util.Vector");
        JAVA_TYPES.add("java.math.BigDecimal");
        JAVA_TYPES.add("java.math.BigInteger");
        JAVA_TYPES.add("java.lang.Object");
        JAVA_TYPES.add("javax.xml.namespace.QName");
        JAVA_TYPES.add("java.util.UUID");
        JAVA_TYPES.add("java.net.URI");
        JAVA_TYPES.add("java.awt.Image");
        JAVA_TYPES.add("javax.xml.datatype.Duration");
        JAVA_TYPES.add("javax.xml.transform.Source");
        JAVA_TYPES.add("javax.activation.DataHandler");
        JAVA_TYPES.add("java.lang.String");
        JAVA_TYPES.add("java.lang.Boolean");
        JAVA_TYPES.add("java.lang.Integer");
        JAVA_TYPES.add("java.lang.Character");
        JAVA_TYPES.add("java.lang.Float");
        JAVA_TYPES.add("java.lang.Byte");
        JAVA_TYPES.add("java.lang.Double");
        JAVA_TYPES.add("java.lang.Long");
        JAVA_TYPES.add("java.lang.Short");
        JAVA_TYPES.add("java.lang.Void");
        JAVA_TYPES.add("java.rmi.RemoteException");
        JAVA_TYPES.add("java.io.Serializable");
        JAVA_TYPES.add("java.lang.Cloneable");
        JAVA_TYPES.add("java.lang.Comparable");
        JAVA_TYPES.add("java.util.Map");
        JAVA_TYPES.add("java.util.HashMap");
        JAVA_TYPES.add("java.util.Hashtable");
        JAVA_TYPES.add("java.util.Collection");
        JAVA_TYPES.add("java.lang.Exception");
        JAVA_TYPES.add("java.lang.Throwable");
        JAVA_TYPES.add("java.lang.StackTraceElement");
        ALLOWED_IN_MULTIPLE_INHERITANCE.add("java.lang.Cloneable");
        ALLOWED_IN_MULTIPLE_INHERITANCE.add("java.lang.Comparable");
        ALLOWED_IN_MULTIPLE_INHERITANCE.add("java.io.Serializable");
    }

    public void process() {
        AnnotationTypeDeclaration webServiceDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebService.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(webServiceDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof InterfaceDeclaration)) continue;
            this.validateMethodParametersAndReturnTypes((InterfaceDeclaration)declaration);
        }
    }

    private void validateMethodParametersAndReturnTypes(InterfaceDeclaration interfaceDeclaration) {
        Collection methods = interfaceDeclaration.getMethods();
        for (MethodDeclaration methodDeclaration : methods) {
            TypeMirror returnType = methodDeclaration.getReturnType();
            this.validateTypeMirror(returnType, methodDeclaration);
            Collection parameters = methodDeclaration.getParameters();
            for (ParameterDeclaration parameterDeclaration : parameters) {
                this.validateTypeMirror(parameterDeclaration.getType(), methodDeclaration);
            }
        }
    }

    private void validateTypeMirror(TypeMirror returnType, MethodDeclaration methodDeclaration) {
        ClassDeclaration classDeclaration;
        Collection typeArguments;
        ArrayType arrayType;
        TypeMirror componentType;
        if (returnType instanceof ArrayType && (componentType = (arrayType = (ArrayType)returnType).getComponentType()) instanceof ClassDeclaration) {
            ClassDeclaration classDeclaration2 = (ClassDeclaration)componentType;
            this.checkClassRestriction(classDeclaration2, methodDeclaration);
        }
        if (returnType instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)returnType;
            typeArguments = interfaceType.getActualTypeArguments();
            if (typeArguments.size() > 0) {
                for (TypeMirror typeMirror : typeArguments) {
                    if (typeMirror instanceof ClassDeclaration) {
                        classDeclaration = (ClassDeclaration)typeMirror;
                        this.checkClassRestriction(classDeclaration, methodDeclaration);
                    }
                    if (!(typeMirror instanceof InterfaceDeclaration)) continue;
                    this.checkInterface((InterfaceDeclaration)typeMirror, methodDeclaration);
                }
            }
            this.checkInterface(interfaceType.getDeclaration(), methodDeclaration);
        }
        if (returnType instanceof ClassType) {
            ClassType classType = (ClassType)returnType;
            typeArguments = classType.getActualTypeArguments();
            if (typeArguments.size() > 0) {
                for (TypeMirror typeMirror : typeArguments) {
                    if (!(typeMirror instanceof ClassDeclaration)) continue;
                    classDeclaration = (ClassDeclaration)typeMirror;
                    this.checkClassRestriction(classDeclaration, methodDeclaration);
                }
            } else if (classType.getDeclaration() != null) {
                this.checkClassRestriction(classType.getDeclaration(), methodDeclaration);
            }
        }
    }

    private void checkClassRestriction(ClassDeclaration classDeclaration, MethodDeclaration methodDeclaration) {
        this.checkInnerPublicStaticTypes(classDeclaration, methodDeclaration);
        this.checkIfRemoteObject(classDeclaration, methodDeclaration);
        this.checkAbstactType(classDeclaration, methodDeclaration);
        this.checkMultipleInheritance(classDeclaration, methodDeclaration);
    }

    private void checkInnerPublicStaticTypes(ClassDeclaration classDeclaration, MethodDeclaration methodDeclaration) {
        if (this.hasInnerNonPublicStaticTypes(classDeclaration)) {
            this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.HAS_INADMISSIBLE_INNER_TYPES, (Object)classDeclaration.getQualifiedName()));
        }
    }

    private boolean hasInnerNonPublicStaticTypes(ClassDeclaration classDeclaration) {
        if (this.isJavaType(classDeclaration.getQualifiedName()) && JAVA_TYPES.contains(classDeclaration.getQualifiedName())) {
            return false;
        }
        Collection nestedTypes = classDeclaration.getNestedTypes();
        for (TypeDeclaration typeDeclaration : nestedTypes) {
            if (typeDeclaration.getModifiers().contains(Modifier.PUBLIC) && typeDeclaration.getModifiers().contains(Modifier.STATIC)) continue;
            return true;
        }
        return false;
    }

    private void checkInterface(InterfaceDeclaration interfaceDeclaration, MethodDeclaration methodDeclaration) {
        if (!this.isSuitableInterface(interfaceDeclaration)) {
            this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.INTERFACES_NOT_SUPPORTED, (Object)interfaceDeclaration.getQualifiedName()));
        }
    }

    private boolean isSuitableInterface(InterfaceDeclaration interfaceDeclaration) {
        return this.isJavaType(interfaceDeclaration.getQualifiedName()) && JAVA_TYPES.contains(interfaceDeclaration.getQualifiedName()) || this.isXMLType(interfaceDeclaration) || this.isAsyncType(interfaceDeclaration);
    }

    private boolean isAsyncType(InterfaceDeclaration interfaceDeclaration) {
        String qn = Signature.getTypeErasure((String)interfaceDeclaration.getQualifiedName());
        return qn.equals("javax.xml.ws.Response") || qn.equals("java.util.concurrent.Future") || qn.equals("javax.xml.ws.AsyncHandler");
    }

    private boolean isXMLType(InterfaceDeclaration interfaceDeclaration) {
        return AnnotationUtils.getAnnotation((Declaration)interfaceDeclaration, XmlType.class) != null;
    }

    private void checkIfRemoteObject(ClassDeclaration classDeclaration, MethodDeclaration methodDeclaration) {
        if (this.isRemoteObject(classDeclaration)) {
            this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.IS_REMOTE_OBJECT, (Object)classDeclaration.getQualifiedName()));
        }
    }

    private boolean isRemoteObject(ClassDeclaration classDeclaration) {
        Collection superInterfaces = classDeclaration.getSuperinterfaces();
        for (InterfaceType interfaceType : superInterfaces) {
            if (interfaceType.getDeclaration() == null || !interfaceType.getDeclaration().getQualifiedName().equals(REMOTE_OBJECT)) continue;
            return true;
        }
        return false;
    }

    private void checkAbstactType(ClassDeclaration classDeclaration, MethodDeclaration methodDeclaration) {
        if (classDeclaration.getModifiers().contains(Modifier.ABSTRACT) && this.environment instanceof EclipseAnnotationProcessorEnvironment) {
            EclipseAnnotationProcessorEnvironment eclipseEnvironment = (EclipseAnnotationProcessorEnvironment)this.environment;
            IJavaProject javaProject = eclipseEnvironment.getJavaProject();
            try {
                IType type = javaProject.findType(classDeclaration.getQualifiedName());
                ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
                IType[] subTypes = hierarchy.getAllSubtypes(type);
                if (subTypes.length > 0) {
                    IType[] iTypeArray = subTypes;
                    int n = subTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassDeclaration subTypeDeclaration;
                        TypeDeclaration typeDeclaration;
                        IType subType = iTypeArray[n2];
                        if (!Flags.isAbstract((int)subType.getFlags()) && (typeDeclaration = this.environment.getTypeDeclaration(subType.getFullyQualifiedName())) instanceof ClassDeclaration && (this.isRemoteObject(subTypeDeclaration = (ClassDeclaration)typeDeclaration) || this.hasInnerNonPublicStaticTypes(subTypeDeclaration) || this.implementsMultipleInterfaces(subTypeDeclaration) || this.implementsClassAndInterface(subTypeDeclaration))) {
                            this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.ABSTRACT_CLASS_NOT_IMPLEMENTED, (Object)classDeclaration.getQualifiedName()));
                        }
                        ++n2;
                    }
                } else {
                    this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.ABSTRACT_CLASS_NOT_IMPLEMENTED, (Object)classDeclaration.getQualifiedName()));
                }
            }
            catch (JavaModelException jme) {
                JAXWSCorePlugin.log(jme.getStatus());
            }
        }
    }

    private boolean implementsMultipleInterfaces(ClassDeclaration classDeclaration) {
        if (this.hasSuperClass(classDeclaration)) {
            return this.countAllowedInterfaces(classDeclaration.getSuperinterfaces()) > 1;
        }
        return false;
    }

    private boolean implementsClassAndInterface(ClassDeclaration classDeclaration) {
        if (!this.hasSuperClass(classDeclaration)) {
            return this.countAllowedInterfaces(classDeclaration.getSuperinterfaces()) > 0;
        }
        return false;
    }

    private boolean hasSuperClass(ClassDeclaration classDeclaration) {
        ClassType superClass = classDeclaration.getSuperclass();
        if (superClass.getDeclaration() != null) {
            String qualifiedName = superClass.getDeclaration().getQualifiedName();
            return qualifiedName.equals(Object.class.getName()) || qualifiedName.equals(Exception.class.getName());
        }
        return false;
    }

    private void checkMultipleInheritance(ClassDeclaration classDeclaration, MethodDeclaration methodDeclaration) {
        List<String> interfaceNames;
        if (this.implementsMultipleInterfaces(classDeclaration)) {
            interfaceNames = this.getAllowedInterfaceNames(classDeclaration.getSuperinterfaces());
            this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.IMPLEMENTS_MULTIPLE_INTERFACES, (Object[])new Object[]{classDeclaration.getQualifiedName(), interfaceNames.get(0), interfaceNames.get(1)}));
        }
        if (this.implementsClassAndInterface(classDeclaration)) {
            interfaceNames = this.getAllowedInterfaceNames(classDeclaration.getSuperinterfaces());
            this.printError(methodDeclaration.getPosition(), JAXWSCoreMessages.bind((String)JAXWSCoreMessages.INHERITANCE_AND_IMPLEMENTATION, (Object[])new Object[]{classDeclaration.getQualifiedName(), classDeclaration.getSuperclass().getDeclaration().getQualifiedName(), interfaceNames.get(0)}));
        }
    }

    private List<String> getAllowedInterfaceNames(Collection<InterfaceType> superInterfaces) {
        ArrayList<String> interfaceNames = new ArrayList<String>();
        for (InterfaceType interfaceType : superInterfaces) {
            InterfaceDeclaration superInterface;
            if (interfaceType.getDeclaration() == null || ALLOWED_IN_MULTIPLE_INHERITANCE.contains((superInterface = interfaceType.getDeclaration()).getQualifiedName())) continue;
            interfaceNames.add(superInterface.getQualifiedName());
        }
        return interfaceNames;
    }

    private int countAllowedInterfaces(Collection<InterfaceType> superInterfaces) {
        int count = 0;
        for (InterfaceType interfaceType : superInterfaces) {
            InterfaceDeclaration superInterface;
            if (interfaceType.getDeclaration() == null || ALLOWED_IN_MULTIPLE_INHERITANCE.contains((superInterface = interfaceType.getDeclaration()).getQualifiedName())) continue;
            ++count;
        }
        return count;
    }

    private boolean isJavaType(String typeName) {
        return typeName.startsWith("java.") || typeName.startsWith("javax.");
    }
}

