/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.annotations.core;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.annotations.core.AnnotationsCorePlugin;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.annotations.core.initialization.IAnnotationAttributeInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationDefinition {
    private static final String ATT_CLASS = "class";
    private static final String ATT_NAME = "name";
    private static final String ATT_RESTRICTED_TO = "restrictedTo";
    private static final String RESTRICTED_TO_CLASS_ONLY = "CLASS_ONLY";
    private static final String RESTRICTED_TO_INTERFACE_ONLY = "INTERFACE_ONLY";
    private static final String RESTRICTED_TO_ENUM_ONLY = "ENUM_ONLY";
    private static final String ELEM_TARGET_FILTER = "targetFilter";
    private static final String ATT_TARGET = "target";
    private IConfigurationElement configurationElement;
    private String category;
    private String annotationClassName;
    private Class<? extends Annotation> annotationClass;
    private List<ElementType> targets;
    private String name;
    private IAnnotationAttributeInitializer annotationInitializer;
    private String restictedTo;
    private boolean interfaceOnly;
    private boolean classOnly;
    private boolean enumOnly;
    private IType annotationType;
    private List<ElementType> annotationTypeTargets;
    private IJavaProject javaProject;
    private Boolean deprecated;

    public AnnotationDefinition(IConfigurationElement configurationElement, String category) {
        this.configurationElement = configurationElement;
        this.category = category;
        this.annotationClassName = AnnotationsManager.getAttributeValue(configurationElement, ATT_CLASS);
        this.name = AnnotationsManager.getAttributeValue(configurationElement, ATT_NAME);
        this.restictedTo = AnnotationsManager.getAttributeValue(configurationElement, ATT_RESTRICTED_TO);
        this.classOnly = this.restictedTo.equals(RESTRICTED_TO_CLASS_ONLY);
        this.interfaceOnly = this.restictedTo.equals(RESTRICTED_TO_INTERFACE_ONLY);
        this.enumOnly = this.restictedTo.equals(RESTRICTED_TO_ENUM_ONLY);
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getAnnotationClassName() {
        return this.annotationClassName;
    }

    public boolean isClassOnly() {
        return this.classOnly;
    }

    public boolean isInterfaceOnly() {
        return this.interfaceOnly;
    }

    public boolean isEnumOnly() {
        return this.enumOnly;
    }

    @Deprecated
    public Class<? extends Annotation> getAnnotationClass() {
        if (this.annotationClass == null) {
            try {
                Class<?> aClass = Class.forName(this.annotationClassName);
                if (aClass.isAnnotation()) {
                    this.annotationClass = Class.forName(this.annotationClassName);
                }
            }
            catch (ClassNotFoundException cnfe) {
                AnnotationsCorePlugin.log(cnfe);
            }
        }
        return this.annotationClass;
    }

    public IType getAnnotationType() {
        if (this.annotationType == null) {
            try {
                IType type;
                if (this.javaProject != null && (type = this.javaProject.findType(this.annotationClassName)) != null && type.isAnnotation()) {
                    this.annotationType = type;
                }
            }
            catch (JavaModelException jme) {
                AnnotationsCorePlugin.log(jme.getStatus());
            }
        }
        return this.annotationType;
    }

    @Deprecated
    public List<ElementType> getTargets() {
        if (this.targets == null) {
            Target target;
            this.targets = new LinkedList<ElementType>();
            Class<? extends Annotation> annotation = this.getAnnotationClass();
            if (annotation != null && (target = annotation.getAnnotation(Target.class)) != null) {
                this.targets.addAll(Arrays.asList(target.value()));
                List<ElementType> filteredTargets = this.getFilteredTargets(this.configurationElement);
                if (this.targets.containsAll(filteredTargets) && filteredTargets.size() < this.targets.size()) {
                    this.targets.removeAll(filteredTargets);
                }
            }
        }
        return this.targets;
    }

    public List<ElementType> getAnnotationTypeTargets() {
        if (this.annotationTypeTargets == null) {
            this.annotationTypeTargets = new LinkedList<ElementType>();
            try {
                IType type = this.getAnnotationType();
                if (type != null) {
                    List<ElementType> filteredTargets;
                    IAnnotation target = type.getAnnotation(Target.class.getCanonicalName());
                    if (!target.exists()) {
                        target = type.getAnnotation(Target.class.getSimpleName());
                    }
                    if (target.exists()) {
                        IMemberValuePair[] memberValuePairs;
                        IMemberValuePair[] iMemberValuePairArray = memberValuePairs = target.getMemberValuePairs();
                        int n = memberValuePairs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMemberValuePair memberValuePair = iMemberValuePairArray[n2];
                            Object value = memberValuePair.getValue();
                            if (value.getClass().isArray() && value.getClass().getComponentType().equals(String.class)) {
                                String[] objs;
                                String[] stringArray = objs = (String[])value;
                                int n3 = objs.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String obj = stringArray[n4];
                                    this.annotationTypeTargets.add(ElementType.valueOf(obj.substring(obj.lastIndexOf(46) + 1)));
                                    ++n4;
                                }
                            } else {
                                this.annotationTypeTargets.add(ElementType.valueOf(value.toString().substring(value.toString().lastIndexOf(46) + 1)));
                            }
                            ++n2;
                        }
                    }
                    if (this.annotationTypeTargets.containsAll(filteredTargets = this.getFilteredTargets(this.configurationElement)) && filteredTargets.size() < this.annotationTypeTargets.size()) {
                        this.annotationTypeTargets.removeAll(filteredTargets);
                    }
                }
            }
            catch (JavaModelException jme) {
                AnnotationsCorePlugin.log(jme.getStatus());
            }
        }
        return this.annotationTypeTargets;
    }

    public IAnnotationAttributeInitializer getAnnotationAttributeInitializer() {
        if (this.annotationInitializer == null) {
            try {
                IConfigurationElement configurationElement = AnnotationsManager.getAnnotationInitializerCache().get(this.getAnnotationClassName());
                if (configurationElement != null) {
                    this.annotationInitializer = (IAnnotationAttributeInitializer)configurationElement.createExecutableExtension(ATT_CLASS);
                }
            }
            catch (CoreException ce) {
                AnnotationsCorePlugin.log(ce.getStatus());
            }
        }
        return this.annotationInitializer;
    }

    private List<ElementType> getFilteredTargets(IConfigurationElement configurationElement) {
        ArrayList<ElementType> targets = new ArrayList<ElementType>(7);
        try {
            IConfigurationElement[] deprecatedTargets;
            IConfigurationElement[] iConfigurationElementArray = deprecatedTargets = configurationElement.getChildren(ELEM_TARGET_FILTER);
            int n = deprecatedTargets.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement deprecatedTargetElement = iConfigurationElementArray[n2];
                String target = AnnotationsManager.getAttributeValue(deprecatedTargetElement, ATT_TARGET);
                targets.add(ElementType.valueOf(target));
                ++n2;
            }
        }
        catch (IllegalArgumentException iae) {
            AnnotationsCorePlugin.log(iae);
        }
        return targets;
    }

    boolean isDeprecated() {
        if (this.deprecated == null) {
            IType type = this.getAnnotationType();
            if (type != null) {
                IAnnotation annotation = type.getAnnotation(Deprecated.class.getCanonicalName());
                if (!annotation.exists()) {
                    annotation = type.getAnnotation(Deprecated.class.getSimpleName());
                }
                this.deprecated = annotation.exists();
            } else {
                this.deprecated = false;
            }
        }
        return this.deprecated;
    }

    public void setJavaProject(IJavaProject javaProject) {
        if (this.javaProject == null || !this.javaProject.equals(javaProject)) {
            this.javaProject = javaProject;
            this.annotationType = null;
            this.annotationTypeTargets = null;
            this.deprecated = null;
        }
    }
}

