/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.StringTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class WebPropertiesUtil {
    private static final char[] BAD_CHARS = new char[]{':'};
    public static final String DEFAULT_JAVA_SOURCE_NAME = "Java Source";

    public static boolean updateWebContentNameAndProperties(IProject project, String webContentName, IProgressMonitor progressMonitor) throws CoreException {
        boolean success = false;
        if (project.exists() && project.isOpen()) {
            Path newPath = new Path(webContentName);
            if (WebPropertiesUtil.getModuleServerRoot(project).getProjectRelativePath().equals((Object)newPath)) {
                return false;
            }
            if (project.exists((IPath)newPath)) {
                Status status = new Status(4, "org.eclipse.jst.j2ee", 0, ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Could_not_rename_____2, (Object[])new Object[]{webContentName}), null);
                throw new CoreException((IStatus)status);
            }
            WebPropertiesUtil.moveWebContentFolder(project, webContentName, progressMonitor);
            WebPropertiesUtil.updateWebContentNamePropertiesOnly(project, webContentName, progressMonitor);
            success = true;
        }
        return success;
    }

    public static void updateWebContentNamePropertiesOnly(IProject project, String webContentName, IProgressMonitor progressMonitor) throws CoreException {
        Path newPath = new Path(webContentName);
        if (WebPropertiesUtil.getModuleServerRoot(project).equals((Object)newPath)) {
            return;
        }
        if (!WebPropertiesUtil.getModuleServerRoot(project).equals((Object)webContentName)) {
            IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)project);
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            IClasspathEntry[] newClasspath = new IClasspathEntry[classpath.length];
            int i = 0;
            while (i < classpath.length) {
                if (classpath[i].getEntryKind() == 1) {
                    IClasspathEntry library = classpath[i];
                    IPath libpath = library.getPath();
                    IPath modServerRootPath = WebPropertiesUtil.getModuleServerRoot(project).getFullPath();
                    if (modServerRootPath.isPrefixOf(libpath)) {
                        IPath prunedPath = libpath.removeFirstSegments(modServerRootPath.segmentCount());
                        Path relWebContentPath = new Path(String.valueOf(webContentName) + "/" + prunedPath.toString());
                        IFile absWebContentPath = project.getFile((IPath)relWebContentPath);
                        IPath srcAttachmentPath = library.getSourceAttachmentPath();
                        if (srcAttachmentPath != null) {
                            prunedPath = srcAttachmentPath.removeFirstSegments(modServerRootPath.segmentCount());
                        }
                        IFile absWebContentSrcAttachmentPath = project.getFile((IPath)relWebContentPath);
                        newClasspath[i] = JavaCore.newLibraryEntry((IPath)absWebContentPath.getFullPath(), (IPath)absWebContentSrcAttachmentPath.getFullPath(), (IPath)library.getSourceAttachmentRootPath(), (boolean)library.isExported());
                    } else {
                        newClasspath[i] = classpath[i];
                    }
                } else {
                    newClasspath[i] = classpath[i];
                }
                IFolder outputFolder = project.getFolder(WebPropertiesUtil.getModuleServerRoot(project).getFullPath());
                javaProject.setRawClasspath(newClasspath, outputFolder.getFullPath(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                ++i;
            }
        }
    }

    public static void moveWebContentFolder(IProject project, String webContentName, IProgressMonitor progressMonitor) throws CoreException {
        Path newPath = new Path(webContentName);
        if (!project.exists((IPath)newPath)) {
            if (newPath.segmentCount() > 1) {
                int i = newPath.segmentCount() - 1;
                while (i > 0) {
                    IPath tempPath = newPath.removeLastSegments(i);
                    IFolder tempFolder = project.getFolder(tempPath);
                    if (!tempFolder.exists()) {
                        tempFolder.create(true, true, null);
                    }
                    --i;
                }
            }
            newPath = project.getFullPath().append((IPath)newPath);
            IFolder webContentRoot = WebPropertiesUtil.getModuleServerRoot(project);
            IPath oldPath = webContentRoot.getProjectRelativePath();
            webContentRoot.move((IPath)newPath, 3, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            int i = 0;
            while (i < oldPath.segmentCount()) {
                IPath tempPath = oldPath.removeLastSegments(i);
                IFolder tempFolder = project.getFolder(tempPath);
                if (tempFolder.exists() && tempFolder.members().length == 0) {
                    tempFolder.delete(true, true, null);
                }
                ++i;
            }
        }
    }

    protected static void synch(IProject project, IProgressMonitor monitor) {
        block21: {
            IProgressMonitor localMonitor = monitor;
            try {
                if (localMonitor == null) {
                    localMonitor = new NullProgressMonitor();
                }
                localMonitor.beginTask(ProjectSupportResourceHandler.Sychronize_Class_Path_UI_, 4);
                IContainer lib_folder = WebPropertiesUtil.getWebLibFolder(project);
                if (lib_folder == null || !lib_folder.isAccessible()) {
                    return;
                }
                try {
                    IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)project);
                    IPath lib_path = lib_folder.getProjectRelativePath();
                    IPath lib_full_path = lib_folder.getFullPath();
                    IClasspathEntry[] cp = javaProject.getRawClasspath();
                    boolean needsToBeModified = false;
                    Hashtable<IPath, IResource> lib_jars = new Hashtable<IPath, IResource>();
                    IResource[] children = lib_folder.members();
                    localMonitor.subTask(ProjectSupportResourceHandler.Catalog_Lib_Directory__UI_);
                    int j = 0;
                    while (j < children.length) {
                        IResource child = children[j];
                        if (child.getType() == 1 && (child.getFullPath().toString().toLowerCase().endsWith(".jar") || child.getFullPath().toString().toLowerCase().endsWith(".zip"))) {
                            lib_jars.put(child.getFullPath(), child);
                        }
                        ++j;
                    }
                    localMonitor.worked(1);
                    localMonitor.subTask(ProjectSupportResourceHandler.Update_ClassPath__UI_);
                    Vector<IClasspathEntry> newClassPathVector = new Vector<IClasspathEntry>();
                    int j2 = 0;
                    while (j2 < cp.length) {
                        if (cp[j2].getPath().toString().startsWith(lib_path.toString()) || cp[j2].getPath().toString().startsWith(lib_full_path.toString())) {
                            if (lib_jars.get(cp[j2].getPath()) != null) {
                                newClassPathVector.add(cp[j2]);
                                lib_jars.remove(cp[j2].getPath());
                            } else {
                                needsToBeModified = true;
                            }
                        } else {
                            localMonitor.subTask(String.valueOf(ProjectSupportResourceHandler.Catalog_Lib_Directory__UI_) + cp[j2].getPath());
                            newClassPathVector.add(cp[j2]);
                        }
                        ++j2;
                    }
                    localMonitor.worked(1);
                    localMonitor.subTask(ProjectSupportResourceHandler.Update_ClassPath__UI_);
                    Enumeration aenum = lib_jars.keys();
                    while (aenum.hasMoreElements()) {
                        IPath path = (IPath)aenum.nextElement();
                        newClassPathVector.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                        needsToBeModified = true;
                    }
                    localMonitor.worked(1);
                    localMonitor.subTask(ProjectSupportResourceHandler.Set_ClassPath__UI_);
                    IClasspathEntry[] newClassPathArray = new IClasspathEntry[newClassPathVector.size()];
                    int j3 = 0;
                    while (j3 < newClassPathArray.length) {
                        newClassPathArray[j3] = (IClasspathEntry)newClassPathVector.get(j3);
                        ++j3;
                    }
                    if (!needsToBeModified) break block21;
                    try {
                        javaProject.setRawClasspath(newClassPathArray, localMonitor);
                    }
                    catch (Exception e) {
                        WebPlugin.logError(e);
                    }
                }
                catch (ClassCastException ex) {
                    WebPlugin.logError(ex);
                }
                catch (CoreException ex) {
                    WebPlugin.logError(ex);
                }
            }
            finally {
                localMonitor.done();
            }
        }
    }

    public static void updateContextRoot(IProject project, String contextRoot) {
    }

    public static String validateContextRoot(String contextRoot) {
        String errorMessage;
        block7: {
            if (contextRoot == null) {
                return null;
            }
            errorMessage = null;
            String name = contextRoot;
            if (name.equals("")) {
                errorMessage = ProjectSupportResourceHandler.Context_Root_cannot_be_empty_2;
                return errorMessage;
            }
            if (name.trim().equals(name)) {
                StringTokenizer stok = new StringTokenizer(name, ".");
                while (stok.hasMoreTokens()) {
                    String token = stok.nextToken();
                    int i = 0;
                    while (i < token.length()) {
                        int cp = UTF16.charAt((String)token, (int)i);
                        if (token.charAt(i) != '_' && token.charAt(i) != '-' && token.charAt(i) != '/' && !Character.isLetterOrDigit(token.charAt(i)) && !Character.isWhitespace(token.charAt(i))) {
                            String invalidCharString = null;
                            invalidCharString = UTF16.getCharCount((int)cp) > 1 ? UTF16.valueOf((int)cp) : new Character(token.charAt(i)).toString();
                            Object[] invalidChar = new Object[]{invalidCharString};
                            errorMessage = ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.The_character_is_invalid_in_a_context_root, (Object[])invalidChar);
                            break block7;
                        }
                        i += UTF16.getCharCount((int)cp);
                    }
                }
            } else {
                errorMessage = ProjectSupportResourceHandler.Names_cannot_begin_or_end_with_whitespace_5;
            }
        }
        return errorMessage;
    }

    private static boolean contains(String str, char[] chars) {
        int i = 0;
        while (i < chars.length) {
            if (str.indexOf(chars[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String validateFolderName(String folderName) {
        if (folderName.length() == 0) {
            return ProjectSupportResourceHandler.Folder_name_cannot_be_empty_2;
        }
        if (WebPropertiesUtil.contains(folderName, BAD_CHARS)) {
            return ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Folder_name_is_not_valid, (Object[])new Object[]{folderName});
        }
        return null;
    }

    public static String validateWebContentName(String webContentName, IProject project, String javaSourceName) {
        IJavaProject javaProject;
        String msg = WebPropertiesUtil.validateFolderName(webContentName);
        if (msg != null) {
            return msg;
        }
        if (javaSourceName != null && webContentName.equals(javaSourceName)) {
            return ProjectSupportResourceHandler.Folder_names_cannot_be_equal_4;
        }
        if (project != null && (javaProject = JemProjectUtilities.getJavaProject((IProject)project)) != null) {
            try {
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IPath path;
                    String rootFolder;
                    IResource resource;
                    IPackageFragmentRoot root = roots[i];
                    if (!root.isArchive() && (resource = root.getCorrespondingResource()).getType() == 2 && webContentName.equals(rootFolder = (path = resource.getFullPath()).segment(1))) {
                        if (root.getKind() == 1) {
                            return ProjectSupportResourceHandler.Folder_name_cannot_be_the_same_as_Java_source_folder_5;
                        }
                        return ProjectSupportResourceHandler.Folder_name_cannot_be_the_same_as_Java_class_folder_6;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    public static IContainer updateJavaSourceName(IProject project, IContainer oldSourceFolder, String javaSourceName, IProgressMonitor progressMonitor) throws CoreException {
        Path newPath;
        IFolder newSourceFolder = null;
        if (oldSourceFolder != null && !project.getFolder((IPath)(newPath = javaSourceName == null ? new Path(DEFAULT_JAVA_SOURCE_NAME) : new Path(javaSourceName))).getFullPath().equals((Object)oldSourceFolder.getFullPath())) {
            oldSourceFolder.move((IPath)newPath, 3, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            JemProjectUtilities.removeFromJavaClassPath((IProject)project, (IResource)oldSourceFolder);
            newSourceFolder = project.getFolder((IPath)newPath);
            JemProjectUtilities.appendJavaClassPath((IProject)project, (IClasspathEntry)JavaCore.newSourceEntry((IPath)project.getFolder((IPath)newPath).getFullPath()));
        }
        return newSourceFolder;
    }

    public static IContainer getJavaSourceFolder(IProject project) {
        IContainer sourceFolder;
        List sourceRoots = JemProjectUtilities.getSourceContainers((IProject)project);
        IContainer oldSourceFolder = null;
        if (sourceRoots != null && sourceRoots.size() == 1 && (sourceFolder = (IContainer)sourceRoots.get(0)) instanceof IFolder) {
            oldSourceFolder = sourceFolder;
        }
        return oldSourceFolder;
    }

    public static IFolder getModuleServerRoot(IProject project) {
        IPath compRootPath = ComponentCore.createComponent((IProject)project).getRootFolder().getUnderlyingFolder().getProjectRelativePath();
        return project.getFolder(compRootPath);
    }

    public static IVirtualFolder getWebLibFolder(IVirtualComponent webComponent) {
        Path path = new Path("WEB-INF/lib");
        IVirtualFolder libFolder = webComponent.getRootFolder().getFolder((IPath)path);
        return libFolder;
    }

    public static IContainer getWebLibFolder(IProject project) {
        return WebPropertiesUtil.getWebLibFolder(ComponentCore.createComponent((IProject)project)).getUnderlyingFolder();
    }
}

