/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.flat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.internal.flat.IFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.IFlattenParticipantProvider;

public class FlattenParticipantModel {
    private static FlattenParticipantModel model;
    private ArrayList<FlattenParticipantProviderWrapper> providers;

    public static FlattenParticipantModel getDefault() {
        if (model == null) {
            model = new FlattenParticipantModel();
        }
        return model;
    }

    public IFlattenParticipant getParticipant(String id) {
        return this.getParticipant(id, null);
    }

    public IFlattenParticipant getParticipant(String id, Properties properties) {
        IFlattenParticipantProvider[] providers = this.getProviders();
        IFlattenParticipant result = null;
        int i = 0;
        while (i < providers.length) {
            result = providers[i].findParticipant(id, properties);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    protected IFlattenParticipantProvider[] getProviders() {
        if (this.providers == null) {
            this.loadProviders();
        }
        return this.providers.toArray(new IFlattenParticipantProvider[this.providers.size()]);
    }

    protected void loadProviders() {
        ArrayList<FlattenParticipantProviderWrapper> tmp = new ArrayList<FlattenParticipantProviderWrapper>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore", "flattenParticipantProvider");
        int j = 0;
        while (j < cf.length) {
            tmp.add(this.getWrapper(cf[j]));
            ++j;
        }
        Collections.sort(tmp, new Comparator<FlattenParticipantProviderWrapper>(){

            @Override
            public int compare(FlattenParticipantProviderWrapper o1, FlattenParticipantProviderWrapper o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o2.getWeight() - o1.getWeight();
            }
        });
        this.providers = tmp;
    }

    private FlattenParticipantProviderWrapper getWrapper(IConfigurationElement element) {
        return new FlattenParticipantProviderWrapper(element);
    }

    private static class FlattenParticipantProviderWrapper
    implements IFlattenParticipantProvider {
        private IConfigurationElement cf;
        private int weight;
        private IFlattenParticipantProvider delegate;

        public FlattenParticipantProviderWrapper(IConfigurationElement element) {
            this.cf = element;
            String s = element.getAttribute("weight");
            try {
                this.weight = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                this.weight = 0;
            }
        }

        public int getWeight() {
            return this.weight;
        }

        public IFlattenParticipant findParticipant(String id, Properties props) {
            if (this.delegate == null) {
                this.loadDelegate();
            }
            return this.delegate == null ? null : this.delegate.findParticipant(id, props);
        }

        private void loadDelegate() {
            try {
                this.delegate = (IFlattenParticipantProvider)this.cf.createExecutableExtension("class");
            }
            catch (CoreException coreException) {}
        }
    }
}

