/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.wst.xml.ui.internal.wizards.ExampleProjectCreationWizard;
import org.eclipse.wst.xml.ui.internal.wizards.XMLWizardsMessages;

public class ExampleProjectCreationWizardPage
extends WizardNewProjectCreationPage {
    private IConfigurationElement configurationElement;

    public ExampleProjectCreationWizardPage(int pageNumber, IConfigurationElement elem) {
        super("page" + pageNumber);
        this.configurationElement = elem;
        String name = this.getAttribute(elem, "name");
        this.setInitialProjectName(this.calculateInitialProjectName(name));
        this.setDescription(this.getAttribute(this.configurationElement, "pagedescription"));
        this.setTitle(this.getAttribute(this.configurationElement, "pagetitle"));
    }

    protected String calculateInitialProjectName(String projectName) {
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!projectHandle.exists()) {
            return projectName;
        }
        int i = 1;
        while (i < 10) {
            projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(projectName) + i);
            if (!projectHandle.exists()) {
                return String.valueOf(projectName) + i;
            }
            ++i;
        }
        return String.valueOf(projectName) + "9";
    }

    private String getAttribute(IConfigurationElement elem, String tag) {
        String res = elem.getAttribute(tag);
        if (res == null) {
            return String.valueOf('!') + tag + '!';
        }
        return res;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String projectName = this.getProjectName();
        if (projectName == null) {
            return false;
        }
        IWizard wizard = this.getWizard();
        if (wizard instanceof ExampleProjectCreationWizard) {
            IWizardPage[] pages = wizard.getPages();
            int i = 0;
            while (i < pages.length) {
                if (pages[i] != this && pages[i] instanceof ExampleProjectCreationWizardPage && projectName.equals(((ExampleProjectCreationWizardPage)pages[i]).getProjectName())) {
                    this.setErrorMessage(XMLWizardsMessages.ExampleProjectCreationWizardPage_error_alreadyexists);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

