/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal.driver;

import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.internal.driver.AbstractDTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.CatalogStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapterFactory;
import org.eclipse.jpt.jpa.db.internal.driver.FoldingStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.LowerCaseFoldingStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.UnknownCatalogStrategy;

class Informix
extends AbstractDTPDriverAdapter {
    private static final char[] EXTENDED_REGULAR_NAME_START_CHARACTERS = new char[]{'_'};
    private static final char[] EXTENDED_REGULAR_NAME_PART_CHARACTERS = new char[]{'$'};

    Informix(Database database) {
        super(database);
    }

    CatalogStrategy buildCatalogStrategy() {
        return new UnknownCatalogStrategy(this.database.getDTPDatabase());
    }

    FoldingStrategy buildFoldingStrategy() {
        return LowerCaseFoldingStrategy.instance();
    }

    char[] getExtendedRegularNameStartCharacters() {
        return EXTENDED_REGULAR_NAME_START_CHARACTERS;
    }

    char[] getExtendedRegularNamePartCharacters() {
        return EXTENDED_REGULAR_NAME_PART_CHARACTERS;
    }

    static class Factory
    implements DTPDriverAdapterFactory {
        private static final String[] VENDORS = new String[]{"Informix"};

        Factory() {
        }

        public String[] getSupportedVendors() {
            return VENDORS;
        }

        public DTPDriverAdapter buildAdapter(Database database) {
            return new Informix(database);
        }
    }
}

