/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.GenericServerBehaviour;
import org.eclipse.jst.server.generic.core.internal.GenericServerCoreMessages;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;

public class GenericServerLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            this.abort(GenericServerCoreMessages.missingServer, null, 150);
        }
        GenericServerBehaviour genericServer = (GenericServerBehaviour)((Object)server.loadAdapter(ServerBehaviourDelegate.class, null));
        try {
            genericServer.setupLaunch(launch, mode, monitor);
            if (genericServer.getServer().getServerType().supportsRemoteHosts() && !SocketUtil.isLocalhost((String)genericServer.getServer().getHost())) {
                return;
            }
            String mainTypeName = genericServer.getStartClassName();
            IVMInstall vm = this.verifyVMInstall(configuration);
            IVMRunner runner = vm.getVMRunner(mode);
            if (runner == null && "profile".equals(mode)) {
                runner = vm.getVMRunner("run");
            }
            if (runner == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.runModeNotSupported, null));
            }
            File workingDir = this.verifyWorkingDirectory(configuration);
            String workingDirName = null;
            if (workingDir != null) {
                workingDirName = workingDir.getAbsolutePath();
            }
            String pgmArgs = this.getProgramArguments(configuration);
            String vmArgs = this.getVMArguments(configuration);
            String[] envp = this.getEnvironment(configuration);
            ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
            Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
            String[] classpath = this.getClasspath(configuration);
            VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
            runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
            runConfig.setVMArguments(execArgs.getVMArgumentsArray());
            runConfig.setWorkingDirectory(workingDirName);
            runConfig.setEnvironment(envp);
            runConfig.setVMSpecificAttributesMap(vmAttributesMap);
            String[] bootpath = this.getBootpath(configuration);
            if (bootpath != null && bootpath.length > 0) {
                runConfig.setBootClassPath(bootpath);
            }
            this.setDefaultSourceLocator(launch, configuration);
            if ("profile".equals(mode)) {
                try {
                    ServerProfilerDelegate.configureProfiling((ILaunch)launch, (IVMInstall)vm, (VMRunnerConfiguration)runConfig, (IProgressMonitor)monitor);
                }
                catch (CoreException ce) {
                    genericServer.stopImpl();
                    throw ce;
                }
            }
            genericServer.startPingThread();
            runner.run(runConfig, launch, monitor);
            genericServer.setProcess(launch.getProcesses()[0]);
        }
        catch (CoreException e) {
            Trace.trace((byte)2, "error launching generic server", e);
            genericServer.terminate();
            throw e;
        }
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, CorePlugin.getDefault().getBundle().getSymbolicName(), code, message, exception));
    }
}

