/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.internet.monitor.core.internal.IContentFilter;
import org.eclipse.wst.internet.monitor.core.internal.http.ResendHTTPRequest;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;
import org.eclipse.wst.internet.monitor.ui.internal.Trace;
import org.eclipse.wst.internet.monitor.ui.internal.custom.SashForm;
import org.eclipse.wst.internet.monitor.ui.internal.provisional.ContentViewer;
import org.eclipse.wst.internet.monitor.ui.internal.view.Viewer;
import org.eclipse.wst.internet.monitor.ui.internal.viewers.ByteViewer;
import org.eclipse.wst.internet.monitor.ui.internal.viewers.HeaderViewer;

public class ViewerManager {
    private boolean displayHeaderInf;
    protected ContentViewer reqViewer;
    protected ContentViewer respViewer;
    protected Viewer requestViewer;
    protected Viewer responseViewer;
    protected HeaderViewer reqHeader;
    protected HeaderViewer respHeader;
    protected Composite reqComp;
    protected Composite respComp;
    protected List<Viewer> viewers;
    protected Request request;
    protected SashForm reqSash;
    protected SashForm respSash;
    protected List<IContentFilter> filters = new ArrayList<IContentFilter>();

    public ViewerManager(Composite reqParent, Composite respParent) {
        this.reqSash = new SashForm(reqParent, 512);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        this.reqSash.setLayout((Layout)layout);
        this.reqSash.setLayoutData(new GridData(1808));
        this.respSash = new SashForm(respParent, 512);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        this.respSash.setLayout((Layout)layout);
        this.respSash.setLayoutData(new GridData(1808));
        this.reqComp = this.reqSash;
        this.respComp = this.respSash;
        this.reqHeader = new HeaderViewer(this.reqSash, HeaderViewer.REQUEST_HEADER);
        this.respHeader = new HeaderViewer(this.respSash, HeaderViewer.RESPONSE_HEADER);
        this.reqViewer = new ByteViewer();
        this.reqViewer.init(this.reqSash);
        this.respViewer = new ByteViewer();
        this.respViewer.init(this.respSash);
        this.reqSash.setWeights(new int[]{10, 90});
        this.respSash.setWeights(new int[]{10, 90});
        this.setDisplayHeaderInfo(MonitorUIPlugin.getShowHeaderPreference());
        this.loadAvailableViewers();
    }

    protected Viewer getDefaultViewer(String name) {
        if (name == null) {
            return null;
        }
        String name2 = name.toLowerCase();
        if (name2.endsWith(".xml")) {
            return this.findViewer("org.eclipse.wst.internet.monitor.viewers.xml");
        }
        if (name2.endsWith(".html")) {
            return this.findViewer("org.eclipse.wst.internet.monitor.viewers.browser");
        }
        if (name2.endsWith(".gif") || name2.endsWith(".jpg") || name2.endsWith(".jpeg") || name2.endsWith(".png")) {
            return this.findViewer("org.eclipse.wst.internet.monitor.viewers.image");
        }
        return this.findViewer("org.eclipse.wst.internet.monitor.viewers.byte");
    }

    protected Viewer findViewer(String id) {
        if (id == null) {
            return null;
        }
        for (Viewer viewer : this.viewers) {
            if (!id.equals(viewer.getId())) continue;
            return viewer;
        }
        return null;
    }

    private void loadAvailableViewers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.internet.monitor.ui", "viewers");
        int size = cf.length;
        this.viewers = new ArrayList<Viewer>(size);
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            this.viewers.add(new Viewer(ce));
            ++n2;
        }
    }

    public void setDisplayHeaderInfo(boolean b) {
        this.displayHeaderInf = b;
        this.reqHeader.setDisplayHeader(b);
        this.respHeader.setDisplayHeader(b);
        this.reqSash.setSimpleLayout(b);
        this.respSash.setSimpleLayout(b);
        this.reqSash.layout(true);
        this.respSash.layout(true);
        MonitorUIPlugin.setShowHeaderPreference(b);
        if (b) {
            this.reqHeader.setEditable(false);
            if (this.request instanceof ResendHTTPRequest && this.request.getResponse(1) == null) {
                this.reqHeader.setEditable(true);
            }
        }
    }

    public boolean getDisplayHeaderInfo() {
        return this.displayHeaderInf;
    }

    public void setRequest(Request rr) {
        if (this.request instanceof ResendHTTPRequest && this.request.getResponse(3) == null) {
            ResendHTTPRequest resRequest = (ResendHTTPRequest)this.request;
            byte[] content = this.reqViewer.getContent();
            byte[] b = resRequest.getRequest(2);
            if (content != null && b != null && !MonitorUIPlugin.parse(b).equals(MonitorUIPlugin.parse(content))) {
                resRequest.setRequest(content, 2);
            }
            byte[] header = this.reqHeader.getContent();
            b = resRequest.getRequest(1);
            if (header != null && b != null && !MonitorUIPlugin.parse(b).equals(MonitorUIPlugin.parse(header))) {
                resRequest.setRequest(header, 1);
            }
        }
        this.reqHeader.setRequestResponse(rr);
        this.respHeader.setRequestResponse(rr);
        byte[] b = null;
        if (rr != null) {
            b = this.filter(rr.getRequest(2));
        }
        this.reqViewer.setContent(b);
        b = null;
        if (rr != null) {
            b = this.filter(rr.getResponse(2));
        }
        this.respViewer.setContent(b);
        this.request = rr;
        if (this.request instanceof ResendHTTPRequest && this.request.getResponse(3) == null) {
            if (this.displayHeaderInf) {
                this.reqHeader.setEditable(true);
            }
            this.reqViewer.setEditable(true);
        } else {
            if (this.displayHeaderInf) {
                this.reqHeader.setEditable(false);
            }
            this.reqViewer.setEditable(false);
        }
    }

    public void addFilter(IContentFilter filter) {
        this.filters.add(filter);
        this.setRequest(this.request);
    }

    public void removeFilter(IContentFilter filter) {
        this.filters.remove(filter);
        this.setRequest(this.request);
    }

    protected byte[] filter(byte[] b) {
        if (b == null) {
            return null;
        }
        for (IContentFilter filter : this.filters) {
            try {
                b = filter.filter(this.request, false, b);
            }
            catch (Exception e) {
                if (!Trace.SEVERE) continue;
                Trace.trace("/severe", "Error while filtering with " + filter.getId(), e);
            }
        }
        return b;
    }

    public List getRequestViewers() {
        Iterator<Viewer> iterator = this.viewers.iterator();
        ArrayList<Viewer> temp = new ArrayList<Viewer>();
        while (iterator.hasNext()) {
            Viewer viewer = iterator.next();
            if (!viewer.isRequestViewer()) continue;
            temp.add(viewer);
        }
        return temp;
    }

    public List getResponseViewers() {
        Iterator<Viewer> iterator = this.viewers.iterator();
        ArrayList<Viewer> temp = new ArrayList<Viewer>();
        while (iterator.hasNext()) {
            Viewer viewer = iterator.next();
            if (!viewer.isResponseViewer()) continue;
            temp.add(viewer);
        }
        return temp;
    }

    public void setRequestViewer(Viewer viewer) {
        if (viewer != null && viewer.equals(this.requestViewer)) {
            return;
        }
        this.setRequest(this.request);
        this.reqViewer.dispose();
        this.requestViewer = viewer;
        if (viewer != null) {
            this.reqViewer = viewer.createViewer();
            this.reqViewer.setEncodings(viewer.getEncodings());
        } else {
            this.reqViewer = null;
        }
        if (this.reqViewer == null) {
            return;
        }
        this.reqViewer.init(this.reqComp);
        byte[] b = null;
        if (this.request != null) {
            b = this.filter(this.request.getRequest(2));
            if (this.request instanceof ResendHTTPRequest && this.request.getResponse(1) == null) {
                this.reqViewer.setEditable(true);
            } else {
                this.reqViewer.setEditable(false);
            }
        }
        this.reqViewer.setContent(b);
        this.reqComp.layout(true);
    }

    public void setResponseViewer(Viewer viewer) {
        if (viewer != null && viewer.equals(this.responseViewer)) {
            return;
        }
        this.respViewer.dispose();
        this.responseViewer = viewer;
        if (viewer != null) {
            this.respViewer = viewer.createViewer();
            this.respViewer.setEncodings(viewer.getEncodings());
        } else {
            this.respViewer = null;
        }
        if (this.respViewer == null) {
            return;
        }
        this.respViewer.init(this.respComp);
        byte[] b = null;
        if (this.request != null) {
            b = this.filter(this.request.getResponse(2));
        }
        this.respViewer.setContent(b);
        this.respComp.layout(true);
    }

    public ContentViewer getCurrentRequestViewer() {
        return this.reqViewer;
    }

    public HeaderViewer getCurrentRequestHeaderViewer() {
        return this.reqHeader;
    }
}

