/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.resolvers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.resolvers.DefaultReferenceResolver;
import org.eclipse.wst.common.componentcore.resolvers.IReferenceResolver;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ReferenceResolverUtil {
    public static ReferenceResolverUtil instance = null;
    private HashMap<String, ReferenceResolverWrapper> resolvers = null;
    private ArrayList<IReferenceResolver> sorted = null;
    private DefaultReferenceResolver defaultResolver = new DefaultReferenceResolver();

    public static ReferenceResolverUtil getDefault() {
        if (instance == null) {
            instance = new ReferenceResolverUtil();
        }
        return instance;
    }

    public IReferenceResolver[] getResolvers() {
        if (this.resolvers == null || this.sorted == null) {
            this.loadResolvers();
        }
        if (this.sorted.isEmpty()) {
            return new IReferenceResolver[0];
        }
        return this.sorted.toArray(new IReferenceResolver[this.sorted.size()]);
    }

    public IReferenceResolver getResolver(IVirtualComponent context, ReferencedComponent reference) {
        this.getResolvers();
        for (IReferenceResolver resolver : this.sorted) {
            if (!resolver.canResolve(context, reference)) continue;
            return resolver;
        }
        return this.defaultResolver;
    }

    public IReferenceResolver getResolver(IVirtualReference reference) {
        this.getResolvers();
        for (IReferenceResolver resolver : this.sorted) {
            if (!resolver.canResolve(reference)) continue;
            return resolver;
        }
        return this.defaultResolver;
    }

    protected void loadResolvers() {
        HashMap<String, ReferenceResolverWrapper> map = new HashMap<String, ReferenceResolverWrapper>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.common.modulecore", "referenceResolver");
        String id = null;
        int j = 0;
        while (j < cf.length) {
            id = cf[j].getAttribute("id");
            try {
                map.put(id, new ReferenceResolverWrapper(id, (IReferenceResolver)cf[j].createExecutableExtension("class"), cf[j].getAttribute("weight")));
            }
            catch (CoreException coreException) {}
            ++j;
        }
        ArrayList list = new ArrayList(map.values());
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof ReferenceResolverWrapper)) {
                    return -1;
                }
                if (!(o2 instanceof ReferenceResolverWrapper)) {
                    return 1;
                }
                return ((ReferenceResolverWrapper)o2).getWeight() - ((ReferenceResolverWrapper)o1).getWeight();
            }
        };
        Collections.sort(list, comparator);
        ArrayList<IReferenceResolver> sorted = new ArrayList<IReferenceResolver>();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            sorted.add(((ReferenceResolverWrapper)i.next()).getResolver());
        }
        this.sorted = sorted;
        this.resolvers = map;
    }

    protected class ReferenceResolverWrapper {
        private String id;
        private IReferenceResolver resolver;
        private int weight;

        public ReferenceResolverWrapper(String id, IReferenceResolver resolver, String weight) {
            this.id = id;
            this.resolver = resolver;
            try {
                this.weight = Integer.parseInt(weight);
            }
            catch (NumberFormatException numberFormatException) {
                this.weight = 1000;
            }
        }

        public int getWeight() {
            return this.weight;
        }

        public String getId() {
            return this.id;
        }

        public IReferenceResolver getResolver() {
            return this.resolver;
        }
    }
}

