/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.navigator.internal.LoadingDDUIJob;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.ClearJeePlaceHolderJob;
import org.eclipse.jst.jee.ui.internal.navigator.JEE5ContentProvider;
import org.eclipse.jst.jee.ui.internal.navigator.LoadingGroupProvider;

public class LoadingJeeDDJob
extends Job {
    private final Viewer viewer;
    private final JEE5ContentProvider rootProvider;
    private final IProject project;
    private final LoadingGroupProvider provider;

    public LoadingJeeDDJob(Viewer viewer2, LoadingGroupProvider provider, IProject project, JEE5ContentProvider rootProvider) {
        super(provider.getText());
        this.viewer = viewer2;
        this.provider = provider;
        this.project = project;
        this.rootProvider = rootProvider;
    }

    protected IStatus run(IProgressMonitor arg0) {
        LoadingDDUIJob updateUIJob = new LoadingDDUIJob((StructuredViewer)this.viewer, this.provider.getPlaceHolder());
        updateUIJob.schedule();
        ArrayList<AbstractGroupProvider> children = new ArrayList<AbstractGroupProvider>();
        AbstractGroupProvider rootObject = null;
        try {
            try {
                rootObject = this.rootProvider != null ? this.rootProvider.getNewContentProviderInstance(this.project) : null;
                this.rootProvider.registerProvider(this.project, rootObject);
                if (rootObject != null) {
                    children.add(rootObject);
                }
            }
            catch (IllegalStateException e) {
                if (!this.project.isAccessible()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    this.provider.dispose();
                    new ClearJeePlaceHolderJob((AbstractTreeViewer)this.viewer, this.provider, this.project, children.toArray()).schedule();
                    return iStatus;
                }
                throw e;
            }
        }
        finally {
            this.provider.dispose();
            new ClearJeePlaceHolderJob((AbstractTreeViewer)this.viewer, this.provider, this.project, children.toArray()).schedule();
        }
        return Status.OK_STATUS;
    }
}

