/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import java.util.Collection;
import javax.jws.WebMethod;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

public class WebMethodPublicStaticFinalRule
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebMethod.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            MethodDeclaration methodDeclaration;
            if (!(declaration instanceof MethodDeclaration) || !((methodDeclaration = (MethodDeclaration)declaration).getDeclaringType() instanceof ClassDeclaration)) continue;
            Collection modifiers = methodDeclaration.getModifiers();
            if (!modifiers.contains(Modifier.PUBLIC)) {
                this.printFixableError(methodDeclaration.getPosition(), JAXWSCoreMessages.WEBMETHOD_ONLY_ON_PUBLIC_METHODS);
            }
            if (modifiers.contains(Modifier.FINAL)) {
                this.printFixableError(methodDeclaration.getPosition(), JAXWSCoreMessages.WEBMETHOD_NO_FINAL_MODIFIER_ALLOWED);
            }
            if (!modifiers.contains(Modifier.STATIC)) continue;
            this.printFixableError(methodDeclaration.getPosition(), JAXWSCoreMessages.WEBMETHOD_NO_STATIC_MODIFIER_ALLOWED);
        }
    }
}

