/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentPartitioningChangedEvent;
import org.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension2;
import org.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationReconcilerExtension;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class StructuredPresentationReconciler
implements IPresentationReconciler,
IPresentationReconcilerExtension {
    static final String TRACKED_PARTITION = "__reconciler_tracked_partition";
    private static final boolean _trace = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/structuredPresentationReconciler"));
    private static final boolean _traceTime = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/structuredPresentationReconciler/time"));
    private static final String TRACE_PREFIX = "StructuredPresentationReconciler: ";
    private long time0;
    private long time1;
    private Map fDamagers;
    private Map fRepairers;
    private ITextViewer fViewer;
    private InternalListener fInternalListener = new InternalListener();
    private String fPositionCategory;
    private IPositionUpdater fPositionUpdater;
    private TypedPosition fRememberedPosition;
    private boolean fDocumentPartitioningChanged = false;
    private IRegion fChangedDocumentPartitions = null;
    private List fRecordedDamages = new ArrayList(2);
    private String fPartitioning = "__dftl_partitioning";
    private IDocument fLastDocument;

    public StructuredPresentationReconciler() {
        this.fPositionCategory = TRACKED_PARTITION + this.hashCode();
        this.fPositionUpdater = new DefaultPositionUpdater(this.fPositionCategory);
    }

    public void setDocumentPartitioning(String partitioning) {
        Assert.isNotNull((Object)partitioning);
        this.fPartitioning = partitioning;
    }

    public String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void setDamager(IPresentationDamager damager, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fDamagers == null) {
            this.fDamagers = new HashMap();
        }
        if (damager == null) {
            this.fDamagers.remove(contentType);
        } else {
            this.fDamagers.put(contentType, damager);
        }
    }

    public void setRepairer(IPresentationRepairer repairer, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fRepairers == null) {
            this.fRepairers = new HashMap();
        }
        if (repairer == null) {
            this.fRepairers.remove(contentType);
        } else {
            this.fRepairers.put(contentType, repairer);
        }
    }

    public void install(ITextViewer viewer) {
        if (_trace) {
            this.time0 = System.currentTimeMillis();
        }
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
        this.fViewer.addTextInputListener((ITextInputListener)this.fInternalListener);
        IDocument document = viewer.getDocument();
        if (document != null) {
            this.fInternalListener.inputDocumentChanged(null, document);
            if (document instanceof IStructuredDocument) {
                ((IStructuredDocument)document).addDocumentChangedListener((IStructuredDocumentListener)this.fInternalListener);
            }
            if (document instanceof IDocumentExtension4) {
                ((IDocumentExtension4)document).addDocumentRewriteSessionListener((IDocumentRewriteSessionListener)this.fInternalListener);
            }
        }
        if (_trace) {
            System.out.println("StructuredPresentationReconciler: installed to text viewer in " + (System.currentTimeMillis() - this.time0) + "ms");
        }
    }

    public void uninstall() {
        if (_trace) {
            this.time0 = System.currentTimeMillis();
        }
        this.fViewer.removeTextInputListener((ITextInputListener)this.fInternalListener);
        IDocument document = null;
        document = this.fViewer.getDocument();
        if (document instanceof IStructuredDocument) {
            ((IStructuredDocument)document).removeDocumentChangedListener((IStructuredDocumentListener)this.fInternalListener);
        }
        if (document instanceof IDocumentExtension4) {
            ((IDocumentExtension4)document).removeDocumentRewriteSessionListener((IDocumentRewriteSessionListener)this.fInternalListener);
        }
        this.fInternalListener.inputDocumentAboutToBeChanged(this.fViewer.getDocument(), null);
        if (_trace) {
            System.out.println("StructuredPresentationReconciler: uninstalled from text viewer in " + (System.currentTimeMillis() - this.time0) + "ms");
        }
    }

    public IPresentationDamager getDamager(String contentType) {
        if (this.fDamagers == null) {
            return null;
        }
        int idx = contentType.indexOf(58);
        if (idx > 0) {
            contentType = contentType.substring(0, idx + 1);
        }
        return (IPresentationDamager)this.fDamagers.get(contentType);
    }

    public IPresentationRepairer getRepairer(String contentType) {
        if (this.fRepairers == null) {
            return null;
        }
        int idx = contentType.indexOf(58);
        if (idx > 0) {
            contentType = contentType.substring(0, idx + 1);
        }
        return (IPresentationRepairer)this.fRepairers.get(contentType);
    }

    protected void setDocumentToDamagers(IDocument document) {
        if (this.fDamagers != null) {
            Iterator e = this.fDamagers.values().iterator();
            while (e.hasNext()) {
                IPresentationDamager damager = (IPresentationDamager)e.next();
                damager.setDocument(document);
            }
        }
    }

    protected void setDocumentToRepairers(IDocument document) {
        if (this.fRepairers != null) {
            Iterator e = this.fRepairers.values().iterator();
            while (e.hasNext()) {
                IPresentationRepairer repairer = (IPresentationRepairer)e.next();
                repairer.setDocument(document);
            }
        }
    }

    protected TextPresentation createPresentation(IRegion damage, IDocument document) {
        try {
            int validLength = Math.min(damage.getLength(), document.getLength() - damage.getOffset());
            if (this.fRepairers == null || this.fRepairers.isEmpty()) {
                TextPresentation presentation = new TextPresentation(damage, 1);
                presentation.setDefaultStyleRange(new StyleRange(damage.getOffset(), validLength, null, null));
                return presentation;
            }
            TextPresentation presentation = new TextPresentation(damage, 1000);
            ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)damage.getOffset(), (int)validLength, (boolean)false);
            int i = 0;
            while (i < partitions.length) {
                ITypedRegion r = partitions[i];
                IPresentationRepairer repairer = this.getRepairer(r.getType());
                if (repairer != null) {
                    repairer.createPresentation(presentation, r);
                }
                ++i;
            }
            return presentation;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    IRegion getDamage(DocumentEvent e, boolean optimize) {
        ITypedRegion partition;
        IPresentationDamager damager;
        IRegion damage;
        boolean isDeletion;
        block8: {
            int length;
            int n = length = e.getText() == null ? 0 : e.getText().length();
            if (this.fDamagers == null || this.fDamagers.isEmpty()) {
                length = Math.max(e.getLength(), length);
                length = Math.min(e.getDocument().getLength() - e.getOffset(), length);
                return new Region(e.getOffset(), length);
            }
            isDeletion = length == 0;
            damage = null;
            try {
                int offset = e.getOffset();
                if (isDeletion) {
                    offset = Math.max(0, offset - 1);
                }
                if ((damager = this.getDamager((partition = this.getPartition(e.getDocument(), offset)).getType())) != null) break block8;
                return null;
            }
            catch (BadLocationException badLocationException) {}
        }
        IRegion r = damager.getDamageRegion(partition, e, this.fDocumentPartitioningChanged);
        if (!this.fDocumentPartitioningChanged && optimize && !isDeletion) {
            damage = r;
        } else {
            int end;
            int damageEnd = this.getDamageEndOffset(e);
            int parititionDamageEnd = -1;
            if (this.fChangedDocumentPartitions != null) {
                parititionDamageEnd = this.fChangedDocumentPartitions.getOffset() + this.fChangedDocumentPartitions.getLength();
            }
            damage = (end = Math.max(damageEnd, parititionDamageEnd)) == -1 ? r : new Region(r.getOffset(), end - r.getOffset());
        }
        return damage;
    }

    int getDamageEndOffset(DocumentEvent e) throws BadLocationException {
        IPresentationDamager damager;
        int end;
        ITypedRegion partition;
        int endOffset;
        IDocument d = e.getDocument();
        int length = 0;
        if (e.getText() != null && (length = e.getText().length()) > 0) {
            --length;
        }
        if ((endOffset = (partition = this.getPartition(d, e.getOffset() + length)).getOffset() + partition.getLength()) == e.getOffset()) {
            return -1;
        }
        int n = end = this.fRememberedPosition == null ? -1 : this.fRememberedPosition.getOffset() + this.fRememberedPosition.getLength();
        if (endOffset < end && end < d.getLength()) {
            partition = this.getPartition(d, end);
        }
        if ((damager = this.getDamager(partition.getType())) != null) {
            IRegion r = damager.getDamageRegion(partition, e, this.fDocumentPartitioningChanged);
            endOffset = r.getOffset() + r.getLength();
        }
        return endOffset;
    }

    void processRecordedDamages() {
        this.processRecordedDamages(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processRecordedDamages(IRegion damage, IDocument document) {
        RecordedDamage[] recordings = null;
        boolean recordingOverlaps = false;
        List list = this.fRecordedDamages;
        synchronized (list) {
            recordings = this.fRecordedDamages.toArray(new RecordedDamage[this.fRecordedDamages.size()]);
            this.fRecordedDamages.clear();
        }
        int i = 0;
        while (i < recordings.length) {
            if (this.isOverlappingRegion(damage, recordings[i].damage) && document == recordings[i].document) {
                recordingOverlaps = true;
            }
            this.processDamage(recordings[i].damage, recordings[i].document);
            ++i;
        }
        return recordingOverlaps;
    }

    private boolean isOverlappingRegion(IRegion base, IRegion damage) {
        if (base == null || damage == null) {
            return false;
        }
        int baseEnd = base.getOffset() + base.getLength();
        int damageEnd = damage.getOffset() + damage.getLength();
        return damage.getOffset() <= base.getOffset() && damageEnd >= baseEnd;
    }

    void processDamage(IRegion damage, IDocument document) {
        TextPresentation p;
        if (damage != null && damage.getLength() > 0 && (p = this.createPresentation(damage, document)) != null) {
            this.applyTextRegionCollection(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordDamage(IRegion damage, IDocument document) {
        if (damage != null && damage.getLength() > 0) {
            List list = this.fRecordedDamages;
            synchronized (list) {
                this.fRecordedDamages.add(new RecordedDamage(damage, document));
            }
        }
    }

    void applyTextRegionCollection(TextPresentation presentation) {
        this.fViewer.changeTextPresentation(presentation, false);
    }

    ITypedRegion getPartition(IDocument document, int offset) throws BadLocationException {
        return TextUtilities.getPartition((IDocument)document, (String)this.getDocumentPartitioning(), (int)offset, (boolean)false);
    }

    public TextPresentation createRepairDescription(IRegion damage, IDocument document) {
        if (document != this.fLastDocument) {
            this.setDocumentToDamagers(document);
            this.setDocumentToRepairers(document);
            this.fLastDocument = document;
        }
        return this.createPresentation(damage, document);
    }

    class InternalListener
    implements ITextInputListener,
    IDocumentListener,
    ITextListener,
    IStructuredDocumentListener,
    IDocumentPartitioningListener,
    IDocumentPartitioningListenerExtension,
    IDocumentPartitioningListenerExtension2,
    IDocumentRewriteSessionListener {
        private boolean fDocumentChanging = false;
        private boolean fInRewriteSession = false;
        private boolean fHasIncomingChanges = false;
        private boolean fCachedRedrawState = true;

        InternalListener() {
        }

        public void newModel(NewDocumentEvent structuredDocumentEvent) {
            if (this.fInRewriteSession) {
                this.fHasIncomingChanges = true;
                return;
            }
            if (_trace) {
                StructuredPresentationReconciler.this.time1 = System.currentTimeMillis();
            }
            int length = structuredDocumentEvent.getLength();
            StructuredPresentationReconciler.this.recordDamage((IRegion)new Region(0, length), structuredDocumentEvent.getDocument());
            if (_trace) {
                System.out.println("\nStructuredPresentationReconciler: calculated damage for NewDocumentEvent: (length=" + length + ")");
                System.out.flush();
            }
            if (_trace && _traceTime) {
                System.out.println("StructuredPresentationReconciler: calculated damage for NewDocumentEvent in " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time1) + "ms");
                System.out.flush();
            }
        }

        public void noChange(NoChangeEvent structuredDocumentEvent) {
            if (this.fInRewriteSession) {
                this.fHasIncomingChanges = true;
                return;
            }
            if (_trace) {
                StructuredPresentationReconciler.this.time1 = System.currentTimeMillis();
            }
            if (structuredDocumentEvent.reason == 2) {
                Region damage = new Region(structuredDocumentEvent.fOffset, structuredDocumentEvent.fLength);
                StructuredPresentationReconciler.this.recordDamage((IRegion)damage, structuredDocumentEvent.fDocument);
            }
            if (_trace && _traceTime) {
                System.out.println("\nStructuredPresentationReconciler: calculated damage for NoChangeEvent in " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time1) + "ms");
                System.out.flush();
            }
        }

        public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
            Region damage;
            IStructuredDocumentRegionList newDocumentRegions;
            if (this.fInRewriteSession) {
                this.fHasIncomingChanges = true;
                return;
            }
            if (_trace) {
                StructuredPresentationReconciler.this.time1 = System.currentTimeMillis();
            }
            if ((newDocumentRegions = structuredDocumentEvent.getNewStructuredDocumentRegions()).getLength() > 0) {
                int startOffset = newDocumentRegions.item(0).getStartOffset();
                int length = newDocumentRegions.item(newDocumentRegions.getLength() - 1).getEndOffset() - startOffset;
                damage = new Region(startOffset, length);
            } else {
                damage = new Region(structuredDocumentEvent.fOffset, structuredDocumentEvent.getLength());
            }
            StructuredPresentationReconciler.this.recordDamage((IRegion)damage, structuredDocumentEvent.fDocument);
            if (_trace) {
                System.out.println("\nStructuredPresentationReconciler: calculated damage for StructuredDocumentRegionsReplacedEvent: [" + damage.getOffset() + ":" + damage.getLength() + "]");
                System.out.flush();
            }
            if (_trace && _traceTime) {
                System.out.println("StructuredPresentationReconciler: calculated damage for StructuredDocumentRegionsReplacedEvent in " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time1) + "ms");
                System.out.flush();
            }
        }

        public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
            if (this.fInRewriteSession) {
                this.fHasIncomingChanges = true;
                return;
            }
            if (_trace) {
                StructuredPresentationReconciler.this.time1 = System.currentTimeMillis();
            }
            IStructuredDocumentRegion documentRegion = structuredDocumentEvent.getStructuredDocumentRegion();
            ITextRegion changedRegion = structuredDocumentEvent.getRegion();
            int startOffset = documentRegion.getStartOffset(changedRegion);
            int length = changedRegion.getLength();
            Region damage = new Region(startOffset, length);
            StructuredPresentationReconciler.this.recordDamage((IRegion)damage, structuredDocumentEvent.fDocument);
            if (_trace) {
                System.out.println("\nStructuredPresentationReconciler: calculated damage for RegionChangedEvent: [" + damage.getOffset() + ":" + damage.getLength() + "]");
                System.out.flush();
            }
            if (_trace && _traceTime) {
                System.out.println("StructuredPresentationReconciler: calculated damage for RegionChangedEvent in " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time1) + "ms");
                System.out.flush();
            }
        }

        public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
            Region damage;
            if (this.fInRewriteSession) {
                this.fHasIncomingChanges = true;
                return;
            }
            if (_trace) {
                StructuredPresentationReconciler.this.time1 = System.currentTimeMillis();
            }
            IStructuredDocumentRegion documentRegion = structuredDocumentEvent.getStructuredDocumentRegion();
            ITextRegionList newRegions = structuredDocumentEvent.getNewRegions();
            if (newRegions.size() > 0) {
                ITextRegion firstChangedRegion = newRegions.get(0);
                ITextRegion lastChangedRegion = newRegions.get(newRegions.size() - 1);
                int startOffset = documentRegion.getStartOffset(firstChangedRegion);
                int length = documentRegion.getEndOffset(lastChangedRegion) - startOffset;
                damage = new Region(startOffset, length);
            } else {
                damage = new Region(documentRegion.getStartOffset(), documentRegion.getLength());
            }
            StructuredPresentationReconciler.this.recordDamage((IRegion)damage, structuredDocumentEvent.fDocument);
            if (_trace) {
                System.out.println("\nStructuredPresentationReconciler: calculated damage for RegionsReplacedEvent: [" + damage.getOffset() + ":" + damage.getLength() + "]");
                System.out.flush();
            }
            if (_trace && _traceTime) {
                System.out.println("StructuredPresentationReconciler: calculated damage for RegionsReplacedEvent in " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time1) + "ms");
                System.out.flush();
            }
        }

        public void inputDocumentAboutToBeChanged(IDocument oldDocument, IDocument newDocument) {
            if (oldDocument != null) {
                try {
                    StructuredPresentationReconciler.this.fViewer.removeTextListener((ITextListener)this);
                    oldDocument.removeDocumentListener((IDocumentListener)this);
                    oldDocument.removeDocumentPartitioningListener((IDocumentPartitioningListener)this);
                    if (oldDocument instanceof IStructuredDocument) {
                        ((IStructuredDocument)oldDocument).removeDocumentChangedListener((IStructuredDocumentListener)this);
                    }
                    oldDocument.removePositionUpdater(StructuredPresentationReconciler.this.fPositionUpdater);
                    oldDocument.removePositionCategory(StructuredPresentationReconciler.this.fPositionCategory);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
            }
        }

        public void inputDocumentChanged(IDocument oldDocument, IDocument newDocument) {
            if (_trace || _traceTime) {
                StructuredPresentationReconciler.this.time1 = System.currentTimeMillis();
            }
            this.fDocumentChanging = false;
            this.fCachedRedrawState = true;
            if (newDocument != null) {
                newDocument.addPositionCategory(StructuredPresentationReconciler.this.fPositionCategory);
                newDocument.addPositionUpdater(StructuredPresentationReconciler.this.fPositionUpdater);
                if (newDocument instanceof IStructuredDocument) {
                    newDocument.addDocumentPartitioningListener((IDocumentPartitioningListener)this);
                    newDocument.addDocumentListener((IDocumentListener)this);
                    ((IStructuredDocument)newDocument).addDocumentChangedListener((IStructuredDocumentListener)this);
                }
                StructuredPresentationReconciler.this.fViewer.addTextListener((ITextListener)this);
                if (newDocument instanceof IStructuredDocument) {
                    StructuredPresentationReconciler.this.setDocumentToDamagers(newDocument);
                    StructuredPresentationReconciler.this.setDocumentToRepairers(newDocument);
                    StructuredPresentationReconciler.this.processDamage((IRegion)new Region(0, newDocument.getLength()), newDocument);
                }
            }
            if (_trace) {
                System.out.println("StructuredPresentationReconciler: processed damage for inputDocumentChanged in " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time1) + "ms");
            }
        }

        public void documentPartitioningChanged(IDocument document) {
            if (_traceTime) {
                StructuredPresentationReconciler.this.time0 = System.currentTimeMillis();
            }
            if (!this.fDocumentChanging && this.fCachedRedrawState) {
                StructuredPresentationReconciler.this.processDamage((IRegion)new Region(0, document.getLength()), document);
            } else {
                StructuredPresentationReconciler.this.fDocumentPartitioningChanged = true;
            }
            if (_trace) {
                System.out.println("StructuredPresentationReconciler: processed damage for documentPartitioningChanged [full document]");
            }
            if (_trace && _traceTime) {
                System.out.println("StructuredPresentationReconciler: processed damage for documentPartitioningChanged in " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time0) + "ms");
            }
        }

        public void documentPartitioningChanged(IDocument document, IRegion changedRegion) {
            if (_traceTime) {
                StructuredPresentationReconciler.this.time0 = System.currentTimeMillis();
            }
            if (!this.fDocumentChanging && this.fCachedRedrawState) {
                StructuredPresentationReconciler.this.processDamage((IRegion)new Region(changedRegion.getOffset(), changedRegion.getLength()), document);
            } else {
                StructuredPresentationReconciler.this.fDocumentPartitioningChanged = true;
                StructuredPresentationReconciler.this.fChangedDocumentPartitions = changedRegion;
            }
            if (_trace) {
                System.out.println("StructuredPresentationReconciler: processed damage for documentPartitioningChanged [" + changedRegion.getOffset() + ":" + changedRegion.getLength() + "]");
            }
            if (_trace && _traceTime) {
                System.out.println("StructuredPresentationReconciler: processed damage for documentPartitioningChanged in " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time0) + "ms");
            }
        }

        public void documentPartitioningChanged(DocumentPartitioningChangedEvent event) {
            IRegion changedRegion = event.getChangedRegion(StructuredPresentationReconciler.this.getDocumentPartitioning());
            if (changedRegion != null) {
                this.documentPartitioningChanged(event.getDocument(), changedRegion);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
            this.fDocumentChanging = true;
            if (this.fCachedRedrawState) {
                try {
                    int offset = e.getOffset() + e.getLength();
                    ITypedRegion region = StructuredPresentationReconciler.this.getPartition(e.getDocument(), offset);
                    StructuredPresentationReconciler.this.fRememberedPosition = new TypedPosition(region);
                    e.getDocument().addPosition(StructuredPresentationReconciler.this.fPositionCategory, (Position)StructuredPresentationReconciler.this.fRememberedPosition);
                }
                catch (BadLocationException badLocationException) {
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
            }
        }

        public void documentChanged(DocumentEvent e) {
            if (this.fCachedRedrawState) {
                try {
                    e.getDocument().removePosition(StructuredPresentationReconciler.this.fPositionCategory, (Position)StructuredPresentationReconciler.this.fRememberedPosition);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
            }
            this.fDocumentChanging = false;
        }

        public void textChanged(TextEvent e) {
            if (this.fInRewriteSession) {
                this.fHasIncomingChanges = true;
                return;
            }
            this.fCachedRedrawState = e.getViewerRedrawState();
            if (!this.fCachedRedrawState) {
                if (_trace) {
                    System.out.println("\nStructuredPresentationReconciler: returned early from textChanged(TextEvent)");
                }
                return;
            }
            if (_trace) {
                System.out.println("\nStructuredPresentationReconciler: entering textChanged(TextEvent)");
                StructuredPresentationReconciler.this.time0 = System.currentTimeMillis();
            }
            IRegion damage = null;
            IDocument document = null;
            if (e.getDocumentEvent() == null) {
                document = StructuredPresentationReconciler.this.fViewer.getDocument();
                if (document != null) {
                    if (e.getOffset() == 0 && e.getLength() == 0 && e.getText() == null) {
                        damage = new Region(0, document.getLength());
                    } else {
                        IRegion region = this.widgetRegion2ModelRegion(e);
                        try {
                            String text = document.get(region.getOffset(), region.getLength());
                            DocumentEvent de = new DocumentEvent(document, region.getOffset(), region.getLength(), text);
                            damage = StructuredPresentationReconciler.this.getDamage(de, false);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
            } else {
                DocumentEvent de = e.getDocumentEvent();
                document = de.getDocument();
                damage = StructuredPresentationReconciler.this.getDamage(de, true);
            }
            if (_trace && _traceTime) {
                System.out.println("StructuredPresentationReconciler: calculated simple text damage at " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time0) + "ms");
                System.out.flush();
            }
            boolean damageOverlaps = StructuredPresentationReconciler.this.processRecordedDamages(damage, document);
            if (_trace && _traceTime) {
                System.out.println("StructuredPresentationReconciler: processed recorded structured text damage at " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time0) + "ms");
            }
            if (damage != null && document != null && !damageOverlaps) {
                StructuredPresentationReconciler.this.processDamage(damage, document);
                if (_trace && _traceTime) {
                    System.out.println("StructuredPresentationReconciler: processed simple text damage at " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time0) + "ms");
                    System.out.flush();
                }
            }
            StructuredPresentationReconciler.this.fDocumentPartitioningChanged = false;
            StructuredPresentationReconciler.this.fChangedDocumentPartitions = null;
            if (_trace) {
                System.out.println("StructuredPresentationReconciler: finished textChanged(TextEvent) in " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time0) + "ms");
            }
        }

        protected IRegion widgetRegion2ModelRegion(TextEvent e) {
            int length;
            String text = e.getText();
            int n = length = text == null ? 0 : text.length();
            if (StructuredPresentationReconciler.this.fViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)StructuredPresentationReconciler.this.fViewer;
                return extension.widgetRange2ModelRange((IRegion)new Region(e.getOffset(), length));
            }
            IRegion visible = StructuredPresentationReconciler.this.fViewer.getVisibleRegion();
            Region region = new Region(e.getOffset() + visible.getOffset(), length);
            return region;
        }

        public void documentRewriteSessionChanged(DocumentRewriteSessionEvent event) {
            boolean bl = this.fInRewriteSession = event != null && event.fChangeType == DocumentRewriteSessionEvent.SESSION_START;
            if (!this.fInRewriteSession && this.fHasIncomingChanges && event != null) {
                if (_trace) {
                    StructuredPresentationReconciler.this.time0 = System.currentTimeMillis();
                }
                StructuredPresentationReconciler.this.processDamage((IRegion)new Region(0, event.fDocument.getLength()), event.fDocument);
                if (_trace && _traceTime) {
                    System.out.println("StructuredPresentationReconciler:  processed damaged after ending document rewrite session at " + (System.currentTimeMillis() - StructuredPresentationReconciler.this.time0) + "ms");
                }
                this.fHasIncomingChanges = false;
            }
        }
    }

    private static class RecordedDamage {
        IRegion damage;
        IDocument document;

        RecordedDamage(IRegion damage, IDocument document) {
            this.damage = damage;
            this.document = document;
        }
    }
}

