/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.format;

final class SpaceConverter {
    private String source = null;
    private int length = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private int spaceCount = 0;
    private int wordCount = 0;
    private StringBuffer buffer = null;
    private int lastOffset = 0;
    private boolean keepBlankLines = false;

    public SpaceConverter(String source) {
        if (source == null) {
            this.source = new String();
        } else {
            this.source = source;
            this.length = source.length();
        }
    }

    public SpaceConverter(String source, boolean keepBlankLines) {
        if (source == null) {
            this.source = new String();
        } else {
            this.source = source;
            this.length = source.length();
        }
        this.keepBlankLines = keepBlankLines;
    }

    public void compressSpaces() {
        if (this.spaceCount == 0) {
            return;
        }
        if (this.spaceCount == 1 && this.source.charAt(this.startOffset) == ' ') {
            return;
        }
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        if (this.startOffset > this.lastOffset) {
            this.buffer.append(this.source.substring(this.lastOffset, this.startOffset));
        }
        this.buffer.append(' ');
        this.lastOffset = this.startOffset + this.spaceCount;
    }

    public String getSource() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        if (this.length > this.lastOffset) {
            this.buffer.append(this.source.substring(this.lastOffset, this.length));
        }
        return this.buffer.toString();
    }

    public int getSpaceCount() {
        return this.spaceCount;
    }

    public boolean hasSpaces() {
        return this.spaceCount > 0;
    }

    public boolean isModified() {
        return this.buffer != null;
    }

    private static String mergeBlankLines(String newSpaces, String oldSpaces) {
        if (newSpaces == null || newSpaces.length() == 0) {
            return newSpaces;
        }
        if (oldSpaces == null) {
            return newSpaces;
        }
        int newLineCount = 0;
        int oldLength = oldSpaces.length();
        int i = 0;
        while (i < oldLength) {
            char c = oldSpaces.charAt(i);
            if (c == '\r') {
                ++newLineCount;
                if (i + 1 < oldLength && (c = oldSpaces.charAt(i + 1)) == '\n') {
                    ++i;
                }
            } else if (c == '\n') {
                ++newLineCount;
            }
            ++i;
        }
        if (newLineCount < 2) {
            return newSpaces;
        }
        String delim = null;
        char d = newSpaces.charAt(0);
        if (d == '\r') {
            delim = newSpaces.length() > 1 && newSpaces.charAt(1) == '\n' ? "\r\n" : "\r";
        } else if (d == '\n') {
            delim = "\n";
        } else {
            return newSpaces;
        }
        StringBuffer buffer = new StringBuffer(newSpaces.length() + --newLineCount * 2);
        while (newLineCount > 0) {
            buffer.append(delim);
            --newLineCount;
        }
        buffer.append(newSpaces);
        return buffer.toString();
    }

    public int nextWord() {
        if (this.endOffset == this.length) {
            this.startOffset = this.endOffset;
            this.spaceCount = 0;
            this.wordCount = 0;
            return 0;
        }
        int i = this.startOffset = this.endOffset;
        while (i < this.length) {
            if (!Character.isWhitespace(this.source.charAt(i))) break;
            ++i;
        }
        this.spaceCount = i - this.startOffset;
        int wordOffset = i;
        while (i < this.length) {
            if (Character.isWhitespace(this.source.charAt(i))) break;
            ++i;
        }
        this.wordCount = i - wordOffset;
        this.endOffset = i;
        return this.wordCount;
    }

    public void replaceSpaces(String spaces) {
        int textOffset;
        int spaceLength = spaces != null ? spaces.length() : 0;
        String oldSpaces = null;
        if (spaceLength == this.spaceCount) {
            if (spaceLength == 0) {
                return;
            }
            if (this.startOffset == 0 ? this.source.startsWith(spaces) : (this.endOffset == this.length ? this.source.endsWith(spaces) : (oldSpaces = this.source.substring(this.startOffset, textOffset = this.startOffset + this.spaceCount)).equals(spaces))) {
                return;
            }
        }
        if (this.keepBlankLines && this.spaceCount > 0) {
            if (oldSpaces == null) {
                textOffset = this.startOffset + this.spaceCount;
                oldSpaces = this.source.substring(this.startOffset, textOffset);
            }
            if (oldSpaces != null && oldSpaces.equals(spaces = SpaceConverter.mergeBlankLines(spaces, oldSpaces))) {
                return;
            }
        }
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        if (this.startOffset > this.lastOffset) {
            this.buffer.append(this.source.substring(this.lastOffset, this.startOffset));
        }
        if (spaceLength > 0) {
            this.buffer.append(spaces);
        }
        this.lastOffset = this.startOffset + this.spaceCount;
    }
}

