/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMConstantBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

class REMFloatTypeBeanProxy
extends REMConstantBeanProxy
implements INumberBeanProxy {
    private final float fFloat;

    REMFloatTypeBeanProxy(REMProxyFactoryRegistry aRegistry, float aFloat) {
        super(aRegistry);
        this.fFloat = aFloat;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof REMFloatTypeBeanProxy) {
            return this.fFloat == ((REMFloatTypeBeanProxy)anObject).floatValue();
        }
        if (anObject instanceof Double) {
            return this.fFloat == ((Float)anObject).floatValue();
        }
        return false;
    }

    public boolean sameAs(IBeanProxy aBeanProxy) {
        if (this == aBeanProxy) {
            return true;
        }
        if (aBeanProxy instanceof REMFloatTypeBeanProxy) {
            return this.fFloat == ((REMFloatTypeBeanProxy)aBeanProxy).floatValue();
        }
        return false;
    }

    public byte byteValue() {
        return (byte)this.fFloat;
    }

    public double doubleValue() {
        return this.fFloat;
    }

    public float floatValue() {
        return this.fFloat;
    }

    public int intValue() {
        return (int)this.fFloat;
    }

    public long longValue() {
        return (long)this.fFloat;
    }

    public Number numberValue() {
        return new Float(this.fFloat);
    }

    public short shortValue() {
        return (short)this.fFloat;
    }

    public String toBeanString() {
        return String.valueOf(this.fFloat);
    }

    public IBeanTypeProxy getTypeProxy() {
        return ((REMStandardBeanTypeProxyFactory)this.fFactory.getBeanTypeProxyFactory()).floatType;
    }

    public void renderBean(Commands.ValueObject value) {
        value.set(this.fFloat);
    }
}

