/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.ManyToOneAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaManyToOneMappingTests
extends ContextModelTestCase {
    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithManyToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidManyToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithCollectionManyToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private Collection address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithGenericizedCollectionManyToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    public JavaManyToOneMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        JavaManyToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaManyToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaManyToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaManyToOneMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        JavaManyToOneMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        JavaManyToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaManyToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaManyToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        JavaManyToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaManyToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaManyToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaManyToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaManyToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaManyToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        JavaManyToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaManyToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaManyToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        JavaManyToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaManyToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaManyToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        JavaManyToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaManyToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaManyToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToOne"));
        JavaManyToOneMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        JavaManyToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaManyToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaManyToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToMany"));
        JavaManyToOneMappingTests.assertNotNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinColumn"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToMany");
        JavaManyToOneMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaManyToOneMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaManyToOneMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinColumn"));
    }

    public void testUpdateSpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getMappingAnnotation();
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getSpecifiedTargetEntity());
        JavaManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
        manyToOne.setTargetEntity("newTargetEntity");
        JavaManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)manyToOneMapping.getSpecifiedTargetEntity());
        JavaManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)manyToOne.getTargetEntity());
        manyToOne.setTargetEntity(null);
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getSpecifiedTargetEntity());
        JavaManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
    }

    public void testModifySpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getMappingAnnotation();
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getSpecifiedTargetEntity());
        JavaManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
        manyToOneMapping.setSpecifiedTargetEntity("newTargetEntity");
        JavaManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)manyToOneMapping.getSpecifiedTargetEntity());
        JavaManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)manyToOne.getTargetEntity());
        manyToOneMapping.setSpecifiedTargetEntity(null);
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getSpecifiedTargetEntity());
        JavaManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
    }

    public void testUpdateSpecifiedOptional() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getMappingAnnotation();
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getSpecifiedOptional());
        JavaManyToOneMappingTests.assertNull((Object)manyToOne.getOptional());
        manyToOne.setOptional(Boolean.TRUE);
        JavaManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOneMapping.getSpecifiedOptional());
        JavaManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOne.getOptional());
        manyToOne.setOptional(Boolean.FALSE);
        JavaManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)manyToOneMapping.getSpecifiedOptional());
        JavaManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)manyToOne.getOptional());
        manyToOne.setOptional(null);
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getSpecifiedOptional());
        JavaManyToOneMappingTests.assertNull((Object)manyToOne.getOptional());
    }

    public void testModifySpecifiedOptional() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ManyToOneAnnotation manyToOne = (ManyToOneAnnotation)attributeResource.getMappingAnnotation();
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getSpecifiedOptional());
        JavaManyToOneMappingTests.assertNull((Object)manyToOne.getOptional());
        manyToOneMapping.setSpecifiedOptional(Boolean.TRUE);
        JavaManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOneMapping.getSpecifiedOptional());
        JavaManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOne.getOptional());
        manyToOneMapping.setSpecifiedOptional(Boolean.FALSE);
        JavaManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)manyToOneMapping.getSpecifiedOptional());
        JavaManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)manyToOne.getOptional());
        manyToOneMapping.setSpecifiedOptional(null);
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getSpecifiedOptional());
        JavaManyToOneMappingTests.assertNull((Object)manyToOne.getOptional());
    }

    public void testSpecifiedJoinColumns() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        ListIterator specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)attributeResource.addSupportingAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.setName("FOO");
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        joinColumn = (JoinColumnAnnotation)attributeResource.addSupportingAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.setName("BAR");
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        joinColumn = (JoinColumnAnnotation)attributeResource.addSupportingAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumn.setName("BAZ");
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        attributeResource.moveSupportingAnnotation(1, 0, "javax.persistence.JoinColumns");
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        attributeResource.removeSupportingAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        attributeResource.removeSupportingAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)specifiedJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
        attributeResource.removeSupportingAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        specifiedJoinColumns = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertFalse((boolean)specifiedJoinColumns.hasNext());
    }

    public void testGetDefaultJoin() {
    }

    public void testSpecifiedJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaManyToOneMappingTests.assertEquals((int)0, (int)joinColumns.specifiedJoinColumnsSize());
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertEquals((int)1, (int)joinColumns.specifiedJoinColumnsSize());
        joinColumns.removeSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertEquals((int)0, (int)joinColumns.specifiedJoinColumnsSize());
    }

    public void testJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaManyToOneMappingTests.assertEquals((int)1, (int)joinColumns.joinColumnsSize());
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertEquals((int)1, (int)joinColumns.joinColumnsSize());
        joinColumns.addSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertEquals((int)2, (int)joinColumns.joinColumnsSize());
        joinColumns.removeSpecifiedJoinColumn(0);
        joinColumns.removeSpecifiedJoinColumn(0);
        JavaManyToOneMappingTests.assertEquals((int)1, (int)joinColumns.joinColumnsSize());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ListIterator joinColumnsIterator = attributeResource.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testAddSpecifiedJoinColumn2() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        ListIterator joinColumnsIterator = attributeResource.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaManyToOneMappingTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)attributeResource.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns")));
        joinColumns.removeSpecifiedJoinColumn(1);
        ListIterator joinColumnResources = attributeResource.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        ListIterator joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        joinColumns.removeSpecifiedJoinColumn(1);
        joinColumnResources = attributeResource.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumnResources.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        joinColumns.removeSpecifiedJoinColumn(0);
        joinColumnResources = attributeResource.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnResources.hasNext());
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        JavaManyToOneMappingTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.JoinColumns"));
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        joinColumns.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinColumns.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinColumns.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        ListIterator javaJoinColumns = attributeResource.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaManyToOneMappingTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)javaJoinColumns));
        joinColumns.moveSpecifiedJoinColumn(2, 0);
        ListIterator primaryKeyJoinColumns = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaJoinColumns = attributeResource.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        joinColumns.moveSpecifiedJoinColumn(0, 1);
        primaryKeyJoinColumns = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)primaryKeyJoinColumns.next()).getSpecifiedName());
        javaJoinColumns = attributeResource.supportingAnnotations("javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)javaJoinColumns.next()).getName());
    }

    public void testUpdateSpecifiedJoinColumns() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        ((JoinColumnAnnotation)attributeResource.addSupportingAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns")).setName("FOO");
        ((JoinColumnAnnotation)attributeResource.addSupportingAnnotation(1, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns")).setName("BAR");
        ((JoinColumnAnnotation)attributeResource.addSupportingAnnotation(2, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns")).setName("BAZ");
        ListIterator joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        attributeResource.moveSupportingAnnotation(2, 0, "javax.persistence.JoinColumns");
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        attributeResource.moveSupportingAnnotation(0, 1, "javax.persistence.JoinColumns");
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        attributeResource.removeSupportingAnnotation(1, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        attributeResource.removeSupportingAnnotation(1, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumnsIterator.next()).getName());
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
        attributeResource.removeSupportingAnnotation(0, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        joinColumnsIterator = joinColumns.specifiedJoinColumns();
        JavaManyToOneMappingTests.assertFalse((boolean)joinColumnsIterator.hasNext());
    }

    public void testJoinColumnIsVirtual() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JoinColumnJoiningStrategy joinColumns = manyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        JavaManyToOneMappingTests.assertTrue((boolean)joinColumns.getDefaultJoinColumn().isVirtual());
        joinColumns.addSpecifiedJoinColumn(0);
        JoinColumn specifiedJoinColumn = (JoinColumn)joinColumns.specifiedJoinColumns().next();
        JavaManyToOneMappingTests.assertFalse((boolean)specifiedJoinColumn.isVirtual());
        JavaManyToOneMappingTests.assertNull((Object)joinColumns.getDefaultJoinColumn());
    }

    public void testDefaultTargetEntity() throws Exception {
        this.createTestEntityWithValidManyToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaManyToOneMappingTests.assertEquals((String)"test.Address", (String)manyToOneMapping.getDefaultTargetEntity());
        this.addXmlClassRef("test.Address");
        JavaManyToOneMappingTests.assertEquals((String)"test.Address", (String)manyToOneMapping.getDefaultTargetEntity());
        manyToOneMapping.setSpecifiedTargetEntity("foo");
        JavaManyToOneMappingTests.assertEquals((String)"test.Address", (String)manyToOneMapping.getDefaultTargetEntity());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaPersistentType addressPersistentType = addressClassRef.getJavaPersistentType();
        addressPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaManyToOneMappingTests.assertEquals((String)"test.Address", (String)manyToOneMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityCollectionType() throws Exception {
        this.createTestEntityWithCollectionManyToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityGenericizedCollectionType() throws Exception {
        this.createTestEntityWithGenericizedCollectionManyToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getDefaultTargetEntity());
    }

    public void testTargetEntity() throws Exception {
        this.createTestEntityWithValidManyToOneMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaManyToOneMappingTests.assertEquals((String)"test.Address", (String)manyToOneMapping.getTargetEntity());
        manyToOneMapping.setSpecifiedTargetEntity("foo");
        JavaManyToOneMappingTests.assertEquals((String)"foo", (String)manyToOneMapping.getTargetEntity());
        manyToOneMapping.setSpecifiedTargetEntity(null);
        JavaManyToOneMappingTests.assertEquals((String)"test.Address", (String)manyToOneMapping.getTargetEntity());
    }

    public void testResolvedTargetEntity() throws Exception {
        this.createTestEntityWithValidManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getResolvedTargetEntity());
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.Address");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaTypeMapping addressTypeMapping = addressClassRef.getJavaPersistentType().getMapping();
        JavaManyToOneMappingTests.assertEquals((Object)addressTypeMapping, (Object)manyToOneMapping.getResolvedTargetEntity());
        manyToOneMapping.setSpecifiedTargetEntity("foo");
        JavaManyToOneMappingTests.assertNull((Object)manyToOneMapping.getResolvedTargetEntity());
        manyToOneMapping.setSpecifiedTargetEntity("test.Address");
        JavaManyToOneMappingTests.assertEquals((Object)addressTypeMapping, (Object)manyToOneMapping.getResolvedTargetEntity());
        manyToOneMapping.setSpecifiedTargetEntity(null);
        JavaManyToOneMappingTests.assertEquals((Object)addressTypeMapping, (Object)manyToOneMapping.getResolvedTargetEntity());
    }
}

