/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.Cascade;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmManyToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmManyToOneMappingTests
extends ContextModelTestCase {
    public OrmManyToOneMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityManyToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOne = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertEquals((String)"manyToOneMapping", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((String)"manyToOneMapping", (String)manyToOne.getName());
        manyToOne.setName("newName");
        OrmManyToOneMappingTests.assertEquals((String)"newName", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((String)"newName", (String)manyToOne.getName());
        manyToOne.setName(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOne = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertEquals((String)"manyToOneMapping", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((String)"manyToOneMapping", (String)manyToOne.getName());
        ormManyToOneMapping.setName("newName");
        OrmManyToOneMappingTests.assertEquals((String)"newName", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((String)"newName", (String)manyToOne.getName());
        ormManyToOneMapping.setName(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getName());
    }

    public void testUpdateTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOne = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
        manyToOne.setTargetEntity("newTargetEntity");
        OrmManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)manyToOne.getTargetEntity());
        manyToOne.setTargetEntity(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
    }

    public void testModifyTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOne = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
        ormManyToOneMapping.setSpecifiedTargetEntity("newTargetEntity");
        OrmManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)manyToOne.getTargetEntity());
        ormManyToOneMapping.setSpecifiedTargetEntity(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getFetch());
        manyToOneResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.EAGER);
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)manyToOneResource.getFetch());
        manyToOneResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.LAZY);
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)manyToOneResource.getFetch());
        manyToOneResource.setFetch(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getFetch());
        ormManyToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmManyToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)manyToOneResource.getFetch());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getSpecifiedFetch());
        ormManyToOneMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmManyToOneMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)manyToOneResource.getFetch());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToOneMapping.getSpecifiedFetch());
        ormManyToOneMapping.setSpecifiedFetch(null);
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getFetch());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
    }

    public void testUpdateSpecifiedOptional() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getOptional());
        manyToOneResource.setOptional(Boolean.TRUE);
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOneResource.getOptional());
        manyToOneResource.setOptional(Boolean.FALSE);
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)manyToOneResource.getOptional());
        manyToOneResource.setOptional(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getOptional());
    }

    public void testModifySpecifiedOptional() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getOptional());
        ormManyToOneMapping.setSpecifiedOptional(Boolean.TRUE);
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOneResource.getOptional());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormManyToOneMapping.getSpecifiedOptional());
        ormManyToOneMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)manyToOneResource.getOptional());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormManyToOneMapping.getSpecifiedOptional());
        ormManyToOneMapping.setSpecifiedOptional(null);
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getOptional());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnJoiningStrategy strategy = ormManyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmJoinColumn joinColumn = strategy.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmJoinColumn joinColumn2 = strategy.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(1)).getName());
        OrmJoinColumn joinColumn3 = strategy.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(1)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(2)).getName());
        ListIterator joinColumns = strategy.specifiedJoinColumns();
        OrmManyToOneMappingTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmManyToOneMappingTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmManyToOneMappingTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = strategy.specifiedJoinColumns();
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnJoiningStrategy strategy = ormManyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        strategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        strategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        strategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmManyToOneMappingTests.assertEquals((int)3, (int)manyToOneResource.getJoinColumns().size());
        strategy.removeSpecifiedJoinColumn(0);
        OrmManyToOneMappingTests.assertEquals((int)2, (int)manyToOneResource.getJoinColumns().size());
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(1)).getName());
        strategy.removeSpecifiedJoinColumn(0);
        OrmManyToOneMappingTests.assertEquals((int)1, (int)manyToOneResource.getJoinColumns().size());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        strategy.removeSpecifiedJoinColumn(0);
        OrmManyToOneMappingTests.assertEquals((int)0, (int)manyToOneResource.getJoinColumns().size());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnJoiningStrategy strategy = ormManyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        strategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        strategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        strategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmManyToOneMappingTests.assertEquals((int)3, (int)manyToOneResource.getJoinColumns().size());
        strategy.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = strategy.specifiedJoinColumns();
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(1)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(2)).getName());
        strategy.moveSpecifiedJoinColumn(0, 1);
        joinColumns = strategy.specifiedJoinColumns();
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(1)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(2)).getName());
    }

    public void testManyToOneMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "foo");
        OrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnJoiningStrategy strategy = ormManyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy();
        OrmManyToOneMappingTests.assertEquals((String)"foo", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getFetch());
        OrmManyToOneMappingTests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isOptional());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getTargetEntity());
        OrmManyToOneMappingTests.assertFalse((boolean)strategy.specifiedJoinColumns().hasNext());
        Cascade cascade = ormManyToOneMapping.getCascade();
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmManyToOneMappingTests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertEquals((String)"Address", (String)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmJoinColumn ormJoinColumn = (OrmJoinColumn)ormManyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().specifiedJoinColumns().next();
        OrmManyToOneMappingTests.assertEquals((String)"MY_COLUMN", (String)ormJoinColumn.getSpecifiedName());
        OrmManyToOneMappingTests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormJoinColumn.getSpecifiedUnique());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedNullable());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedInsertable());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormJoinColumn.getSpecifiedUpdatable());
        OrmManyToOneMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)ormJoinColumn.getColumnDefinition());
        OrmManyToOneMappingTests.assertEquals((String)"MY_TABLE", (String)ormJoinColumn.getSpecifiedTable());
        Cascade cascade = ormManyToOneMapping.getCascade();
        OrmManyToOneMappingTests.assertTrue((boolean)cascade.isAll());
        OrmManyToOneMappingTests.assertTrue((boolean)cascade.isMerge());
        OrmManyToOneMappingTests.assertTrue((boolean)cascade.isPersist());
        OrmManyToOneMappingTests.assertTrue((boolean)cascade.isRemove());
        OrmManyToOneMappingTests.assertTrue((boolean)cascade.isRefresh());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmManyToOneMappingTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
        ormPersistentAttribute.makeSpecified("manyToOne");
        ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmManyToOneMappingTests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getDefaultFetch());
        OrmManyToOneMappingTests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isDefaultOptional());
        OrmManyToOneMappingTests.assertEquals((String)"test.Address", (String)ormManyToOneMapping.getDefaultTargetEntity());
        Cascade cascade = ormManyToOneMapping.getCascade();
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.addSpecifiedPersistentAttribute("manyToOne", "address");
        OrmManyToOneMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmManyToOneMappingTests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getFetch());
        OrmManyToOneMappingTests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isOptional());
        OrmManyToOneMappingTests.assertEquals((String)"test.Address", (String)ormManyToOneMapping.getDefaultTargetEntity());
        OrmManyToOneMappingTests.assertFalse((boolean)ormManyToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().specifiedJoinColumns().hasNext());
        Cascade cascade = ormManyToOneMapping.getCascade();
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }
}

