/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.AccessAnnotation;
import org.eclipse.jpt.core.resource.java.AccessType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.eclipselink.core.tests.internal.resource.java.EclipseLink1_1JavaResourceModelTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class AccessAnnotationTests
extends EclipseLink1_1JavaResourceModelTestCase {
    public AccessAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAccessOnType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    private ICompilationUnit createTestAccessOnField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Access(AccessType.FIELD)");
            }
        });
    }

    private ICompilationUnit createTestAccessOnProperty() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    public void testGetAccessOnType() throws Exception {
        ICompilationUnit cu = this.createTestAccessOnType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AccessAnnotation access = (AccessAnnotation)typeResource.getSupportingAnnotation("javax.persistence.Access");
        AccessAnnotationTests.assertNotNull((Object)access);
        AccessAnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
    }

    public void testSetAccessOnType() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AccessAnnotation access = (AccessAnnotation)typeResource.getSupportingAnnotation("javax.persistence.Access");
        AccessAnnotationTests.assertNull((Object)access);
        typeResource.addSupportingAnnotation("javax.persistence.Access");
        this.assertSourceContains("@Access", cu);
        access = (AccessAnnotation)typeResource.getSupportingAnnotation("javax.persistence.Access");
        AccessAnnotationTests.assertNotNull((Object)access);
        access.setValue(AccessType.FIELD);
        AccessAnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
        this.assertSourceContains("@Access(FIELD)", cu);
        access.setValue(AccessType.PROPERTY);
        AccessAnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
        this.assertSourceContains("@Access(PROPERTY)", cu);
        access.setValue(null);
        AccessAnnotationTests.assertNull((Object)typeResource.getSupportingAnnotation("javax.persistence.Access"));
        this.assertSourceDoesNotContain("@Access", cu);
    }

    public void testGetAccessOnField() throws Exception {
        ICompilationUnit cu = this.createTestAccessOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableFields().next();
        AccessAnnotation access = (AccessAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Access");
        AccessAnnotationTests.assertNotNull((Object)access);
        AccessAnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
    }

    public void testSetAccessOnField() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableFields().next();
        AccessAnnotation access = (AccessAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Access");
        AccessAnnotationTests.assertNull((Object)access);
        attributeResource.addSupportingAnnotation("javax.persistence.Access");
        this.assertSourceContains("@Access", cu);
        access = (AccessAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Access");
        AccessAnnotationTests.assertNotNull((Object)access);
        access.setValue(AccessType.FIELD);
        AccessAnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
        this.assertSourceContains("@Access(FIELD)", cu);
        access.setValue(AccessType.PROPERTY);
        AccessAnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
        this.assertSourceContains("@Access(PROPERTY)", cu);
        access.setValue(null);
        AccessAnnotationTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Access"));
        this.assertSourceDoesNotContain("@Access", cu);
    }

    public void testGetAccessOnProperty() throws Exception {
        ICompilationUnit cu = this.createTestAccessOnProperty();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableProperties().next();
        AccessAnnotation access = (AccessAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Access");
        AccessAnnotationTests.assertNotNull((Object)access);
        AccessAnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
    }

    public void testSetAccessOnProperty() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableProperties().next();
        AccessAnnotation access = (AccessAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Access");
        AccessAnnotationTests.assertNull((Object)access);
        attributeResource.addSupportingAnnotation("javax.persistence.Access");
        this.assertSourceContains("@Access", cu);
        access = (AccessAnnotation)attributeResource.getSupportingAnnotation("javax.persistence.Access");
        AccessAnnotationTests.assertNotNull((Object)access);
        access.setValue(AccessType.FIELD);
        AccessAnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
        this.assertSourceContains("@Access(FIELD)", cu);
        access.setValue(AccessType.PROPERTY);
        AccessAnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
        this.assertSourceContains("@Access(PROPERTY)", cu);
        access.setValue(null);
        AccessAnnotationTests.assertNull((Object)attributeResource.getSupportingAnnotation("javax.persistence.Access"));
        this.assertSourceDoesNotContain("@Access", cu);
    }
}

