/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinColumnJoiningStrategy;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInJoiningStrategyDialog;
import org.eclipse.jpt.ui.internal.mappings.details.JoinColumnInJoiningStrategyStateObject;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.model.value.CachingTransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyWritablePropertyValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValueListAdapter;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinColumnComposite
extends FormPane<JoinColumnJoiningStrategy> {
    private WritablePropertyValueModel<JoinColumn> joinColumnHolder;

    public JoinColumnComposite(FormPane<?> parentPane, PropertyValueModel<JoinColumnJoiningStrategy> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.joinColumnHolder = this.buildJoinColumnHolder();
    }

    private WritablePropertyValueModel<JoinColumn> buildJoinColumnHolder() {
        return new SimplePropertyValueModel();
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.addCheckBox(this.addSubPane(container, 8), JptUiMappingsMessages.JoinColumnComposite_overrideDefaultJoinColumns, this.buildOverrideDefaultJoinColumnHolder(), null);
        AddRemoveListPane<JoinColumnJoiningStrategy> joinColumnsListPane = new AddRemoveListPane<JoinColumnJoiningStrategy>(this, container, this.buildJoinColumnsAdapter(), this.buildJoinColumnsListModel(), this.joinColumnHolder, this.buildJoinColumnsListLabelProvider(), "org.eclipse.jpt.ui.mapping_joinTableJoinColumns", false);
        this.installJoinColumnsListPaneEnabler(joinColumnsListPane);
    }

    private WritablePropertyValueModel<Boolean> buildOverrideDefaultJoinColumnHolder() {
        return new OverrideDefaultJoinColumnHolder();
    }

    private AddRemovePane.Adapter buildJoinColumnsAdapter() {
        return new AddRemoveJoinColumnAdapter();
    }

    private ListValueModel<JoinColumn> buildJoinColumnsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildJoinColumnsListHolder(), new String[]{"specifiedName", "defaultName", "specifiedReferencedColumnName", "defaultReferencedColumnName"});
    }

    private ListValueModel<JoinColumn> buildJoinColumnsListHolder() {
        ArrayList<ListValueModel<JoinColumn>> list = new ArrayList<ListValueModel<JoinColumn>>();
        list.add(this.buildSpecifiedJoinColumnsListHolder());
        list.add(this.buildDefaultJoinColumnListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<JoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<JoinColumnJoiningStrategy, JoinColumn>(this.getSubjectHolder(), new String[]{"specifiedJoinColumns"}){

            protected ListIterator<JoinColumn> listIterator_() {
                return ((JoinColumnJoiningStrategy)this.subject).specifiedJoinColumns();
            }

            protected int size_() {
                return ((JoinColumnJoiningStrategy)this.subject).specifiedJoinColumnsSize();
            }
        };
    }

    private ListValueModel<JoinColumn> buildDefaultJoinColumnListHolder() {
        return new PropertyListValueModelAdapter((PropertyValueModel)new PropertyAspectAdapter<JoinColumnJoiningStrategy, JoinColumn>(this.getSubjectHolder(), new String[]{"defaultJoinColumn"}){

            protected JoinColumn buildValue_() {
                return ((JoinColumnJoiningStrategy)this.subject).getDefaultJoinColumn();
            }
        });
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new JoinColumnLabelProvider();
    }

    private void installJoinColumnsListPaneEnabler(AddRemoveListPane<JoinColumnJoiningStrategy> pane) {
        new PaneEnabler((PropertyValueModel<Boolean>)new JoinColumnPaneEnablerHolder(), (Pane<?>)pane);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddRemoveJoinColumnAdapter
    extends AddRemovePane.AbstractAdapter {
        private AddRemoveJoinColumnAdapter() {
        }

        @Override
        public void addNewItem(ObjectListSelectionModel listSelectionModel) {
            JoinColumnInJoiningStrategyDialog dialog = new JoinColumnInJoiningStrategyDialog(JoinColumnComposite.this.getShell(), (JoinColumnJoiningStrategy)JoinColumnComposite.this.getSubject(), null);
            dialog.openDialog(this.buildAddJoinColumnPostExecution());
        }

        private PostExecution<JoinColumnInJoiningStrategyDialog> buildAddJoinColumnPostExecution() {
            return new PostExecution<JoinColumnInJoiningStrategyDialog>(){

                @Override
                public void execute(JoinColumnInJoiningStrategyDialog dialog) {
                    if (dialog.wasConfirmed()) {
                        AddRemoveJoinColumnAdapter.this.addJoinColumn((JoinColumnInJoiningStrategyStateObject)((Object)dialog.getSubject()));
                    }
                }
            };
        }

        private void addJoinColumn(JoinColumnInJoiningStrategyStateObject stateObject) {
            JoinColumnJoiningStrategy subject = (JoinColumnJoiningStrategy)JoinColumnComposite.this.getSubject();
            int index = subject.specifiedJoinColumnsSize();
            JoinColumn joinColumn = subject.addSpecifiedJoinColumn(index);
            stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
        }

        @Override
        public boolean hasOptionalButton() {
            return true;
        }

        @Override
        public String optionalButtonText() {
            return JptUiMappingsMessages.JoinColumnComposite_edit;
        }

        @Override
        public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
            JoinColumn joinColumn = (JoinColumn)listSelectionModel.selectedValue();
            JoinColumnInJoiningStrategyDialog dialog = new JoinColumnInJoiningStrategyDialog(JoinColumnComposite.this.getShell(), (JoinColumnJoiningStrategy)JoinColumnComposite.this.getSubject(), joinColumn);
            dialog.openDialog(this.buildEditJoinColumnPostExecution());
        }

        private PostExecution<JoinColumnInJoiningStrategyDialog> buildEditJoinColumnPostExecution() {
            return new PostExecution<JoinColumnInJoiningStrategyDialog>(){

                @Override
                public void execute(JoinColumnInJoiningStrategyDialog dialog) {
                    if (dialog.wasConfirmed()) {
                        AddRemoveJoinColumnAdapter.this.updateJoinColumn((JoinColumnInJoiningStrategyStateObject)((Object)dialog.getSubject()));
                    }
                }
            };
        }

        private void updateJoinColumn(JoinColumnInJoiningStrategyStateObject stateObject) {
            stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
        }

        @Override
        public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
            this.removeJoinColumn(listSelectionModel);
        }

        private void removeJoinColumn(ObjectListSelectionModel listSelectionModel) {
            int[] selectedIndices = listSelectionModel.selectedIndices();
            int index = selectedIndices.length;
            while (--index >= 0) {
                ((JoinColumnJoiningStrategy)JoinColumnComposite.this.getSubject()).removeSpecifiedJoinColumn(selectedIndices[index]);
            }
        }
    }

    private class JoinColumnLabelProvider
    extends LabelProvider {
        private JoinColumnLabelProvider() {
        }

        public String getText(Object element) {
            JoinColumn joinColumn = (JoinColumn)element;
            return this.buildJoinColumnLabel(joinColumn);
        }

        private String buildJoinColumnLabel(JoinColumn joinColumn) {
            if (joinColumn.isVirtual()) {
                return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            if (joinColumn.getSpecifiedName() == null) {
                if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                    return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
                }
                return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptUiMappingsMessages.JoinColumnComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinColumnPaneEnablerHolder
    extends CachingTransformationPropertyValueModel<JoinColumnJoiningStrategy, Boolean> {
        private StateChangeListener stateChangeListener;

        public JoinColumnPaneEnablerHolder() {
            super((PropertyValueModel)new ValueListAdapter((WritablePropertyValueModel)new ReadOnlyWritablePropertyValueModelWrapper(JoinColumnComposite.this.getSubjectHolder()), new String[]{"specifiedJoinColumns"}));
            this.stateChangeListener = this.buildStateChangeListener();
        }

        private StateChangeListener buildStateChangeListener() {
            return new StateChangeListener(){

                public void stateChanged(StateChangeEvent event) {
                    JoinColumnPaneEnablerHolder.this.valueStateChanged(event);
                }
            };
        }

        private void valueStateChanged(StateChangeEvent event) {
            Object oldValue = this.cachedValue;
            Object newValue = this.transformNew((JoinColumnJoiningStrategy)this.valueHolder.getValue());
            this.firePropertyChanged("value", oldValue, newValue);
        }

        protected Boolean transform(JoinColumnJoiningStrategy value) {
            if (value == null) {
                return false;
            }
            return (Boolean)super.transform((Object)value);
        }

        protected Boolean transform_(JoinColumnJoiningStrategy value) {
            boolean virtual = value.getRelationshipReference().getRelationshipMapping().getPersistentAttribute().isVirtual();
            return !virtual && value.specifiedJoinColumnsSize() > 0;
        }

        protected void engageValueHolder() {
            super.engageValueHolder();
            this.valueHolder.addStateChangeListener(this.stateChangeListener);
        }

        protected void disengageValueHolder() {
            this.valueHolder.removeStateChangeListener(this.stateChangeListener);
            super.disengageValueHolder();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements WritablePropertyValueModel<Boolean> {
        public OverrideDefaultJoinColumnHolder() {
            super(JoinColumnComposite.this.buildSpecifiedJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            return this.listHolder.size() > 0;
        }

        public void setValue(Boolean value) {
            this.updateJoinColumns(value);
        }

        private void updateJoinColumns(boolean selected) {
            if (JoinColumnComposite.this.isPopulating()) {
                return;
            }
            JoinColumnComposite.this.setPopulating(true);
            try {
                JoinColumnJoiningStrategy subject = (JoinColumnJoiningStrategy)JoinColumnComposite.this.getSubject();
                if (selected) {
                    JoinColumn defaultJoinColumn = subject.getDefaultJoinColumn();
                    if (defaultJoinColumn != null) {
                        String columnName = defaultJoinColumn.getDefaultName();
                        String referencedColumnName = defaultJoinColumn.getDefaultReferencedColumnName();
                        JoinColumn joinColumn = subject.addSpecifiedJoinColumn(0);
                        joinColumn.setSpecifiedName(columnName);
                        joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
                        JoinColumnComposite.this.joinColumnHolder.setValue((Object)joinColumn);
                    }
                } else {
                    int index = subject.specifiedJoinColumnsSize();
                    while (--index >= 0) {
                        subject.removeSpecifiedJoinColumn(index);
                    }
                }
            }
            finally {
                JoinColumnComposite.this.setPopulating(false);
            }
        }
    }
}

