/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.runtime.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.Decorator;

public abstract class ViewObject
implements Serializable {
    private final ViewObjectData _data;
    private static final long serialVersionUID = 1592205691642453075L;

    protected ViewObject() {
        this(new ViewObjectData(false));
    }

    protected ViewObject(ViewObjectData delegate) {
        this._data = delegate;
        this._data.setOwner(this);
    }

    protected ViewObjectData getData() {
        return this._data;
    }

    public final boolean isModifiable() {
        return !this.getData().isProtected();
    }

    public final void setProtected() {
        this.getData().setLocked();
    }

    public List getAllDecorators() {
        int size = this.getDecoratorMap().size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList allDecorators = new ArrayList();
        Iterator entryIt = this.getDecoratorMap().entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry entry = entryIt.next();
            List decorators = (List)entry.getValue();
            allDecorators.addAll(decorators);
        }
        return Collections.unmodifiableList(allDecorators);
    }

    public List getDecorators(Class decoratorType) {
        List decorators = (List)this.getDecoratorMap().get(decoratorType);
        if (decorators == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(decorators);
    }

    public void addDecorator(Decorator decorator) {
        this._data.addDecorator(decorator);
    }

    public void addDecorator(Decorator decorator, Class associatedType) {
        this._data.addDecorator(decorator, associatedType);
    }

    public boolean removeDecorator(Decorator decorator, Class associatedType) {
        return this._data.removeDecorator(decorator, associatedType);
    }

    public Object getAdapter(Class adapterType) {
        if (adapterType == null) {
            return null;
        }
        Object adapter = this.getAdapterMap().get(adapterType);
        if (adapter == null && adapterType.isInstance(this)) {
            adapter = this;
        }
        return adapter;
    }

    public void addAdapter(Class adapterType, Object adapter) {
        this._data.addAdapter(adapterType, adapter);
    }

    public Object removeAdapter(Class adapterType) {
        return this.getAdapterMap().remove(adapterType);
    }

    public Map getAllAdapters() {
        if (this.getAdapterMap().size() == 0) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.getAdapterMap());
    }

    protected Map getDecoratorMap() {
        return this._data.getDecoratorMap();
    }

    protected Map getAdapterMap() {
        return this._data.getAdapterMap();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public static abstract class ProtectedDataObject
    implements Serializable {
        private static final long serialVersionUID = 4470279408370430399L;
        private boolean _isProtected;

        public ProtectedDataObject(boolean isProtected) {
            this._isProtected = isProtected;
        }

        protected final synchronized void enforceProtection() throws UnsupportedOperationException {
            if (this.isProtected()) {
                throw new UnsupportedOperationException("Object " + this.toString() + " is locked for modification");
            }
        }

        public final synchronized boolean isProtected() {
            return this._isProtected;
        }

        protected void doBeforeProtecting() {
        }

        public final synchronized void setLocked() {
            this.doBeforeProtecting();
            this._isProtected = true;
        }
    }

    public static class ViewObjectData
    extends ProtectedDataObject {
        private static final long serialVersionUID = -4216980607447926035L;
        private Map _decorators;
        private Map _adapters;
        private Object _owner;

        public ViewObjectData(boolean isProtected) {
            super(isProtected);
        }

        private void setOwner(ViewObject viewObject) {
            this._owner = viewObject;
        }

        public boolean removeDecorator(Decorator decorator, Class associatedType) {
            this.enforceProtection();
            if (decorator == null || associatedType == null) {
                throw new IllegalArgumentException("Arguments must not be null");
            }
            List decoratorsByType = (List)this.getDecoratorMap().get(associatedType);
            if (decoratorsByType != null) {
                return decoratorsByType.remove(decorator);
            }
            return false;
        }

        public void addAdapter(Class adapterType, Object adapter) {
            this.enforceProtection();
            if (adapterType == null || adapter == null) {
                throw new IllegalArgumentException("Arguments must not be null");
            }
            if (!adapterType.isInstance(adapter)) {
                throw new IllegalArgumentException("adapter: " + adapter + " must be cast compatible to class: " + adapterType);
            }
            if (adapterType.isInstance(this._owner)) {
                throw new IllegalArgumentException("this: " + this._owner + " must not already be an instance of class: " + adapterType);
            }
            this.getAdapterMap().put(adapterType, adapter);
        }

        public void addDecorator(Decorator decorator) {
            this.enforceProtection();
            if (decorator == null) {
                throw new IllegalArgumentException("Arguments must not be null");
            }
            Class<?> associationType = decorator.getClass();
            this.addDecorator(decorator, associationType);
        }

        public void addDecorator(Decorator decorator, Class associatedType) {
            this.enforceProtection();
            if (decorator == null || associatedType == null) {
                throw new IllegalArgumentException("Arguments must not be null");
            }
            ArrayList<Decorator> decoratorsByType = (ArrayList<Decorator>)this.getDecoratorMap().get(associatedType);
            if (decoratorsByType == null) {
                decoratorsByType = new ArrayList<Decorator>(2);
                this.getDecoratorMap().put(associatedType, decoratorsByType);
            }
            decoratorsByType.add(decorator);
        }

        protected synchronized Map getDecoratorMap() {
            if (this._decorators == null) {
                if (this.isProtected()) {
                    this._decorators = Collections.EMPTY_MAP;
                }
                this._decorators = new HashMap(4);
            }
            return this._decorators;
        }

        protected synchronized Map getAdapterMap() {
            if (this._adapters == null) {
                this._adapters = new HashMap(4);
            }
            return this._adapters;
        }
    }
}

