/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.ui.internal.validation.ValidationMessageFactory;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

class ValidationReporter
implements IJSFViewValidator.IValidationReporter {
    private final IValidator _validator;
    private final IReporter _reporter;
    private final IFile _file;
    private final ValidationMessageFactory _factory;

    public ValidationReporter(IValidator validator, IReporter reporter, IFile file, ValidationPreferences prefs) {
        this._validator = validator;
        this._reporter = reporter;
        this._file = file;
        this._factory = new ValidationMessageFactory(prefs);
    }

    public void report(Diagnostic problem, int start, int length) {
        Message message = this._factory.createFromDiagnostic(problem, start, length, this._file);
        if ((message.getSeverity() & 7) != 0) {
            this._reporter.addMessage(this._validator, (IMessage)message);
        }
    }

    public void report(IMessage message) {
        if ((message.getSeverity() & 7) != 0) {
            this._reporter.addMessage(this._validator, message);
        }
    }
}

