/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal;

import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.eclipse.wst.internet.monitor.core.internal.FailedConnectionThread;
import org.eclipse.wst.internet.monitor.core.internal.Messages;
import org.eclipse.wst.internet.monitor.core.internal.Monitor;
import org.eclipse.wst.internet.monitor.core.internal.MonitorPlugin;
import org.eclipse.wst.internet.monitor.core.internal.ProtocolAdapter;
import org.eclipse.wst.internet.monitor.core.internal.Trace;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;

public class AcceptThread {
    protected IMonitor monitor;
    protected boolean alive = true;
    protected ServerSocket serverSocket;
    protected Thread thread;

    public AcceptThread(IMonitor monitor) {
        this.monitor = monitor;
    }

    public void startServer() {
        if (this.thread != null) {
            return;
        }
        this.thread = new ServerThread();
        this.thread.setDaemon(true);
        this.thread.setPriority(6);
        this.thread.start();
        Thread.yield();
        int i = 0;
        while (this.serverSocket == null && i < 10) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public boolean isRunning() {
        return this.thread != null;
    }

    public void stopServer() {
        try {
            this.alive = false;
            this.thread = null;
            String protocolId = this.monitor.getProtocol();
            ProtocolAdapter adapter = MonitorPlugin.getInstance().getProtocolAdapter(protocolId);
            adapter.disconnect(this.monitor);
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error stopping server", e);
        }
    }

    public static boolean isPortInUse(int port) {
        block17: {
            ServerSocket s = null;
            try {
                s = new ServerSocket(port);
            }
            catch (SocketException socketException) {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
                return true;
            }
            catch (Exception exception) {
                block16: {
                    try {
                        if (s == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Exception exception2) {}
                        }
                        throw throwable;
                    }
                    try {
                        s.close();
                    }
                    catch (Exception exception3) {}
                }
                return true;
            }
            if (s == null) break block17;
            try {
                s.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    class ServerThread
    extends Thread {
        public ServerThread() {
            super("TCP/IP Monitor");
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            try {
                AcceptThread.this.serverSocket = new ServerSocket(AcceptThread.this.monitor.getLocalPort());
                AcceptThread.this.serverSocket.setSoTimeout(2000);
                Trace.trace((byte)3, "Monitoring localhost:" + AcceptThread.this.monitor.getLocalPort() + " -> " + AcceptThread.this.monitor.getRemoteHost() + ":" + AcceptThread.this.monitor.getRemotePort());
                if (true) ** GOTO lbl37
            }
            catch (Exception v0) {
                Trace.trace((byte)2, "Could not start monitoring");
                return;
            }
            do {
                try {
                    localSocket = AcceptThread.this.serverSocket.accept();
                    timeout = AcceptThread.this.monitor.getTimeout();
                    if (timeout != 0) {
                        localSocket.setSoTimeout(timeout);
                    }
                    try {
                        remoteSocket = new Socket();
                        if (timeout != 0) {
                            remoteSocket.setSoTimeout(timeout);
                        }
                        remoteSocket.connect(new InetSocketAddress(AcceptThread.this.monitor.getRemoteHost(), AcceptThread.this.monitor.getRemotePort()), timeout);
                        protocolId = AcceptThread.this.monitor.getProtocol();
                        adapter = MonitorPlugin.getInstance().getProtocolAdapter(protocolId);
                        adapter.connect(AcceptThread.this.monitor, localSocket, remoteSocket);
                    }
                    catch (SocketTimeoutException v1) {
                        thread2 = new FailedConnectionThread((Monitor)AcceptThread.this.monitor, localSocket, Messages.errorConnectTimeout);
                        thread2.start();
                    }
                    catch (Exception v2) {
                        thread2 = new FailedConnectionThread((Monitor)AcceptThread.this.monitor, localSocket, null);
                        thread2.start();
                    }
                }
                catch (InterruptedIOException v3) {
                }
                catch (Exception e) {
                    if (!AcceptThread.this.alive) continue;
                    Trace.trace((byte)2, "Error while monitoring", e);
                }
lbl37:
                // 7 sources

            } while (AcceptThread.this.alive);
        }
    }
}

