/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.util.ByteCodeVisitorAdapter;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.ILineNumberAttribute;
import org.eclipse.wtp.releng.tools.component.internal.FieldRef;
import org.eclipse.wtp.releng.tools.component.internal.MethodRef;

public class InternalByteCodeVisitor
extends ByteCodeVisitorAdapter {
    private List methodRefs;
    private List fieldRefs;
    private ILineNumberAttribute lineNumAttr;
    private int lineNumIndex;
    private int nextPC;
    private int currLine;

    public InternalByteCodeVisitor(List methodRefs, List fieldRefs, ILineNumberAttribute lineNumAttr) {
        this.methodRefs = methodRefs;
        this.fieldRefs = fieldRefs;
        this.lineNumAttr = lineNumAttr;
        this.lineNumIndex = -1;
        this.nextPC = -1;
        this.currLine = -1;
        this.nextLine();
    }

    public void nextLine() {
        ++this.lineNumIndex;
        int[][] lineNumTable = this.lineNumAttr.getLineNumberTable();
        if (this.lineNumIndex < lineNumTable.length) {
            this.currLine = lineNumTable[this.lineNumIndex][1];
        }
        this.nextPC = this.lineNumIndex + 1 < lineNumTable.length ? lineNumTable[this.lineNumIndex + 1][0] : -1;
    }

    public void _invokeinterface(int pc, int index, byte nargs, IConstantPoolEntry constantInterfaceMethodref) {
        this.addMethodRefs(constantInterfaceMethodref, pc);
    }

    public void _invokespecial(int pc, int index, IConstantPoolEntry constantMethodref) {
        this.addMethodRefs(constantMethodref, pc);
    }

    public void _invokestatic(int pc, int index, IConstantPoolEntry constantMethodref) {
        this.addMethodRefs(constantMethodref, pc);
    }

    public void _invokevirtual(int pc, int index, IConstantPoolEntry constantMethodref) {
        this.addMethodRefs(constantMethodref, pc);
    }

    public void _getfield(int pc, int index, IConstantPoolEntry constantFieldref) {
        this.addFieldRefs(constantFieldref, pc);
    }

    public void _getstatic(int pc, int index, IConstantPoolEntry constantFieldref) {
        this.addFieldRefs(constantFieldref, pc);
    }

    public void _putfield(int pc, int index, IConstantPoolEntry constantFieldref) {
        this.addFieldRefs(constantFieldref, pc);
    }

    public void _putstatic(int pc, int index, IConstantPoolEntry constantFieldref) {
        this.addFieldRefs(constantFieldref, pc);
    }

    private void addMethodRefs(IConstantPoolEntry poolEntry, int pc) {
        while (this.nextPC != -1 && pc >= this.nextPC) {
            this.nextLine();
        }
        String className = this.decodeClassName(new String(poolEntry.getClassName()));
        String methodName = new String(poolEntry.getMethodName());
        String descriptor = new String(poolEntry.getMethodDescriptor());
        Iterator it = this.methodRefs.iterator();
        while (it.hasNext()) {
            MethodRef ref = (MethodRef)it.next();
            if (!ref.equals(className, methodName, descriptor)) continue;
            ref.addLine(this.currLine);
            break;
        }
    }

    private void addFieldRefs(IConstantPoolEntry poolEntry, int pc) {
        while (this.nextPC != -1 && pc >= this.nextPC) {
            this.nextLine();
        }
        String className = this.decodeClassName(new String(poolEntry.getClassName()));
        String fieldName = new String(poolEntry.getFieldName());
        String descriptor = new String(poolEntry.getFieldDescriptor());
        Iterator it = this.fieldRefs.iterator();
        while (it.hasNext()) {
            FieldRef ref = (FieldRef)it.next();
            if (!ref.equals(className, fieldName, descriptor)) continue;
            ref.addLine(this.currLine);
            break;
        }
    }

    private String decodeClassName(String className) {
        return className.replace('/', '.');
    }
}

