/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.compatibility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.FieldAPI;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.eclipse.wtp.releng.tools.component.api.compatibility.APICompatibility;
import org.eclipse.wtp.releng.tools.component.api.compatibility.APICompatibilitySummary;
import org.eclipse.wtp.releng.tools.component.internal.AbstractEmitter;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.URLLocation;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class APICompatibilityEmitter
extends AbstractEmitter {
    public static final String CONST_COMPONENT_API_COMPATIBILITY_XML = "api-compatibility.xml";
    public static final String CONST_COMPONENT_API_COMPATIBILITY_HTML = "api-compatibility.html";
    public static final String OPTION_CURR_API_INDEX = "currAPIIndex";
    public static final String OPTION_REF_API_INDEX = "refAPIIndex";
    public static final String OPTION_OUTPUT_DIR = "outputDir";
    public static final String OPTION_GEN_HTML = "genHTML";
    private String currAPIIndex;
    private String refAPIIndex;
    private String outputDir;
    private boolean genHTML;
    private Map currName2Loc;
    private Map refName2Loc;

    public APICompatibilityEmitter(String currAPIIndex, String refAPIIndex, String outputDir) {
        this.currAPIIndex = currAPIIndex;
        this.refAPIIndex = refAPIIndex;
        this.outputDir = this.addTrailingSeperator(outputDir);
        this.genHTML = false;
    }

    public void init() {
        this.currName2Loc = new HashMap();
        this.harvestComponentLocations(this.currAPIIndex, this.currName2Loc);
        this.refName2Loc = new HashMap();
        this.harvestComponentLocations(this.refAPIIndex, this.refName2Loc);
    }

    private void harvestComponentLocations(String index, Map compName2Loc) {
        File file = new File(index);
        if (file.exists()) {
            try {
                this.harvestComponentLocations(index, false, compName2Loc, new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            try {
                URL url = new URL(index);
                try {
                    this.harvestComponentLocations(index, true, compName2Loc, url.openStream());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void harvestComponentLocations(String index, boolean isURL, Map compName2Loc, InputStream is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [6 : 132->136)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isGenHTML() {
        return this.genHTML;
    }

    public void setGenHTML(boolean genHTML) {
        this.genHTML = genHTML;
    }

    public void genAPICompatibilityXML() throws IOException {
        APICompatibility apiCompatibility;
        APICompatibilitySummary summary = new APICompatibilitySummary();
        ArrayList compNames = new ArrayList(this.currName2Loc.keySet());
        Iterator<Object> it = compNames.iterator();
        while (it.hasNext()) {
            boolean gen = true;
            String compName = (String)it.next();
            ILocation currCompLoc = (ILocation)this.currName2Loc.get(compName);
            ILocation refCompLoc = (ILocation)this.refName2Loc.get(compName);
            ComponentAPI currCompAPI = null;
            if (currCompLoc != null) {
                try {
                    currCompAPI = new ComponentAPI();
                    currCompAPI.setLocation(currCompLoc);
                    currCompAPI.load();
                }
                catch (Throwable t) {
                    gen = false;
                    t.printStackTrace();
                }
            }
            ComponentAPI refCompAPI = null;
            if (refCompLoc != null) {
                try {
                    refCompAPI = new ComponentAPI();
                    refCompAPI.setLocation(refCompLoc);
                    refCompAPI.load();
                }
                catch (Throwable t) {
                    gen = false;
                    t.printStackTrace();
                }
            }
            if (!gen || currCompAPI == null || refCompAPI == null) continue;
            summary.add(this.genAPICompatibilityXML(currCompAPI, refCompAPI));
            this.currName2Loc.remove(compName);
            this.refName2Loc.remove(compName);
        }
        it = this.currName2Loc.keySet().iterator();
        while (it.hasNext()) {
            String compName = (String)it.next();
            apiCompatibility = this.saveAPICompatibility(compName, (ILocation)this.currName2Loc.get(compName), true);
            if (apiCompatibility == null) continue;
            summary.add(apiCompatibility);
        }
        it = this.refName2Loc.keySet().iterator();
        while (it.hasNext()) {
            String compName = (String)it.next();
            apiCompatibility = this.saveAPICompatibility(compName, (ILocation)this.refName2Loc.get(compName), false);
            if (apiCompatibility == null) continue;
            summary.add(apiCompatibility);
        }
        if (this.outputDir != null) {
            summary.save(new FileLocation(new File(String.valueOf(this.outputDir) + "index-api-compatibility.xml")));
            if (this.genHTML) {
                try {
                    summary.saveAsHTML(new FileLocation(new File(String.valueOf(this.outputDir) + "index-api-compatibility.html")));
                }
                catch (TransformerConfigurationException e) {
                    e.printStackTrace();
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private APICompatibility genAPICompatibilityXML(ComponentAPI currCompAPI, ComponentAPI refCompAPI) throws IOException {
        APICompatibility apiCompatibility = new APICompatibility();
        String compName = currCompAPI.getName();
        apiCompatibility.setName(compName);
        ArrayList currPkgAPIs = new ArrayList(currCompAPI.getPackageAPIs());
        ArrayList refPkgAPIs = new ArrayList(refCompAPI.getPackageAPIs());
        int i = 0;
        while (i < currPkgAPIs.size()) {
            PackageAPI currPkgAPI = (PackageAPI)currPkgAPIs.get(i);
            int j = 0;
            while (j < refPkgAPIs.size()) {
                PackageAPI refPkgAPI = (PackageAPI)refPkgAPIs.get(j);
                if (currPkgAPI.getName().equals(refPkgAPI.getName())) {
                    this.genAPICompatibilityXML(apiCompatibility, currPkgAPI, refPkgAPI);
                    currPkgAPIs.remove(i);
                    refPkgAPIs.remove(j);
                    --i;
                    --j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (this.outputDir != null) {
            apiCompatibility.setLocation(this.getAPICompatibilityLocation(compName, true));
            System.out.println("Writing api-compatibility.xml for " + compName);
            apiCompatibility.save();
            if (this.genHTML) {
                try {
                    ILocation html = this.getAPICompatibilityLocation(compName, false);
                    apiCompatibility.saveAsHTML(html, "org/eclipse/wtp/releng/tools/component/xsl/api-compatibility.xsl");
                }
                catch (TransformerConfigurationException e) {
                    e.printStackTrace();
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
            }
        }
        return apiCompatibility;
    }

    private void genAPICompatibilityXML(APICompatibility apiCompatibility, PackageAPI currPkgAPI, PackageAPI refPkgAPI) {
        ArrayList currClassAPIs = new ArrayList(currPkgAPI.getClassAPIs());
        ArrayList refClassAPIs = new ArrayList(refPkgAPI.getClassAPIs());
        int i = 0;
        while (i < currClassAPIs.size()) {
            ClassAPI currClassAPI = (ClassAPI)currClassAPIs.get(i);
            int j = 0;
            while (j < refClassAPIs.size()) {
                ClassAPI refClassAPI = (ClassAPI)refClassAPIs.get(j);
                if (currClassAPI.getName().equals(refClassAPI.getName())) {
                    this.genAPICompatibilityXML(apiCompatibility, currClassAPI, refClassAPI);
                    currClassAPIs.remove(i);
                    refClassAPIs.remove(j);
                    --i;
                    --j;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void genAPICompatibilityXML(APICompatibility apiCompatibility, ClassAPI currClassAPI, ClassAPI refClassAPI) {
        ArrayList currMethodAPIs = new ArrayList(currClassAPI.getMethodAPIs());
        ArrayList refMethodAPIs = new ArrayList(refClassAPI.getMethodAPIs());
        int i = 0;
        while (i < currMethodAPIs.size()) {
            MethodAPI currMethodAPI = (MethodAPI)currMethodAPIs.get(i);
            int j = 0;
            while (j < refMethodAPIs.size()) {
                MethodAPI refMethodAPI = (MethodAPI)refMethodAPIs.get(j);
                if (currMethodAPI.getName().equals(refMethodAPI.getName()) && currMethodAPI.getDescriptor().equals(refMethodAPI.getDescriptor())) {
                    currMethodAPIs.remove(i);
                    refMethodAPIs.remove(j);
                    --i;
                    --j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        ArrayList currFieldAPIs = new ArrayList(currClassAPI.getFieldAPIs());
        ArrayList refFieldAPIs = new ArrayList(refClassAPI.getFieldAPIs());
        int i2 = 0;
        while (i2 < currFieldAPIs.size()) {
            FieldAPI currFieldAPI = (FieldAPI)currFieldAPIs.get(i2);
            int j = 0;
            while (j < refFieldAPIs.size()) {
                FieldAPI refFieldAPI = (FieldAPI)refFieldAPIs.get(j);
                if (currFieldAPI.getName().equals(refFieldAPI.getName()) && currFieldAPI.getDescriptor().equals(refFieldAPI.getDescriptor())) {
                    currFieldAPIs.remove(i2);
                    refFieldAPIs.remove(j);
                    --i2;
                    --j;
                    break;
                }
                ++j;
            }
            ++i2;
        }
    }

    private ILocation getAPICompatibilityLocation(String compName, boolean isXML) {
        if (this.outputDir != null) {
            StringBuffer sb = new StringBuffer(this.outputDir);
            sb.append(compName);
            sb.append('/');
            if (isXML) {
                return new FileLocation(new File(String.valueOf(sb.toString()) + CONST_COMPONENT_API_COMPATIBILITY_XML));
            }
            return new FileLocation(new File(String.valueOf(sb.toString()) + CONST_COMPONENT_API_COMPATIBILITY_HTML));
        }
        return null;
    }

    private APICompatibility saveAPICompatibility(String compName, ILocation compLoc, boolean isNewAPI) {
        try {
            APICompatibility apiCompatibility = new APICompatibility();
            apiCompatibility.setName(compName);
            apiCompatibility.setLocation(this.getAPICompatibilityLocation(compName, true));
            ComponentAPI compAPI = new ComponentAPI();
            compAPI.setLocation(compLoc);
            compAPI.load();
            apiCompatibility.save();
            if (this.genHTML) {
                try {
                    ILocation html = this.getAPICompatibilityLocation(compName, false);
                    apiCompatibility.saveAsHTML(html, "org/eclipse/wtp/releng/tools/component/xsl/api-compatibility.xsl");
                }
                catch (TransformerConfigurationException e) {
                    e.printStackTrace();
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
            }
            return apiCompatibility;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        List currAPIIndex = (List)options.get(OPTION_CURR_API_INDEX);
        List refAPIIndex = (List)options.get(OPTION_REF_API_INDEX);
        List outputDir = (List)options.get(OPTION_OUTPUT_DIR);
        List genHTML = (List)options.get(OPTION_GEN_HTML);
        if (currAPIIndex == null || refAPIIndex == null || outputDir == null || currAPIIndex.size() < 1 || refAPIIndex.size() < 1 || outputDir.size() < 1) {
            APICompatibilityEmitter.printUsage();
            System.exit(-1);
        }
        APICompatibilityEmitter apiCompatibilityEmitter = new APICompatibilityEmitter((String)currAPIIndex.get(0), (String)refAPIIndex.get(0), (String)outputDir.get(0));
        apiCompatibilityEmitter.setGenHTML(genHTML != null);
        apiCompatibilityEmitter.init();
        try {
            apiCompatibilityEmitter.genAPICompatibilityXML();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.api.compatibility.APICompatibilityEmitter -currAPIDir <currAPIDir> -refAPIDir <refAPIDir> -outputDir <outputDir> [-options]");
        System.out.println("");
        System.out.println("\t-currAPIIndex\t<eclipseDir>\tlocation of the current component API summary");
        System.out.println("\t-refAPIIndex\t<compXMLDir>\tlocation of the reference component API summary");
        System.out.println("\t-outputDir\t<outputDir>\toutput directory of component-api-compatibility.xml and component-api-compatibility.html");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-genHTML\tgenerate API compatibility report in HTML");
    }

    private class ComponentSummaryHandler
    extends DefaultHandler {
        private String baseLocation;
        private boolean isURL;
        private Map compName2Loc;

        public ComponentSummaryHandler(String baseLocation, boolean isURL, Map compName2Loc) {
            this.baseLocation = baseLocation.replace('\\', '/');
            int i = this.baseLocation.lastIndexOf(47);
            if (i != -1) {
                this.baseLocation = this.baseLocation.substring(0, i + 1);
            }
            this.isURL = isURL;
            this.compName2Loc = compName2Loc;
        }

        public void startElement(String uri, String elementName, String qName, Attributes attributes) throws SAXException {
            if (elementName.equals("component") || qName.equals("component")) {
                String compName = attributes.getValue("name");
                String ref = attributes.getValue("ref");
                if (compName != null && ref != null) {
                    if (this.isURL) {
                        try {
                            this.compName2Loc.put(compName, new URLLocation(new URL(String.valueOf(this.baseLocation) + ref)));
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.compName2Loc.put(compName, new FileLocation(new File(String.valueOf(this.baseLocation) + ref)));
                    }
                }
            }
        }
    }
}

