/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.progress;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.FieldAPI;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.eclipse.wtp.releng.tools.component.internal.ComponentEntry;
import org.eclipse.wtp.releng.tools.component.internal.ComponentSummary;

public class JavadocCoverageSummary
extends ComponentSummary {
    private static final String ROOT_TAG_NAME = "component-api-javadoc-summary";

    public void add(ComponentAPI compAPI) {
        JavadocCoverageEntry entry = new JavadocCoverageEntry();
        int classCount = 0;
        int methodCount = 0;
        int fieldCount = 0;
        int classIncompleteJavadoc = 0;
        int methodIncompleteJavadoc = 0;
        int fieldIncompleteJavadoc = 0;
        entry.setCompName(compAPI.getName());
        Iterator it = compAPI.getPackageAPIs().iterator();
        while (it.hasNext()) {
            Iterator classIt = ((PackageAPI)it.next()).getClassAPIs().iterator();
            while (classIt.hasNext()) {
                ClassAPI classAPI = (ClassAPI)classIt.next();
                ++classCount;
                if (classAPI.isSetJavadocCoverage()) {
                    ++classIncompleteJavadoc;
                }
                Iterator methodIt = classAPI.getMethodAPIs().iterator();
                while (methodIt.hasNext()) {
                    MethodAPI methodAPI = (MethodAPI)methodIt.next();
                    ++methodCount;
                    if (!methodAPI.isSetJavadocCoverage()) continue;
                    ++methodIncompleteJavadoc;
                }
                Iterator fieldIt = classAPI.getFieldAPIs().iterator();
                while (fieldIt.hasNext()) {
                    FieldAPI fieldAPI = (FieldAPI)fieldIt.next();
                    ++fieldCount;
                    if (!fieldAPI.isSetJavadocCoverage()) continue;
                    ++fieldIncompleteJavadoc;
                }
            }
        }
        entry.setClassCount(classCount);
        entry.setClassJavadocCount(classCount - classIncompleteJavadoc);
        entry.setMethodCount(methodCount);
        entry.setMethodJavadocCount(methodCount - methodIncompleteJavadoc);
        entry.setFieldCount(fieldCount);
        entry.setFieldJavadocCount(fieldCount - fieldIncompleteJavadoc);
        String ref = compAPI.getLocation().getAbsolutePath();
        int i = ref.lastIndexOf(47);
        if (i != -1) {
            ref = ref.substring(0, i + 1);
        }
        entry.setRef(String.valueOf(ref) + "component-api-javadoc.html");
        this.add(entry);
    }

    protected void saveAsHTML(ILocation html, String xsl, String rootTagName) throws TransformerConfigurationException, TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(Platform.getBundle((String)"org.eclipse.wtp.releng.tools.component.core").getResource(xsl).openStream()));
        transformer.transform(new StreamSource(new ByteArrayInputStream(this.getBytes(html, rootTagName))), new StreamResult(new FileOutputStream(new File(html.getAbsolutePath()))));
    }

    public void saveAsHTML(String xsl, ILocation html) throws TransformerConfigurationException, TransformerException, IOException {
        this.saveAsHTML(html, xsl, ROOT_TAG_NAME);
    }

    public void save(ILocation location) throws IOException {
        this.save(location, ROOT_TAG_NAME);
    }

    private class JavadocCoverageEntry
    extends ComponentEntry {
        private int classCount = 0;
        private int methodCount = 0;
        private int fieldCount = 0;
        private int classJavadocCount = 0;
        private int methodJavadocCount = 0;
        private int fieldJavadocCount = 0;

        public int getClassCount() {
            return this.classCount;
        }

        public void setClassCount(int classCount) {
            this.classCount = classCount;
        }

        public int getClassJavadocCount() {
            return this.classJavadocCount;
        }

        public void setClassJavadocCount(int classJavadocCount) {
            this.classJavadocCount = classJavadocCount;
        }

        public int getFieldCount() {
            return this.fieldCount;
        }

        public void setFieldCount(int fieldCount) {
            this.fieldCount = fieldCount;
        }

        public int getFieldJavadocCount() {
            return this.fieldJavadocCount;
        }

        public void setFieldJavadocCount(int fieldJavadocCount) {
            this.fieldJavadocCount = fieldJavadocCount;
        }

        public int getMethodCount() {
            return this.methodCount;
        }

        public void setMethodCount(int methodCount) {
            this.methodCount = methodCount;
        }

        public int getMethodJavadocCount() {
            return this.methodJavadocCount;
        }

        public void setMethodJavadocCount(int methodJavadocCount) {
            this.methodJavadocCount = methodJavadocCount;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<component-api-javadoc ");
            sb.append(this.toAttribute("name", this.getCompName()));
            sb.append(this.toAttribute("class-api-count", String.valueOf(this.classCount)));
            sb.append(this.toAttribute("class-javadoc-count", String.valueOf(this.classJavadocCount)));
            sb.append(this.toAttribute("method-api-count", String.valueOf(this.methodCount)));
            sb.append(this.toAttribute("method-javadoc-count", String.valueOf(this.methodJavadocCount)));
            sb.append(this.toAttribute("field-api-count", String.valueOf(this.fieldCount)));
            sb.append(this.toAttribute("field-javadoc-count", String.valueOf(this.fieldJavadocCount)));
            sb.append(this.toAttribute("ref", this.getRef()));
            sb.append("/>");
            return sb.toString();
        }
    }
}

