/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.util.IExceptionAttribute;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.IClazz;
import org.eclipse.wtp.releng.tools.component.IClazzVisitor;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.IPluginXML;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.FieldAPI;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.eclipse.wtp.releng.tools.component.internal.AbstractEmitter;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.internal.Type;

public class ComponentAPIEmitter
extends AbstractEmitter
implements IClazzVisitor {
    public static final String OPTION_ECLIPSE_DIR = "eclipseDir";
    public static final String OPTION_COMPONENT_XML_DIR = "compXMLDir";
    public static final String OPTION_COMPONENT_API_DIR = "compAPIDir";
    private static final String NAME_CONSTRUCTOR = "<init>";
    private static final String NAME_STATIC_BLOCK = "<clinit>";
    private String compAPIDir;
    private boolean genInternalAPIs;
    private boolean noFieldAPIs;
    private Map compLoc2CompXML;
    private Map pluginId2Plugin;
    private Map fragmentId2Fragment;
    private ComponentXML compXML;
    private ComponentAPI compAPI;
    private String timestamp;

    public ComponentAPIEmitter(String compAPIDir) {
        this.compAPIDir = this.addTrailingSeperator(compAPIDir);
        this.genInternalAPIs = false;
        this.noFieldAPIs = false;
        Calendar c = Calendar.getInstance();
        StringBuffer sb = new StringBuffer(String.valueOf(c.get(1)));
        int month = c.get(2);
        if (month < 10) {
            sb.append("0");
        }
        sb.append(String.valueOf(month));
        int date = c.get(5);
        if (date < 10) {
            sb.append("0");
        }
        sb.append(String.valueOf(date));
        this.timestamp = sb.toString();
    }

    public void init(List eclipseDirs, List compXMLDirs) {
        this.compLoc2CompXML = new HashMap();
        this.pluginId2Plugin = new HashMap();
        this.fragmentId2Fragment = new HashMap();
        Iterator it = eclipseDirs.iterator();
        while (it.hasNext()) {
            File eclipseFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!eclipseFile.exists()) continue;
            this.harvestPlugins(eclipseFile, this.pluginId2Plugin, this.fragmentId2Fragment);
        }
        this.linkPluginsAndFragments(this.pluginId2Plugin, this.fragmentId2Fragment);
        it = compXMLDirs.iterator();
        while (it.hasNext()) {
            File compXMLFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!compXMLFile.exists()) continue;
            this.harvestComponents(compXMLFile, this.compLoc2CompXML);
        }
    }

    public void init(Map compLoc2CompXML, Map pluginId2Plugin, Map fragmentId2Fragment) {
        this.compLoc2CompXML = compLoc2CompXML;
        this.pluginId2Plugin = pluginId2Plugin;
        this.fragmentId2Fragment = fragmentId2Fragment;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean getNoFieldAPIs() {
        return this.noFieldAPIs;
    }

    public void setNoFieldAPIs(boolean noFieldAPIs) {
        this.noFieldAPIs = noFieldAPIs;
    }

    public void genComponentApiXml() throws IOException {
        Iterator it = this.compLoc2CompXML.keySet().iterator();
        while (it.hasNext()) {
            this.genComponentApiXml((String)it.next());
        }
    }

    public ComponentAPI genComponentApiXml(String compLoc) throws IOException {
        this.compXML = (ComponentXML)this.compLoc2CompXML.get(compLoc);
        if (this.compXML != null) {
            this.compXML.load();
            String compName = this.compXML.getName();
            this.compAPI = this.newComponentAPI(this.compXML);
            Iterator pluginsIt = this.compXML.getPlugins().iterator();
            while (pluginsIt.hasNext()) {
                IPluginXML plugin = (IPluginXML)this.pluginId2Plugin.get(((Plugin)pluginsIt.next()).getId());
                if (plugin == null) continue;
                plugin.accept(this);
            }
            this.compXML = null;
            if (this.compAPIDir != null) {
                System.out.println("Writing component-api.xml for " + compName);
            }
            this.compAPI.save();
            return this.compAPI;
        }
        return null;
    }

    public boolean visit(IClazz clazz) {
        if (this.compXML == null || this.compAPI == null) {
            return false;
        }
        ClassAPI classAPI = this.addClassAPI(this.compXML, clazz, this.compAPI);
        if (classAPI != null) {
            boolean isPkgProtected = true;
            ArrayList<MethodAPI> publicMethods = new ArrayList<MethodAPI>();
            ArrayList<MethodAPI> protectedMethods = new ArrayList<MethodAPI>();
            IMethodInfo[] methodInfos = clazz.getMethodInfo();
            int i = 0;
            while (i < methodInfos.length) {
                int access = methodInfos[i].getAccessFlags();
                String methodName = new String(methodInfos[i].getName());
                if (isPkgProtected && methodName.equals(NAME_CONSTRUCTOR)) {
                    boolean bl = isPkgProtected = !this.isBit(access, 1) && !this.isBit(access, 4);
                }
                if (clazz.isInterface() || (this.isBit(access, 1) || this.isBit(access, 4)) && !methodName.equals(NAME_STATIC_BLOCK)) {
                    String[] exs = new String[]{};
                    IExceptionAttribute exAttr = methodInfos[i].getExceptionAttribute();
                    if (exAttr != null) {
                        char[][] exChars = exAttr.getExceptionNames();
                        exs = new String[exChars.length];
                        int j = 0;
                        while (j < exs.length) {
                            exs[j] = this.decodeClassName(new String(exChars[j]));
                            ++j;
                        }
                    }
                    if (this.isBit(access, 1)) {
                        publicMethods.add(this.newMethodAPI(methodName, access, new String(methodInfos[i].getDescriptor()), exs));
                    } else {
                        protectedMethods.add(this.newMethodAPI(methodName, access, new String(methodInfos[i].getDescriptor()), exs));
                    }
                }
                ++i;
            }
            classAPI.getMethodAPIs().addAll(publicMethods);
            if (!isPkgProtected) {
                classAPI.getMethodAPIs().addAll(protectedMethods);
            }
            if (!this.noFieldAPIs) {
                IFieldInfo[] fieldInfos = clazz.getFieldInfo();
                int i2 = 0;
                while (i2 < fieldInfos.length) {
                    int access = fieldInfos[i2].getAccessFlags();
                    if (!(this.isBit(access, 2) || isPkgProtected && !this.isBit(access, 1))) {
                        this.addFieldAPI(classAPI, this.newFieldAPI(new String(fieldInfos[i2].getName()), access, new String(fieldInfos[i2].getDescriptor())));
                    }
                    ++i2;
                }
            }
        }
        return true;
    }

    private ClassAPI addClassAPI(ComponentXML compXML, IClazz clazz, ComponentAPI compAPI) {
        int access;
        String localName;
        String pkgName;
        String typeName = clazz.getName();
        String superClass = clazz.getSuperClass();
        int index = typeName.lastIndexOf(46);
        if (index != -1) {
            pkgName = typeName.substring(0, index);
            localName = typeName.substring(index + 1);
        } else {
            pkgName = "";
            localName = typeName;
        }
        if (this.genInternalAPIs) {
            ClassAPI internalClassAPI = new ClassAPI();
            internalClassAPI.setName(typeName);
            internalClassAPI.setSuperClass(superClass);
            this.addClassAPI(compAPI, true, pkgName, internalClassAPI);
        }
        if (this.isBit(access = clazz.getAccessFlags(), 1) || this.isBit(access, 4)) {
            boolean isInterface = clazz.isInterface();
            Package pkg = this.findPackage(compXML, pkgName);
            if (pkg != null) {
                Type type = this.findType(pkg, localName);
                if (type != null) {
                    boolean instantiate;
                    boolean ref = type.isReference();
                    boolean subclass = type.isSubclass() && !isInterface;
                    boolean implement = type.isImplement() && isInterface;
                    boolean bl = instantiate = type.isInstantiate() && !isInterface;
                    if (ref || subclass || implement || instantiate) {
                        ClassAPI externalClassAPI = this.newClassAPI(typeName, superClass, access, new Boolean(ref), new Boolean(subclass), new Boolean(implement), new Boolean(instantiate));
                        this.addClassAPI(compAPI, false, pkgName, externalClassAPI);
                        return externalClassAPI;
                    }
                    return null;
                }
                if (pkg.isApi()) {
                    ClassAPI externalClassAPI = this.newClassAPI(typeName, superClass, access, Boolean.TRUE, new Boolean(!isInterface), new Boolean(isInterface), new Boolean(!isInterface));
                    this.addClassAPI(compAPI, false, pkgName, externalClassAPI);
                    return externalClassAPI;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private void addClassAPI(ComponentAPI compAPI, boolean isInternal, String pkgName, ClassAPI classAPI) {
        Collection pkgAPIs = compAPI.getPackageAPIs();
        PackageAPI pkgAPI = null;
        Iterator it = pkgAPIs.iterator();
        while (it.hasNext()) {
            PackageAPI nextPkg = (PackageAPI)it.next();
            if (!nextPkg.getName().equals(pkgName)) continue;
            pkgAPI = nextPkg;
            break;
        }
        if (pkgAPI == null) {
            pkgAPI = this.newPackageAPI(pkgName);
            pkgAPIs.add(pkgAPI);
        }
        pkgAPI.addClassAPI(classAPI);
    }

    private void addFieldAPI(ClassAPI classAPI, FieldAPI fieldAPI) {
        classAPI.getFieldAPIs().add(fieldAPI);
    }

    private PackageAPI newPackageAPI(String pkgName) {
        PackageAPI pkg = new PackageAPI();
        pkg.setName(pkgName);
        return pkg;
    }

    private ComponentAPI newComponentAPI(ComponentXML compXML) {
        String compName = compXML.getName();
        FileLocation location = null;
        if (this.compAPIDir != null) {
            StringBuffer sb = new StringBuffer(this.compAPIDir);
            sb.append(compName);
            sb.append('/');
            sb.append("component-api.xml");
            location = new FileLocation(new File(sb.toString()));
        }
        return this.newComponentAPI(compName, location);
    }

    private ComponentAPI newComponentAPI(String compName, ILocation location) {
        ComponentAPI compAPI = new ComponentAPI();
        compAPI.setName(compName);
        compAPI.setTimestamp(this.timestamp);
        compAPI.setLocation(location);
        return compAPI;
    }

    private ClassAPI newClassAPI(String className, String superClass, int access, Boolean ref, Boolean subclass, Boolean implement, Boolean instantiate) {
        ClassAPI classAPI = new ClassAPI();
        classAPI.setName(className);
        classAPI.setSuperClass(superClass);
        classAPI.setAccess(access);
        classAPI.setReference(ref);
        classAPI.setSubclass(subclass);
        classAPI.setImplement(implement);
        classAPI.setInstantiate(instantiate);
        return classAPI;
    }

    private MethodAPI newMethodAPI(String methodName, int access, String descriptor, String[] throwTypes) {
        MethodAPI methodAPI = new MethodAPI();
        methodAPI.setName(methodName);
        methodAPI.setAccess(access);
        methodAPI.setDescriptor(descriptor);
        List throwList = methodAPI.getThrows();
        int i = 0;
        while (i < throwTypes.length) {
            throwList.add(throwTypes[i]);
            ++i;
        }
        return methodAPI;
    }

    private FieldAPI newFieldAPI(String fieldName, int access, String descriptor) {
        FieldAPI fieldAPI = new FieldAPI();
        fieldAPI.setName(fieldName);
        fieldAPI.setAccess(access);
        fieldAPI.setDescriptor(descriptor);
        return fieldAPI;
    }

    private Package findPackage(ComponentXML compXML, String pkgName) {
        if (pkgName != null && compXML != null) {
            Collection pkgs = compXML.getPackages();
            Iterator it = pkgs.iterator();
            while (it.hasNext()) {
                Package pkg = (Package)it.next();
                if (!pkgName.equals(pkg.getName())) continue;
                return pkg;
            }
        }
        return null;
    }

    private Type findType(Package pkg, String typeName) {
        if (typeName != null) {
            int i = typeName.indexOf(36);
            String baseTypeName = i != -1 ? typeName.substring(0, i) : null;
            Type baseType = null;
            Collection types = pkg.getTypes();
            Iterator it = types.iterator();
            while (it.hasNext()) {
                Type type = (Type)it.next();
                String name = type.getName();
                if (typeName.equals(name)) {
                    return type;
                }
                if (baseTypeName == null || baseType != null || !baseTypeName.equals(name)) continue;
                baseType = type;
            }
            if (baseType != null) {
                return baseType;
            }
        }
        return null;
    }

    private boolean isBit(int flag, int bit) {
        return (flag & bit) == bit;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        List eclipseDir = (List)options.get(OPTION_ECLIPSE_DIR);
        List compXMLDir = (List)options.get(OPTION_COMPONENT_XML_DIR);
        List compAPIDir = (List)options.get(OPTION_COMPONENT_API_DIR);
        if (eclipseDir == null || compXMLDir == null || compAPIDir == null || eclipseDir.size() < 1 || compXMLDir.size() < 1 || compAPIDir.size() < 1) {
            ComponentAPIEmitter.printUsage();
            System.exit(-1);
        }
        ComponentAPIEmitter compAPIEmitter = new ComponentAPIEmitter((String)compAPIDir.get(0));
        compAPIEmitter.init(eclipseDir, compXMLDir);
        try {
            compAPIEmitter.genComponentApiXml();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.api.ComponentAPIEmitter -eclipseDir <eclipseDir> -compXMLDir <compDir> -compAPIDir <compAPIDir> [-options]");
        System.out.println("");
        System.out.println("\t-eclipseDir\t<eclipseDir>\tspace seperated list of directories containing Eclipse plugins");
        System.out.println("\t-compXMLDir\t<compXMLDir>\tdirectory containing component.xml");
        System.out.println("\t-compAPIDir\t<compAPIDir>\toutput directory of component-api.xml");
    }
}

