/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WebkitGDBus;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.webkit.GdkRectangle;
import org.eclipse.swt.internal.webkit.WebKitGTK;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    long webView;
    long pageId;
    int failureCount;
    int lastKeyCode;
    int lastCharCode;
    boolean ignoreDispose;
    boolean tlsError;
    long tlsErrorCertificate;
    String tlsErrorUriString;
    URI tlsErrorUri;
    String tlsErrorType;
    boolean firstLoad = true;
    static final int ASYNC_EXEC_TIMEOUT_MS = 10000;
    static boolean bug522733FirstInstanceCreated = false;
    static AtomicInteger w2_bug527738LastRequestCounter = new AtomicInteger();
    private static int nonBlockingEvaluate = 0;
    static Map<LONG, Integer> webKitDownloadStatus = new HashMap<LONG, Integer>();
    static final String ABOUT_BLANK = "about:blank";
    static final String CLASSNAME_EXTERNAL = "External";
    static final String FUNCTIONNAME_CALLJAVA = "callJava";
    static final String HEADER_CONTENTTYPE = "content-type";
    static final String MIMETYPE_FORMURLENCODED = "application/x-www-form-urlencoded";
    static final String OBJECTNAME_EXTERNAL = "external";
    static final String PROPERTY_LENGTH = "length";
    static final String PROPERTY_PROXYHOST = "network.proxy_host";
    static final String PROPERTY_PROXYPORT = "network.proxy_port";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String URI_FILEROOT = "file:///";
    static final String USER_AGENT = "user-agent";
    static final int MAX_PORT = 65535;
    static final int MAX_PROGRESS = 100;
    static final int[] MIN_VERSION;
    static final int SENTINEL_KEYPRESS = -1;
    static final char SEPARATOR_FILE;
    static final int STOP_PROPOGATE = 1;
    static final String DOMEVENT_DRAGSTART = "dragstart";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_KEYPRESS = "keypress";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEOUT = "mouseout";
    static final String DOMEVENT_MOUSEOVER = "mouseover";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static final int NOTIFY_PROGRESS = 1;
    static final int NOTIFY_TITLE = 2;
    static final int CREATE_WEB_VIEW = 3;
    static final int WEB_VIEW_READY = 4;
    static final int CLOSE_WEB_VIEW = 5;
    static final int LOAD_CHANGED = 6;
    static final int DECIDE_POLICY = 7;
    static final int MOUSE_TARGET_CHANGED = 8;
    static final int CONTEXT_MENU = 9;
    static final int AUTHENTICATE = 10;
    static final int DECIDE_DESTINATION = 11;
    static final int FAILED = 12;
    static final int FINISHED = 13;
    static final int DOWNLOAD_STARTED = 14;
    static final int WIDGET_EVENT = 15;
    static final int LOAD_FAILED_TLS = 16;
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";
    static final String SWT_WEBKITGTK_VERSION = "org.eclipse.swt.internal.webkitgtk.version";
    static Callback Proc2;
    static Callback Proc3;
    static Callback Proc4;
    static Callback Proc5;
    static Callback JSDOMEventProc;
    static final boolean ignoreTls;

    static {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        MIN_VERSION = nArray;
        SEPARATOR_FILE = File.separatorChar;
        Proc2 = new Callback(WebKit.class, "Proc", 2);
        Proc3 = new Callback(WebKit.class, "Proc", 3);
        Proc4 = new Callback(WebKit.class, "Proc", 4);
        Proc5 = new Callback(WebKit.class, "Proc", 5);
        new Webkit2AsyncToSync();
        WebKitExtension.init();
        JSDOMEventProc = new Callback(WebKit.class, "JSDOMEventProc", 3);
        NativeClearSessions = () -> {
            if (!WebKitGTK.LibraryLoaded) {
                return;
            }
            if (WebKitGTK.webkit_get_minor_version() >= 16) {
                long context = WebKitGTK.webkit_web_context_get_default();
                long manager = WebKitGTK.webkit_web_context_get_website_data_manager(context);
                WebKitGTK.webkit_website_data_manager_clear(manager, 256L, 0L, 0L, 0L, 0L);
            } else {
                System.err.println("SWT WebKit: clear sessions only supported on WebKitGtk version 2.16 and above. Your version is: " + WebKit.internalGetWebKitVersionStr());
            }
        };
        NativeGetCookie = () -> {
            if (!WebKitGTK.LibraryLoaded) {
                return;
            }
            if (WebKitGTK.webkit_get_minor_version() >= 20) {
                CookieValue = Webkit2AsyncToSync.getCookie(CookieUrl, CookieName);
            } else {
                System.err.println("SWT WebKit: getCookie() only supported on WebKitGTK version 2.20 and above. Your version is: " + WebKit.internalGetWebKitVersionStr());
            }
        };
        NativeSetCookie = () -> {
            if (!WebKitGTK.LibraryLoaded) {
                return;
            }
            if (WebKitGTK.webkit_get_minor_version() >= 20) {
                CookieResult = Webkit2AsyncToSync.setCookie(CookieUrl, CookieValue);
            } else {
                System.err.println("SWT WebKit: setCookie() only supported on WebKitGTK version 2.20 and above. Your version is: " + WebKit.internalGetWebKitVersionStr());
            }
        };
        if (NativePendingCookies != null) {
            WebKit.SetPendingCookies(NativePendingCookies);
            NativePendingCookies = null;
        }
        ignoreTls = "true".equals(System.getProperty("org.eclipse.swt.internal.webkitgtk.ignoretlserrors"));
    }

    WebKit() {
    }

    @Override
    public void createFunction(BrowserFunction function) {
        String url;
        if (!WebkitGDBus.initialized) {
            System.err.println("SWT webkit: WebkitGDBus and/or Webkit2Extension not loaded, BrowserFunction will not work.Tried to create " + function.name);
            return;
        }
        super.createFunction(function);
        String string = url = this.getUrl().isEmpty() ? "nullURL" : this.getUrl();
        if (!WebkitGDBus.connectionToExtensionCreated) {
            WebkitGDBus.functionsPending = true;
            ArrayList list = new ArrayList();
            ArrayList<String> functionAndUrl = new ArrayList<String>();
            functionAndUrl.add(0, function.functionString);
            functionAndUrl.add(1, url);
            list.add(functionAndUrl);
            ArrayList existing = WebkitGDBus.pendingBrowserFunctions.putIfAbsent(this.pageId, list);
            if (existing != null) {
                existing.add(functionAndUrl);
            }
        } else {
            boolean successful = this.webkit_extension_modify_function(this.pageId, function.functionString, url, "register");
            if (!successful) {
                System.err.println("SWT webkit: failure registering BrowserFunction " + function.name);
            }
        }
    }

    @Override
    public void destroyFunction(BrowserFunction function) {
        String url;
        boolean successful;
        if (WebkitGDBus.connectionToExtensionCreated && !(successful = this.webkit_extension_modify_function(this.pageId, function.functionString, url = this.getUrl().isEmpty() ? "nullURL" : this.getUrl(), "deregister"))) {
            System.err.println("SWT webkit: failure deregistering BrowserFunction from extension " + function.name);
        }
        super.destroyFunction(function);
    }

    private static String getInternalErrorMsg() {
        String reportErrMsg = "Please report this issue *with steps to reproduce* via:\n https://bugs.eclipse.org/bugs/enter_bug.cgi?alias=&assigned_to=platform-swt-inbox%40eclipse.org&attach_text=&blocked=&bug_file_loc=http%3A%2F%2F&bug_severity=normal&bug_status=NEW&comment=&component=SWT&contenttypeentry=&contenttypemethod=autodetect&contenttypeselection=text%2Fplain&data=&defined_groups=1&dependson=&description=&flag_type-1=X&flag_type-11=X&flag_type-12=X&flag_type-13=X&flag_type-14=X&flag_type-15=X&flag_type-16=X&flag_type-2=X&flag_type-4=X&flag_type-6=X&flag_type-7=X&flag_type-8=X&form_name=enter_bug&keywords=&maketemplate=Remember%20values%20as%20bookmarkable%20template&op_sys=Linux&product=Platform&qa_contact=&rep_platform=PC&requestee_type-1=&requestee_type-2=&short_desc=webkit2_BrowserProblem";
        return String.valueOf(reportErrMsg) + "\nFor bug report, please atatch this stack trace:\n" + WebKit.getStackTrace();
    }

    private static String getStackTrace() {
        StringWriter sw = new StringWriter();
        new Throwable("").printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    @Override
    String getJavaCallDeclaration() {
        return WebKitExtension.getJavaScriptFunctionDeclaration(this.webView);
    }

    private static int[] internalGetWebkitVersion() {
        int[] vers = new int[]{WebKitGTK.webkit_get_major_version(), WebKitGTK.webkit_get_minor_version(), WebKitGTK.webkit_get_micro_version()};
        return vers;
    }

    private static String internalGetWebKitVersionStr() {
        int[] vers = WebKit.internalGetWebkitVersion();
        return String.valueOf(String.valueOf(vers[0])) + "." + String.valueOf(vers[1]) + "." + String.valueOf(vers[2]);
    }

    static String getString(long strPtr) {
        int length = C.strlen(strPtr);
        byte[] buffer = new byte[length];
        C.memmove(buffer, strPtr, (long)length);
        return new String(Converter.mbcsToWcs(buffer));
    }

    static Browser FindBrowser(long webView) {
        if (webView == 0L) {
            return null;
        }
        long parent = GTK.gtk_widget_get_parent(webView);
        return (Browser)Display.getCurrent().findWidget(parent);
    }

    static boolean IsInstalled() {
        if (GTK.GTK4) {
            return false;
        }
        if (!WebKitGTK.LibraryLoaded) {
            return false;
        }
        int[] vers = WebKit.internalGetWebkitVersion();
        int major = vers[0];
        int minor = vers[1];
        int micro = vers[2];
        return major > MIN_VERSION[0] || major == MIN_VERSION[0] && minor > MIN_VERSION[1] || major == MIN_VERSION[0] && minor == MIN_VERSION[1] && micro >= MIN_VERSION[2];
    }

    static long JSDOMEventProc(long arg0, long event, long user_data) {
        block19: {
            block20: {
                Browser browser;
                block21: {
                    if (user_data != 15L) break block19;
                    browser = WebKit.FindBrowser(arg0);
                    if (browser == null || user_data != 15L) break block20;
                    block2 : switch (GDK.GDK_EVENT_TYPE(event)) {
                        case 8: {
                            if (!browser.isFocusControl()) break;
                            int[] key = new int[1];
                            int[] state = new int[1];
                            if (GTK.GTK4) {
                                key[0] = GDK.gdk_key_event_get_keyval(event);
                                state[0] = GDK.gdk_event_get_modifier_state(event);
                            } else {
                                GDK.gdk_event_get_keyval(event, key);
                                GDK.gdk_event_get_state(event, state);
                            }
                            switch (key[0]) {
                                case 65056: 
                                case 65289: {
                                    if ((state[0] & 0xC) == 0) {
                                        browser.getDisplay().asyncExec(() -> {
                                            if (browser.isDisposed()) {
                                                return;
                                            }
                                            if (browser.getDisplay().getFocusControl() == null) {
                                                int traversal = (state[0] & 1) != 0 ? 8 : 16;
                                                browser.traverse(traversal);
                                            }
                                        });
                                        break block2;
                                    }
                                    break block21;
                                }
                                case 65307: {
                                    Event keyEvent = new Event();
                                    keyEvent.widget = browser;
                                    keyEvent.type = 1;
                                    keyEvent.character = (char)27;
                                    keyEvent.keyCode = 27;
                                    if ((state[0] & 8) != 0) {
                                        keyEvent.stateMask |= 0x10000;
                                    }
                                    if ((state[0] & 1) != 0) {
                                        keyEvent.stateMask |= 0x20000;
                                    }
                                    if ((state[0] & 4) != 0) {
                                        keyEvent.stateMask |= 0x40000;
                                    }
                                    try {
                                        ++nonBlockingEvaluate;
                                        browser.webBrowser.sendKeyEvent(keyEvent);
                                    }
                                    finally {
                                        --nonBlockingEvaluate;
                                    }
                                    return 1L;
                                }
                            }
                        }
                    }
                }
                if (browser != null) {
                    GTK3.gtk_widget_event(browser.handle, event);
                }
            }
            return 0L;
        }
        return 0L;
    }

    static long Proc(long handle, long user_data) {
        long webView = handle;
        if (user_data == 13L) {
            long webKitDownload = handle;
            return WebKit.webkit_download_finished(webKitDownload);
        }
        Browser browser = WebKit.FindBrowser(webView);
        if (browser == null) {
            return 0L;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.webViewProc(handle, user_data);
    }

    static long Proc(long handle, long arg0, long user_data) {
        if (user_data == 14L) {
            long webKitDownload = arg0;
            WebKit.webkit_download_started(webKitDownload);
            return 0L;
        }
        if (user_data == 11L) {
            long webKitDownload = handle;
            long suggested_filename = arg0;
            return WebKit.webkit_download_decide_destination(webKitDownload, suggested_filename);
        }
        if (user_data == 12L) {
            long webKitDownload = handle;
            return WebKit.webkit_download_failed(webKitDownload);
        }
        assert (handle != 0L) : "Webview shouldn't be null here";
        long webView = handle;
        Browser browser = WebKit.FindBrowser(webView);
        if (browser == null) {
            return 0L;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.webViewProc(webView, arg0, user_data);
    }

    static long Proc(long handle, long arg0, long arg1, long user_data) {
        Browser browser = WebKit.FindBrowser(handle);
        if (browser == null) {
            return 0L;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.webViewProc(handle, arg0, arg1, user_data);
    }

    static long Proc(long handle, long arg0, long arg1, long arg2, long user_data) {
        long webView = handle;
        Browser browser = WebKit.FindBrowser(webView);
        if (browser == null) {
            return 0L;
        }
        WebKit webkit = (WebKit)browser.webBrowser;
        return webkit.webViewProc(handle, arg0, arg1, arg2, user_data);
    }

    long webkit_authenticate(long web_view, long request) {
        if (!WebKitGTK.webkit_authentication_request_is_retry(request)) {
            this.failureCount = 0;
        } else if (++this.failureCount >= 3) {
            return 0L;
        }
        String location = this.getUrl();
        int i = 0;
        while (i < this.authenticationListeners.length) {
            AuthenticationEvent event = new AuthenticationEvent(this.browser);
            event.location = location;
            try {
                ++nonBlockingEvaluate;
                this.authenticationListeners[i].authenticate(event);
            }
            finally {
                --nonBlockingEvaluate;
            }
            if (!event.doit) {
                WebKitGTK.webkit_authentication_request_cancel(request);
                return 0L;
            }
            if (event.user != null && event.password != null) {
                byte[] userBytes = Converter.wcsToMbcs(event.user, true);
                byte[] passwordBytes = Converter.wcsToMbcs(event.password, true);
                long credentials = WebKitGTK.webkit_credential_new(userBytes, passwordBytes, 0);
                WebKitGTK.webkit_authentication_request_authenticate(request, credentials);
                WebKitGTK.webkit_credential_free(credentials);
                return 0L;
            }
            ++i;
        }
        return 0L;
    }

    long webViewProc(long handle, long user_data) {
        switch ((int)user_data) {
            case 5: {
                return this.webkit_close_web_view(handle);
            }
            case 4: {
                return this.webkit_web_view_ready(handle);
            }
        }
        return 0L;
    }

    long webViewProc(long handle, long arg0, long user_data) {
        switch ((int)user_data) {
            case 3: {
                return this.webkit_create_web_view(handle, arg0);
            }
            case 6: {
                return this.webkit_load_changed(handle, (int)arg0, user_data);
            }
            case 1: {
                return this.webkit_notify_progress(handle, arg0);
            }
            case 2: {
                return this.webkit_notify_title(handle, arg0);
            }
            case 10: {
                return this.webkit_authenticate(handle, arg0);
            }
        }
        return 0L;
    }

    long webViewProc(long handle, long arg0, long arg1, long user_data) {
        switch ((int)user_data) {
            case 8: {
                return this.webkit_mouse_target_changed(handle, arg0, arg1);
            }
            case 7: {
                return this.webkit_decide_policy(handle, arg0, (int)arg1, user_data);
            }
        }
        return 0L;
    }

    long webViewProc(long handle, long arg0, long arg1, long arg2, long user_data) {
        switch ((int)user_data) {
            case 9: {
                return this.webkit_context_menu(handle, arg0, arg1, arg2);
            }
            case 16: {
                return this.webkit_load_failed_tls(handle, arg0, arg1, arg2);
            }
        }
        return 0L;
    }

    @Override
    public void create(Composite parent, int style) {
        int[] vers = WebKit.internalGetWebkitVersion();
        System.setProperty(SWT_WEBKITGTK_VERSION, String.format("%s.%s.%s", vers[0], vers[1], vers[2]));
        if (Device.DEBUG) {
            System.out.println(String.format("WebKit version %s.%s.%s", vers[0], vers[1], vers[2]));
        }
        Webkit2AsyncToSync.setCookieBrowser(this.browser);
        Composite parentShell = parent.getParent();
        Browser parentBrowser = null;
        if (parentShell != null) {
            Control[] children = parentShell.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Browser) {
                    parentBrowser = (Browser)children[i];
                    break;
                }
                ++i;
            }
        }
        this.webView = parentBrowser == null ? WebKitGTK.webkit_web_view_new() : WebKitGTK.webkit_web_view_new_with_related_view(((WebKit)parentBrowser.webBrowser).webView);
        if (!bug522733FirstInstanceCreated && vers[0] == 2 && vers[1] >= 18) {
            bug522733FirstInstanceCreated = true;
            OS.g_object_ref(this.webView);
        }
        if (ignoreTls) {
            WebKitGTK.webkit_web_context_set_tls_errors_policy(WebKitGTK.webkit_web_view_get_context(this.webView), 0);
            System.out.println("***WARNING: WebKitGTK is configured to ignore TLS errors via -Dorg.eclipse.swt.internal.webkitgtk.ignoretlserrors=true .");
            System.out.println("***WARNING: Please use for development purposes only!");
        }
        GTK3.gtk_container_add(this.browser.handle, this.webView);
        OS.g_signal_connect(this.webView, WebKitGTK.close, Proc2.getAddress(), 5L);
        OS.g_signal_connect(this.webView, WebKitGTK.ready_to_show, Proc2.getAddress(), 4L);
        OS.g_signal_connect(this.webView, WebKitGTK.decide_policy, Proc4.getAddress(), 7L);
        OS.g_signal_connect(this.webView, WebKitGTK.mouse_target_changed, Proc4.getAddress(), 8L);
        OS.g_signal_connect(this.webView, WebKitGTK.context_menu, Proc5.getAddress(), 9L);
        OS.g_signal_connect(this.webView, WebKitGTK.load_failed_with_tls_errors, Proc5.getAddress(), 16L);
        OS.g_signal_connect(this.webView, WebKitGTK.create, Proc3.getAddress(), 3L);
        OS.g_signal_connect(this.webView, WebKitGTK.load_changed, Proc3.getAddress(), 6L);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_estimated_load_progress, Proc3.getAddress(), 1L);
        OS.g_signal_connect(this.webView, WebKitGTK.authenticate, Proc3.getAddress(), 10L);
        OS.g_signal_connect(WebKitGTK.webkit_web_context_get_default(), WebKitGTK.download_started, Proc3.getAddress(), 14L);
        GTK.gtk_widget_show(this.webView);
        GTK.gtk_widget_show(this.browser.handle);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_title, Proc3.getAddress(), 2L);
        OS.g_signal_connect(this.webView, OS.button_press_event, JSDOMEventProc.getAddress(), 15L);
        OS.g_signal_connect(this.webView, OS.button_release_event, JSDOMEventProc.getAddress(), 15L);
        OS.g_signal_connect(this.webView, OS.focus_in_event, JSDOMEventProc.getAddress(), 15L);
        OS.g_signal_connect(this.webView, OS.focus_out_event, JSDOMEventProc.getAddress(), 15L);
        this.pageId = WebKitGTK.webkit_web_view_get_page_id(this.webView);
        OS.g_signal_connect(this.webView, OS.key_press_event, JSDOMEventProc.getAddress(), 15L);
        OS.g_signal_connect(this.webView, OS.key_release_event, JSDOMEventProc.getAddress(), 15L);
        OS.g_signal_connect(this.webView, OS.scroll_event, JSDOMEventProc.getAddress(), 15L);
        OS.g_signal_connect(this.webView, OS.motion_notify_event, JSDOMEventProc.getAddress(), 15L);
        byte[] utfBytes = Converter.wcsToMbcs("UTF-8", true);
        long settings = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(settings, WebKitGTK.javascript_can_open_windows_automatically, 1, 0L);
        OS.g_object_set(settings, WebKitGTK.enable_webgl, 1, 0L);
        OS.g_object_set(settings, WebKitGTK.enable_developer_extras, 1, 0L);
        OS.g_object_set(settings, WebKitGTK.default_charset, utfBytes, 0L);
        if (WebKitGTK.webkit_get_minor_version() >= 14) {
            OS.g_object_set(settings, WebKitGTK.allow_universal_access_from_file_urls, 1, 0L);
            if (WebKitGTK.webkit_get_minor_version() >= 24) {
                OS.g_object_set(settings, WebKitGTK.enable_back_forward_navigation_gestures, 1, 0L);
            }
        } else {
            System.err.println("SWT WEBKIT: Warning, you are using Webkitgtk below version 2.14. Your version is: Your version is: " + WebKit.internalGetWebKitVersionStr() + "\nJavascript execution limited to same origin due to unimplemented feature of this version.");
        }
        Listener listener = event -> {
            switch (event.type) {
                case 12: {
                    if (this.ignoreDispose) {
                        this.ignoreDispose = false;
                        break;
                    }
                    this.ignoreDispose = true;
                    this.browser.notifyListeners(event.type, event);
                    event.type = 0;
                    this.onDispose(event);
                    break;
                }
                case 15: {
                    if (this.webView == 0L) break;
                    GTK.gtk_widget_grab_focus(this.webView);
                    break;
                }
                case 11: {
                    this.onResize(event);
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(11, listener);
        this.browser.setData(KEY_CHECK_SUBWINDOW, Boolean.FALSE);
        int major = vers[0];
        int minor = vers[1];
        if (major == 1 && minor >= 10) {
            Rectangle minSize = this.browser.computeTrim(0, 0, 2, 2);
            Point size = this.browser.getSize();
            size.x += minSize.width;
            size.y += minSize.height;
            this.browser.setSize(size);
            size.x -= minSize.width;
            size.y -= minSize.height;
            this.browser.setSize(size);
        }
    }

    @Override
    public boolean back() {
        if (WebKitGTK.webkit_web_view_can_go_back(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_back(this.webView);
        return true;
    }

    @Override
    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean showPrompters) {
        Boolean result;
        if (!this.jsEnabled || !this.jsEnabledOnNextPage) {
            return true;
        }
        String message1 = Compatibility.getMessage("SWT_OnBeforeUnload_Message1");
        String message2 = Compatibility.getMessage("SWT_OnBeforeUnload_Message2");
        String functionName = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuilder buffer = new StringBuilder("function ");
        buffer.append(functionName);
        buffer.append("(win) {\n");
        buffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (showPrompters) {
            buffer.append("if (str != null) { ");
            buffer.append("var result = confirm('");
            buffer.append(message1);
            buffer.append("\\n\\n'+str+'\\n\\n");
            buffer.append(message2);
            buffer.append("');");
            buffer.append("if (!result) return false;}");
        }
        buffer.append("} catch (e) {}}");
        buffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        buffer.append(functionName);
        buffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        buffer.append("\n};");
        this.nonBlockingExecute(buffer.toString());
        try {
            result = (Boolean)this.evaluate("return " + functionName + "(window);");
            if (result == null) {
                return true;
            }
        }
        catch (SWTException sWTException) {
            return true;
        }
        return result;
    }

    private boolean isJavascriptEnabled() {
        return this.webkit_settings_get(WebKitGTK.enable_javascript) != 0;
    }

    @Override
    void nonBlockingExecute(String script) {
        try {
            ++nonBlockingEvaluate;
            this.execute(script);
        }
        finally {
            --nonBlockingEvaluate;
        }
    }

    private boolean webkit_extension_modify_function(long pageId, String function, String url, String action) {
        String returnString;
        long[] args = new long[]{OS.g_variant_new_uint64(pageId), OS.g_variant_new_string(Converter.javaStringToCString(function)), OS.g_variant_new_string(Converter.javaStringToCString(url))};
        long argsTuple = OS.g_variant_new_tuple(args, args.length);
        if (argsTuple == 0L) {
            return false;
        }
        String dbusMethodName = "webkitgtk_extension_" + action + "_function";
        Object returnVal = WebkitGDBus.callExtensionSync(argsTuple, dbusMethodName);
        if (returnVal instanceof Boolean) {
            return (Boolean)returnVal;
        }
        if (returnVal instanceof String && "timeout".equals(returnString = (String)returnVal)) {
            return WebkitGDBus.callExtensionAsync(argsTuple, dbusMethodName);
        }
        return false;
    }

    @Override
    public boolean execute(String script) {
        if (!this.isJavascriptEnabled()) {
            System.err.println("SWT Webkit Warning: Attempting to execute javascript when javascript is dissabled.Execution has no effect. Script:\n" + script);
            return false;
        }
        try {
            Webkit2AsyncToSync.runjavascript(script, this.browser, this.webView);
        }
        catch (SWTException sWTException) {
            return false;
        }
        return true;
    }

    @Override
    public Object evaluate(String script) throws SWTException {
        if ("".equals(script)) {
            return null;
        }
        if (!this.isJavascriptEnabled()) {
            return null;
        }
        return Webkit2AsyncToSync.evaluate(script, this.browser, this.webView);
    }

    @Override
    public boolean forward() {
        if (this.webView == 0L) {
            assert (false);
            System.err.println("SWT Webkit: forward() called after widget disposed. Should not have happened.\n" + WebKit.getInternalErrorMsg());
            return false;
        }
        if (WebKitGTK.webkit_web_view_can_go_forward(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_forward(this.webView);
        return true;
    }

    @Override
    public String getBrowserType() {
        return "webkit";
    }

    @Override
    public String getText() {
        return Webkit2AsyncToSync.getText(this.browser, this.webView);
    }

    @Override
    public String getUrl() {
        if (this.webView == 0L) {
            assert (false);
            System.err.println("SWT Webkit: getUrl() called after widget disposed. Should not have happened.\n" + WebKit.getInternalErrorMsg());
            return null;
        }
        long uri = WebKitGTK.webkit_web_view_get_uri(this.webView);
        if (uri == 0L) {
            return ABOUT_BLANK;
        }
        int length = C.strlen(uri);
        byte[] bytes = new byte[length];
        C.memmove(bytes, uri, (long)length);
        String url = new String(Converter.mbcsToWcs(bytes));
        if (url.equals(URI_FILEROOT)) {
            url = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                url = ABOUT_BLANK + url.substring(length);
            }
        }
        return url;
    }

    boolean handleDOMEvent(long event, int type) {
        String typeString = null;
        boolean isMouseEvent = false;
        switch (type) {
            case 29: {
                typeString = DOMEVENT_DRAGSTART;
                isMouseEvent = true;
                break;
            }
            case 3: {
                typeString = DOMEVENT_MOUSEDOWN;
                isMouseEvent = true;
                break;
            }
            case 5: {
                typeString = DOMEVENT_MOUSEMOVE;
                isMouseEvent = true;
                break;
            }
            case 4: {
                typeString = DOMEVENT_MOUSEUP;
                isMouseEvent = true;
                break;
            }
            case 37: {
                typeString = DOMEVENT_MOUSEWHEEL;
                isMouseEvent = true;
                break;
            }
            case 1: {
                typeString = DOMEVENT_KEYDOWN;
                break;
            }
            case 2: {
                typeString = DOMEVENT_KEYUP;
                break;
            }
            case -1: {
                typeString = DOMEVENT_KEYPRESS;
            }
        }
        if (isMouseEvent) {
            int screenX = (int)WebKitGTK.webkit_dom_mouse_event_get_screen_x(event);
            int screenY = (int)WebKitGTK.webkit_dom_mouse_event_get_screen_y(event);
            int button = WebKitGTK.webkit_dom_mouse_event_get_button(event) + 1;
            boolean altKey = WebKitGTK.webkit_dom_mouse_event_get_alt_key(event) != 0;
            boolean ctrlKey = WebKitGTK.webkit_dom_mouse_event_get_ctrl_key(event) != 0;
            boolean shiftKey = WebKitGTK.webkit_dom_mouse_event_get_shift_key(event) != 0;
            boolean metaKey = WebKitGTK.webkit_dom_mouse_event_get_meta_key(event) != 0;
            int detail = (int)WebKitGTK.webkit_dom_ui_event_get_detail(event);
            boolean hasRelatedTarget = false;
            return this.handleMouseEvent(typeString, screenX, screenY, detail, button, altKey, ctrlKey, shiftKey, metaKey, hasRelatedTarget);
        }
        int keyEventState = 0;
        long eventPtr = GTK3.gtk_get_current_event();
        if (eventPtr != 0L) {
            int eventType = GDK.gdk_event_get_event_type(eventPtr);
            int[] state = new int[1];
            if (GTK.GTK4) {
                state[0] = GDK.gdk_event_get_modifier_state(eventPtr);
            } else {
                GDK.gdk_event_get_state(eventPtr, state);
            }
            switch (eventType) {
                case 8: 
                case 9: {
                    keyEventState = state[0];
                }
            }
            if (GTK.GTK4) {
                OS.g_object_unref(eventPtr);
            } else {
                GDK.gdk_event_free(eventPtr);
            }
        }
        int keyCode = (int)WebKitGTK.webkit_dom_ui_event_get_key_code(event);
        int charCode = (int)WebKitGTK.webkit_dom_ui_event_get_char_code(event);
        boolean altKey = (keyEventState & 8) != 0;
        boolean ctrlKey = (keyEventState & 4) != 0;
        boolean shiftKey = (keyEventState & 1) != 0;
        return this.handleKeyEvent(typeString, keyCode, charCode, altKey, ctrlKey, shiftKey, false);
    }

    boolean handleEventFromFunction(Object[] arguments) {
        String type = (String)arguments[0];
        if (type.equals(DOMEVENT_KEYDOWN) || type.equals(DOMEVENT_KEYPRESS) || type.equals(DOMEVENT_KEYUP)) {
            return this.handleKeyEvent(type, ((Double)arguments[1]).intValue(), ((Double)arguments[2]).intValue(), (Boolean)arguments[3], (Boolean)arguments[4], (Boolean)arguments[5], (Boolean)arguments[6]);
        }
        return this.handleMouseEvent(type, ((Double)arguments[1]).intValue(), ((Double)arguments[2]).intValue(), ((Double)arguments[3]).intValue(), (arguments[4] != null ? ((Double)arguments[4]).intValue() : 0) + 1, (Boolean)arguments[5], (Boolean)arguments[6], (Boolean)arguments[7], (Boolean)arguments[8], (Boolean)arguments[9]);
    }

    boolean handleKeyEvent(String type, int keyCode, int charCode, boolean altKey, boolean ctrlKey, boolean shiftKey, boolean metaKey) {
        if (type.equals(DOMEVENT_KEYDOWN)) {
            this.lastKeyCode = keyCode = this.translateKey(keyCode);
            switch (keyCode) {
                case 8: 
                case 9: 
                case 27: 
                case 127: 
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: 
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: 
                case 0x1000009: 
                case 0x100000A: 
                case 0x100000B: 
                case 0x100000C: 
                case 0x100000D: 
                case 0x100000E: 
                case 0x100000F: 
                case 0x1000010: 
                case 0x1000011: 
                case 0x1000012: 
                case 0x1000013: 
                case 0x1000014: 
                case 0x1000015: 
                case 16777298: 
                case 16777299: 
                case 16777300: 
                case 0x1000055: {
                    Event keyEvent = new Event();
                    keyEvent.widget = this.browser;
                    keyEvent.type = type.equals(DOMEVENT_KEYDOWN) ? 1 : 2;
                    keyEvent.keyCode = keyCode;
                    switch (keyCode) {
                        case 8: {
                            keyEvent.character = (char)8;
                            break;
                        }
                        case 127: {
                            keyEvent.character = (char)127;
                            break;
                        }
                        case 27: {
                            keyEvent.character = (char)27;
                            break;
                        }
                        case 9: {
                            keyEvent.character = (char)9;
                        }
                    }
                    this.lastCharCode = keyEvent.character;
                    keyEvent.stateMask = (altKey ? 65536 : 0) | (ctrlKey ? 262144 : 0) | (shiftKey ? 131072 : 0) | (metaKey ? 0x400000 : 0);
                    keyEvent.stateMask &= ~keyCode;
                    int stateMask = keyEvent.stateMask;
                    if (!this.sendKeyEvent(keyEvent) || this.browser.isDisposed()) {
                        return false;
                    }
                    if (!this.browser.isFocusControl() || keyCode != 9 || (stateMask & 0x50000) != 0) break;
                    this.browser.getDisplay().asyncExec(() -> {
                        if (this.browser.isDisposed()) {
                            return;
                        }
                        if (this.browser.getDisplay().getFocusControl() == null) {
                            int traversal = (stateMask & 0x20000) != 0 ? 8 : 16;
                            this.browser.traverse(traversal);
                        }
                    });
                }
            }
            return true;
        }
        if (type.equals(DOMEVENT_KEYPRESS)) {
            if (this.lastKeyCode == 0) {
                return true;
            }
            this.lastCharCode = charCode;
            if (ctrlKey && this.lastCharCode >= 0 && this.lastCharCode <= 127) {
                if (97 <= this.lastCharCode && this.lastCharCode <= 122) {
                    this.lastCharCode -= 32;
                }
                if (64 <= this.lastCharCode && this.lastCharCode <= 95) {
                    this.lastCharCode -= 64;
                }
            }
            Event keyEvent = new Event();
            keyEvent.widget = this.browser;
            keyEvent.type = 1;
            keyEvent.keyCode = this.lastKeyCode;
            keyEvent.character = (char)this.lastCharCode;
            keyEvent.stateMask = (altKey ? 65536 : 0) | (ctrlKey ? 262144 : 0) | (shiftKey ? 131072 : 0) | (metaKey ? 0x400000 : 0);
            return this.sendKeyEvent(keyEvent) && !this.browser.isDisposed();
        }
        if ((keyCode = this.translateKey(keyCode)) == 0) {
            return true;
        }
        if (keyCode != this.lastKeyCode) {
            this.lastKeyCode = keyCode;
            this.lastCharCode = 0;
        }
        Event keyEvent = new Event();
        keyEvent.widget = this.browser;
        keyEvent.type = 2;
        keyEvent.keyCode = this.lastKeyCode;
        keyEvent.character = (char)this.lastCharCode;
        keyEvent.stateMask = (altKey ? 65536 : 0) | (ctrlKey ? 262144 : 0) | (shiftKey ? 131072 : 0) | (metaKey ? 0x400000 : 0);
        switch (this.lastKeyCode) {
            case 65536: 
            case 131072: 
            case 262144: 
            case 0x400000: {
                keyEvent.stateMask |= this.lastKeyCode;
            }
        }
        this.browser.notifyListeners(keyEvent.type, keyEvent);
        this.lastCharCode = 0;
        this.lastKeyCode = 0;
        return keyEvent.doit && !this.browser.isDisposed();
    }

    boolean handleMouseEvent(String type, int screenX, int screenY, int detail, int button, boolean altKey, boolean ctrlKey, boolean shiftKey, boolean metaKey, boolean hasRelatedTarget) {
        int mask;
        Point position = new Point(screenX, screenY);
        position = this.browser.getDisplay().map(null, (Control)this.browser, position);
        Event mouseEvent = new Event();
        mouseEvent.widget = this.browser;
        mouseEvent.x = position.x;
        mouseEvent.y = position.y;
        mouseEvent.stateMask = mask = (altKey ? 65536 : 0) | (ctrlKey ? 262144 : 0) | (shiftKey ? 131072 : 0) | (metaKey ? 0x400000 : 0);
        if (type.equals(DOMEVENT_MOUSEDOWN)) {
            mouseEvent.type = 3;
            mouseEvent.count = detail;
            mouseEvent.button = button;
            this.browser.notifyListeners(mouseEvent.type, mouseEvent);
            if (this.browser.isDisposed()) {
                return true;
            }
            if (detail == 2) {
                mouseEvent = new Event();
                mouseEvent.type = 8;
                mouseEvent.widget = this.browser;
                mouseEvent.x = position.x;
                mouseEvent.y = position.y;
                mouseEvent.stateMask = mask;
                mouseEvent.count = detail;
                mouseEvent.button = button;
                this.browser.notifyListeners(mouseEvent.type, mouseEvent);
            }
            return true;
        }
        if (type.equals(DOMEVENT_MOUSEUP)) {
            mouseEvent.type = 4;
            mouseEvent.count = detail;
            mouseEvent.button = button;
        } else if (type.equals(DOMEVENT_MOUSEMOVE)) {
            mouseEvent.type = 5;
        } else if (type.equals(DOMEVENT_MOUSEWHEEL)) {
            mouseEvent.type = 37;
            mouseEvent.count = detail;
        } else if (type.equals(DOMEVENT_DRAGSTART)) {
            mouseEvent.type = 29;
            mouseEvent.button = button;
            switch (mouseEvent.button) {
                case 1: {
                    mouseEvent.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    mouseEvent.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    mouseEvent.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    mouseEvent.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    mouseEvent.stateMask |= 0x2000000;
                }
            }
        }
        this.browser.notifyListeners(mouseEvent.type, mouseEvent);
        return true;
    }

    long handleLoadCommitted(long uri, boolean top) {
        int length = C.strlen(uri);
        byte[] bytes = new byte[length];
        C.memmove(bytes, uri, (long)length);
        String url = new String(Converter.mbcsToWcs(bytes));
        if (url.equals(URI_FILEROOT)) {
            url = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                url = ABOUT_BLANK + url.substring(length);
            }
        }
        LocationEvent event = new LocationEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.location = url;
        event.top = top;
        Runnable fireLocationChanged = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            int i = 0;
            while (i < this.locationListeners.length) {
                this.locationListeners[i].changed(event);
                ++i;
            }
        };
        this.browser.getDisplay().asyncExec(fireLocationChanged);
        return 0L;
    }

    private void fireProgressCompletedEvent() {
        Runnable fireProgressEvents = () -> {
            if (this.browser.isDisposed() || this.progressListeners == null) {
                return;
            }
            ProgressEvent progress = new ProgressEvent(this.browser);
            progress.display = this.browser.getDisplay();
            progress.widget = this.browser;
            progress.current = 100;
            progress.total = 100;
            int i = 0;
            while (i < this.progressListeners.length) {
                this.progressListeners[i].completed(progress);
                ++i;
            }
        };
        this.browser.getDisplay().asyncExec(fireProgressEvents);
    }

    @Override
    public boolean isBackEnabled() {
        if (this.webView == 0L) {
            return false;
        }
        return WebKitGTK.webkit_web_view_can_go_back(this.webView) != 0;
    }

    @Override
    public boolean isForwardEnabled() {
        return WebKitGTK.webkit_web_view_can_go_forward(this.webView) != 0;
    }

    void onDispose(Event e) {
        if (!this.browser.isDisposed() && !this.browser.isClosing) {
            this.close(false);
        }
        for (BrowserFunction function : this.functions.values()) {
            function.dispose(false);
        }
        this.functions = null;
        if (WebKitGTK.webkit_get_minor_version() >= 18) {
            OS.g_object_ref(this.webView);
            GTK3.gtk_container_remove(GTK.gtk_widget_get_parent(this.webView), this.webView);
            long webViewTempRef = this.webView;
            Display.getDefault().asyncExec(() -> OS.g_object_unref(webViewTempRef));
            this.webView = 0L;
        }
    }

    void onResize(Event e) {
        Rectangle rect = DPIUtil.autoScaleUp(this.browser.getClientArea());
        if (this.webView == 0L) {
            return;
        }
        GTK.gtk_widget_set_size_request(this.webView, rect.width, rect.height);
    }

    void openDownloadWindow(final long webkitDownload, String suggested_filename) {
        final Shell shell = new Shell();
        String msg = Compatibility.getMessage("SWT_FileDownload");
        shell.setText(msg);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        String nameString = suggested_filename;
        long request = WebKitGTK.webkit_download_get_request(webkitDownload);
        long url = WebKitGTK.webkit_uri_request_get_uri(request);
        int length = C.strlen(url);
        byte[] bytes = new byte[length];
        C.memmove(bytes, url, (long)length);
        String urlString = new String(Converter.mbcsToWcs(bytes));
        msg = Compatibility.getMessage("SWT_Download_Location", new Object[]{nameString, urlString});
        Label nameLabel = new Label(shell, 64);
        nameLabel.setText(msg);
        GridData data = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int maxWidth = monitor.getBounds().width / 2;
        int width = nameLabel.computeSize((int)-1, (int)-1).x;
        data.widthHint = Math.min(width, maxWidth);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        nameLabel.setLayoutData(data);
        final Label statusLabel = new Label(shell, 0);
        statusLabel.setText(Compatibility.getMessage("SWT_Download_Started"));
        data = new GridData(1808);
        statusLabel.setLayoutData(data);
        final Button cancel = new Button(shell, 8);
        cancel.setText(Compatibility.getMessage("SWT_Cancel"));
        data = new GridData();
        data.horizontalAlignment = 2;
        cancel.setLayoutData(data);
        final Listener cancelListener = event -> {
            webKitDownloadStatus.put(new LONG(webkitDownload), 2);
            WebKitGTK.webkit_download_cancel(webkitDownload);
        };
        cancel.addListener(13, cancelListener);
        OS.g_object_ref(webkitDownload);
        final Display display = this.browser.getDisplay();
        display.timerExec(500, new Runnable(){

            @Override
            public void run() {
                int status;
                int n = status = webKitDownloadStatus.containsKey(new LONG(webkitDownload)) ? webKitDownloadStatus.get(new LONG(webkitDownload)) : 0;
                if (shell.isDisposed() || status == 3 || status == 2) {
                    shell.dispose();
                    display.timerExec(-1, this);
                    OS.g_object_unref(webkitDownload);
                    webKitDownloadStatus.remove(new LONG(webkitDownload));
                    return;
                }
                if (status == -1) {
                    statusLabel.setText(Compatibility.getMessage("SWT_Download_Error"));
                    display.timerExec(-1, this);
                    OS.g_object_unref(webkitDownload);
                    cancel.removeListener(13, cancelListener);
                    cancel.addListener(13, event -> shell.dispose());
                    webKitDownloadStatus.remove(new LONG(webkitDownload));
                    return;
                }
                long current = WebKitGTK.webkit_download_get_received_data_length(webkitDownload) / 1024L;
                long response = WebKitGTK.webkit_download_get_response(webkitDownload);
                long total = WebKitGTK.webkit_uri_response_get_content_length(response) / 1024L;
                String message = Compatibility.getMessage("SWT_Download_Status", new Object[]{current, total});
                statusLabel.setText(message);
                display.timerExec(500, this);
            }
        });
        shell.pack();
        shell.open();
    }

    @Override
    public void refresh() {
        if (this.webView == 0L) {
            return;
        }
        WebKitGTK.webkit_web_view_reload(this.webView);
    }

    @Override
    public boolean setText(String html, boolean trusted) {
        byte[] html_bytes = (String.valueOf(html) + '\u0000').getBytes(StandardCharsets.UTF_8);
        w2_bug527738LastRequestCounter.incrementAndGet();
        byte[] uriBytes = !trusted ? Converter.wcsToMbcs(ABOUT_BLANK, true) : Converter.wcsToMbcs(URI_FILEROOT, true);
        WebKitGTK.webkit_web_view_load_html(this.webView, html_bytes, uriBytes);
        return true;
    }

    @Override
    public boolean setUrl(String url, String postData, String[] headers) {
        w2_bug527738LastRequestCounter.incrementAndGet();
        if (this.webView == 0L) {
            return false;
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            String testUrl = null;
            testUrl = url.charAt(0) == SEPARATOR_FILE ? PROTOCOL_FILE + url : PROTOCOL_HTTP + url;
            try {
                new URL(testUrl);
                url = testUrl;
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        long settings = WebKitGTK.webkit_web_view_get_settings(this.webView);
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                int index;
                String current = headers[i];
                if (current != null && (index = current.indexOf(58)) != -1) {
                    String key = current.substring(0, index).trim();
                    String value = current.substring(index + 1).trim();
                    if (key.length() > 0 && value.length() > 0 && key.equalsIgnoreCase(USER_AGENT)) {
                        byte[] bytes = Converter.wcsToMbcs(value, true);
                        OS.g_object_set(settings, WebKitGTK.user_agent, bytes, 0L);
                    }
                }
                ++i;
            }
        }
        byte[] uriBytes = Converter.wcsToMbcs(url, true);
        if (postData == null && headers != null) {
            long request = WebKitGTK.webkit_uri_request_new(uriBytes);
            long requestHeaders = WebKitGTK.webkit_uri_request_get_http_headers(request);
            if (requestHeaders != 0L) {
                this.addRequestHeaders(requestHeaders, headers);
            }
            WebKitGTK.webkit_web_view_load_request(this.webView, request);
            OS.g_object_set(settings, WebKitGTK.user_agent, 0, 0L);
            return true;
        }
        if (postData != null) {
            String base_url = url;
            long[] user_agent_str_ptr = new long[1];
            OS.g_object_get(settings, WebKitGTK.user_agent, user_agent_str_ptr, 0L);
            String userAgent = Converter.cCharPtrToJavaString(user_agent_str_ptr[0], true);
            int lastRequest = w2_bug527738LastRequestCounter.incrementAndGet();
            Thread send_request = new Thread(() -> {
                block36: {
                    String encoding_type;
                    String mime_type;
                    String html;
                    block33: {
                        html = null;
                        mime_type = null;
                        encoding_type = null;
                        try {
                            try {
                                OutputStream out22;
                                Object header;
                                URL base = new URL(base_url);
                                URLConnection url_conn = base.openConnection();
                                if (!(url_conn instanceof HttpURLConnection)) break block33;
                                HttpURLConnection conn = (HttpURLConnection)url_conn;
                                conn.setRequestMethod("POST");
                                conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
                                conn.setRequestProperty("User-Agent", userAgent);
                                conn.setDoOutput(true);
                                if (headers != null) {
                                    String[] stringArray2 = headers;
                                    int n2 = headers.length;
                                    int n3 = 0;
                                    while (n3 < n2) {
                                        header = stringArray2[n3];
                                        int index = ((String)header).indexOf(58);
                                        if (index > 0) {
                                            String key = ((String)header).substring(0, index).trim();
                                            String value = ((String)header).substring(index + 1).trim();
                                            conn.setRequestProperty(key, value);
                                        }
                                        ++n3;
                                    }
                                }
                                header = null;
                                Throwable throwable = null;
                                try {
                                    out22 = conn.getOutputStream();
                                    try {
                                        out22.write(postData.getBytes());
                                    }
                                    finally {
                                        if (out22 != null) {
                                            out22.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (header == null) {
                                        header = throwable2;
                                    } else if (header != throwable2) {
                                        ((Throwable)header).addSuppressed(throwable2);
                                    }
                                    throw header;
                                }
                                StringBuilder response = new StringBuilder();
                                throwable = null;
                                out22 = null;
                                try (BufferedReader buff = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                                    char[] cbuff = new char[4096];
                                    while (buff.read(cbuff, 0, cbuff.length) > 0) {
                                        response.append(new String(cbuff));
                                        Arrays.fill(cbuff, '\u0000');
                                    }
                                }
                                catch (Throwable out22) {
                                    if (throwable == null) {
                                        throwable = out22;
                                    } else if (throwable != out22) {
                                        throwable.addSuppressed(out22);
                                    }
                                    throw throwable;
                                }
                                html = response.toString();
                                String content_type = conn.getContentType();
                                int paramaterSeparatorIndex = content_type.indexOf(59);
                                String string4 = mime_type = paramaterSeparatorIndex > 0 ? content_type.substring(0, paramaterSeparatorIndex) : content_type;
                                if (content_type.indexOf(59) > 0) {
                                    String[] attrs;
                                    String[] stringArray3 = attrs = content_type.split(";");
                                    int n4 = attrs.length;
                                    int n5 = 0;
                                    while (n5 < n4) {
                                        String attr = stringArray3[n5];
                                        int i = attr.indexOf(61);
                                        if (i > 0) {
                                            String key = attr.substring(0, i).trim();
                                            String value = attr.substring(i + 1).trim();
                                            if ("charset".equalsIgnoreCase(key)) {
                                                encoding_type = value;
                                            }
                                        }
                                        ++n5;
                                    }
                                }
                            }
                            catch (IOException e) {
                                html = e.getMessage();
                                if (html != null && lastRequest == w2_bug527738LastRequestCounter.get()) {
                                    String final_html = html;
                                    String final_mime_type = mime_type;
                                    String final_encoding_type = encoding_type;
                                    Display.getDefault().syncExec(() -> {
                                        byte[] html_bytes = Converter.wcsToMbcs(final_html, false);
                                        byte[] mime_type_bytes = final_mime_type != null ? Converter.javaStringToCString(final_mime_type) : Converter.javaStringToCString("text/plain");
                                        byte[] encoding_bytes = final_encoding_type != null ? Converter.wcsToMbcs(final_encoding_type, true) : new byte[1];
                                        long gByte = OS.g_bytes_new(html_bytes, html_bytes.length);
                                        WebKitGTK.webkit_web_view_load_bytes(this.webView, gByte, mime_type_bytes, encoding_bytes, uriBytes);
                                        OS.g_bytes_unref(gByte);
                                        OS.g_object_set(settings, WebKitGTK.user_agent, 0, 0L);
                                    });
                                }
                                break block36;
                            }
                        }
                        catch (Throwable throwable) {
                            if (html != null && lastRequest == w2_bug527738LastRequestCounter.get()) {
                                String final_html = html;
                                String final_mime_type = mime_type;
                                String final_encoding_type = encoding_type;
                                Display.getDefault().syncExec(() -> {
                                    byte[] html_bytes = Converter.wcsToMbcs(final_html, false);
                                    byte[] mime_type_bytes = final_mime_type != null ? Converter.javaStringToCString(final_mime_type) : Converter.javaStringToCString("text/plain");
                                    byte[] encoding_bytes = final_encoding_type != null ? Converter.wcsToMbcs(final_encoding_type, true) : new byte[1];
                                    long gByte = OS.g_bytes_new(html_bytes, html_bytes.length);
                                    WebKitGTK.webkit_web_view_load_bytes(this.webView, gByte, mime_type_bytes, encoding_bytes, uriBytes);
                                    OS.g_bytes_unref(gByte);
                                    OS.g_object_set(settings, WebKitGTK.user_agent, 0, 0L);
                                });
                            }
                            throw throwable;
                        }
                    }
                    if (html != null && lastRequest == w2_bug527738LastRequestCounter.get()) {
                        String final_html = html;
                        String final_mime_type = mime_type;
                        String final_encoding_type = encoding_type;
                        Display.getDefault().syncExec(() -> {
                            byte[] html_bytes = Converter.wcsToMbcs(final_html, false);
                            byte[] mime_type_bytes = final_mime_type != null ? Converter.javaStringToCString(final_mime_type) : Converter.javaStringToCString("text/plain");
                            byte[] encoding_bytes = final_encoding_type != null ? Converter.wcsToMbcs(final_encoding_type, true) : new byte[1];
                            long gByte = OS.g_bytes_new(html_bytes, html_bytes.length);
                            WebKitGTK.webkit_web_view_load_bytes(this.webView, gByte, mime_type_bytes, encoding_bytes, uriBytes);
                            OS.g_bytes_unref(gByte);
                            OS.g_object_set(settings, WebKitGTK.user_agent, 0, 0L);
                        });
                    }
                }
            });
            send_request.start();
        } else {
            WebKitGTK.webkit_web_view_load_uri(this.webView, uriBytes);
        }
        if (postData == null) {
            OS.g_object_set(settings, WebKitGTK.user_agent, 0, 0L);
        }
        return true;
    }

    @Override
    public void stop() {
        WebKitGTK.webkit_web_view_stop_loading(this.webView);
    }

    long webkit_close_web_view(long web_view) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        Runnable fireCloseWindowListeners = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            int i = 0;
            while (i < this.closeWindowListeners.length) {
                this.closeWindowListeners[i].close(newEvent);
                ++i;
            }
            this.browser.dispose();
        };
        this.browser.getDisplay().asyncExec(fireCloseWindowListeners);
        return 0L;
    }

    long webkit_create_web_view(long web_view, long frame) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.required = true;
        Runnable fireOpenWindowListeners = () -> {
            if (this.openWindowListeners != null) {
                int i = 0;
                while (i < this.openWindowListeners.length) {
                    this.openWindowListeners[i].open(newEvent);
                    ++i;
                }
            }
        };
        try {
            ++nonBlockingEvaluate;
            fireOpenWindowListeners.run();
        }
        finally {
            --nonBlockingEvaluate;
        }
        Widget browser = null;
        if (newEvent.browser != null && newEvent.browser.webBrowser instanceof WebKit) {
            browser = newEvent.browser;
        }
        if (browser != null && !browser.isDisposed()) {
            return ((WebKit)((Browser)browser).webBrowser).webView;
        }
        return 0L;
    }

    static long webkit_download_started(long webKitDownload) {
        OS.g_signal_connect(webKitDownload, WebKitGTK.decide_destination, Proc3.getAddress(), 11L);
        OS.g_signal_connect(webKitDownload, WebKitGTK.failed, Proc3.getAddress(), 12L);
        OS.g_signal_connect(webKitDownload, WebKitGTK.finished, Proc2.getAddress(), 13L);
        return 1L;
    }

    static long webkit_download_decide_destination(long webKitDownload, long suggested_filename) {
        String fileName = WebKit.getString(suggested_filename);
        long webView = WebKitGTK.webkit_download_get_web_view(webKitDownload);
        if (webView != 0L) {
            Browser browser = WebKit.FindBrowser(webView);
            if (browser == null || browser.isDisposed() || browser.isClosing) {
                return 0L;
            }
            FileDialog dialog = new FileDialog(browser.getShell(), 8192);
            dialog.setFileName(fileName);
            String title = Compatibility.getMessage("SWT_FileDownload");
            dialog.setText(title);
            String path = dialog.open();
            if (path != null) {
                path = URI_FILEROOT + path;
                byte[] uriBytes = Converter.wcsToMbcs(path, true);
                if (WebKitGTK.webkit_get_minor_version() >= 6) {
                    WebKitGTK.webkit_download_set_allow_overwrite(webKitDownload, true);
                }
                WebKitGTK.webkit_download_set_destination(webKitDownload, uriBytes);
                ((WebKit)browser.webBrowser).openDownloadWindow(webKitDownload, fileName);
            }
        }
        return 0L;
    }

    static long webkit_download_finished(long download) {
        if (!webKitDownloadStatus.containsKey(new LONG(download))) {
            webKitDownloadStatus.put(new LONG(download), 3);
        }
        return 0L;
    }

    static long webkit_download_failed(long download) {
        if (!webKitDownloadStatus.containsKey(new LONG(download))) {
            webKitDownloadStatus.put(new LONG(download), -1);
        }
        return 0L;
    }

    long webkit_mouse_target_changed(long web_view, long hit_test_result, long modifiers) {
        if (WebKitGTK.webkit_hit_test_result_context_is_link(hit_test_result)) {
            long uri = WebKitGTK.webkit_hit_test_result_get_link_uri(hit_test_result);
            long title = WebKitGTK.webkit_hit_test_result_get_link_title(hit_test_result);
            return this.webkit_hovering_over_link(web_view, title, uri);
        }
        return 0L;
    }

    long webkit_hovering_over_link(long web_view, long title, long uri) {
        if (uri != 0L) {
            int length = C.strlen(uri);
            byte[] bytes = new byte[length];
            C.memmove(bytes, uri, (long)length);
            String text = new String(Converter.mbcsToWcs(bytes));
            StatusTextEvent event = new StatusTextEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            event.text = text;
            Runnable fireStatusTextListener = () -> {
                if (this.browser.isDisposed() || this.statusTextListeners == null) {
                    return;
                }
                int i = 0;
                while (i < this.statusTextListeners.length) {
                    this.statusTextListeners[i].changed(event);
                    ++i;
                }
            };
            this.browser.getDisplay().asyncExec(fireStatusTextListener);
        }
        return 0L;
    }

    long webkit_decide_policy(long web_view, long decision, int decision_type, long user_data) {
        switch (decision_type) {
            case 0: {
                long request = WebKitGTK.webkit_navigation_policy_decision_get_request(decision);
                if (request == 0L) {
                    return 0L;
                }
                long uri = WebKitGTK.webkit_uri_request_get_uri(request);
                String url = WebKit.getString(uri);
                if (url.equals(URI_FILEROOT)) {
                    url = ABOUT_BLANK;
                } else {
                    int length = URI_FILEROOT.length();
                    if (url.startsWith(URI_FILEROOT) && url.charAt(length) == '#') {
                        url = ABOUT_BLANK + url.substring(length);
                    }
                }
                LocationEvent newEvent = new LocationEvent(this.browser);
                newEvent.display = this.browser.getDisplay();
                newEvent.widget = this.browser;
                newEvent.location = url;
                newEvent.doit = true;
                try {
                    ++nonBlockingEvaluate;
                    if (this.locationListeners != null) {
                        int i = 0;
                        while (i < this.locationListeners.length) {
                            this.locationListeners[i].changing(newEvent);
                            ++i;
                        }
                    }
                }
                finally {
                    --nonBlockingEvaluate;
                }
                if (newEvent.doit && !this.browser.isDisposed() && this.jsEnabled != this.jsEnabledOnNextPage) {
                    this.jsEnabled = this.jsEnabledOnNextPage;
                    this.webkit_settings_set(WebKitGTK.enable_javascript, this.jsEnabled ? 1 : 0);
                }
                if (newEvent.doit) break;
                WebKitGTK.webkit_policy_decision_ignore(decision);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                boolean canShow;
                long response = WebKitGTK.webkit_response_policy_decision_get_response(decision);
                long mime_type = WebKitGTK.webkit_uri_response_get_mime_type(response);
                boolean bl = canShow = WebKitGTK.webkit_web_view_can_show_mime_type(this.webView, mime_type) != 0;
                if (canShow) break;
                WebKitGTK.webkit_policy_decision_download(decision);
                return 1L;
            }
            default: {
                return 0L;
            }
        }
        return 0L;
    }

    long webkit_load_changed(long web_view, int status, long user_data) {
        switch (status) {
            case 2: {
                long uri = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadCommitted(uri, true);
            }
            case 3: {
                if (this.firstLoad) {
                    GtkAllocation allocation = new GtkAllocation();
                    GTK.gtk_widget_get_allocation(this.browser.handle, allocation);
                    GTK3.gtk_widget_size_allocate(this.browser.handle, allocation);
                    this.firstLoad = false;
                }
                this.fireProgressCompletedEvent();
                if (this.tlsError && !ignoreTls) {
                    this.tlsError = false;
                    String javaHost = this.tlsErrorUri.getHost();
                    MessageBox prompt = new MessageBox(this.browser.getShell(), 192);
                    prompt.setText(SWT.getMessage("SWT_InvalidCert_Title"));
                    String specific = this.tlsErrorType.isEmpty() ? "\n\n" : "\n\n" + this.tlsErrorType + "\n\n";
                    String message = String.valueOf(SWT.getMessage("SWT_InvalidCert_Message", new Object[]{javaHost})) + specific + SWT.getMessage("SWT_InvalidCert_Connect");
                    prompt.setMessage(message);
                    int result = prompt.open();
                    if (result == 64) {
                        long webkitcontext = WebKitGTK.webkit_web_view_get_context(web_view);
                        if (javaHost != null) {
                            byte[] host = Converter.javaStringToCString(javaHost);
                            WebKitGTK.webkit_web_context_allow_tls_certificate_for_host(webkitcontext, this.tlsErrorCertificate, host);
                            WebKitGTK.webkit_web_view_reload(web_view);
                        } else {
                            System.err.println("***ERROR: Unable to parse host from URI!");
                        }
                    } else {
                        this.back();
                    }
                    if (this.tlsErrorCertificate != 0L) {
                        OS.g_object_unref(this.tlsErrorCertificate);
                        this.tlsErrorCertificate = 0L;
                    }
                }
                return 0L;
            }
        }
        return 0L;
    }

    long webkit_load_failed_tls(long web_view, long failing_uri, long certificate, long error) {
        if (!ignoreTls) {
            this.tlsError = true;
            OS.g_object_ref(certificate);
            this.tlsErrorCertificate = certificate;
            this.convertUri(failing_uri);
            switch ((int)error) {
                case 0: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_UnknownCA");
                    break;
                }
                case 1: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_BadIdentity");
                    break;
                }
                case 2: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_NotActivated");
                    break;
                }
                case 3: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_Expired");
                    break;
                }
                case 4: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_Revoked");
                    break;
                }
                case 5: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_Insecure");
                    break;
                }
                case 6: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_GenericError");
                    break;
                }
                case 7: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_ValidateAll");
                    break;
                }
                default: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_GenericError");
                }
            }
        }
        return 0L;
    }

    void convertUri(long webkitUri) {
        try {
            this.tlsErrorUriString = Converter.cCharPtrToJavaString(webkitUri, false);
            this.tlsErrorUri = new URI(this.tlsErrorUriString);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println("***ERROR: Malformed URI from WebKit!");
            return;
        }
    }

    long webkit_notify_progress(long web_view, long pspec) {
        ProgressEvent event = new ProgressEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        double progress = 0.0;
        progress = WebKitGTK.webkit_web_view_get_estimated_load_progress(this.webView);
        event.current = (int)(progress * 100.0);
        event.total = 100;
        Runnable fireProgressChangedEvents = () -> {
            if (this.browser.isDisposed() || this.progressListeners == null) {
                return;
            }
            int i = 0;
            while (i < this.progressListeners.length) {
                this.progressListeners[i].changed(event);
                ++i;
            }
        };
        this.browser.getDisplay().asyncExec(fireProgressChangedEvents);
        return 0L;
    }

    long webkit_notify_title(long web_view, long pspec) {
        String titleString;
        long title = WebKitGTK.webkit_web_view_get_title(this.webView);
        if (title == 0L) {
            titleString = "";
        } else {
            int length = C.strlen(title);
            byte[] bytes = new byte[length];
            C.memmove(bytes, title, (long)length);
            titleString = new String(Converter.mbcsToWcs(bytes));
        }
        TitleEvent event = new TitleEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.title = titleString;
        Runnable fireTitleListener = () -> {
            int i = 0;
            while (i < this.titleListeners.length) {
                this.titleListeners[i].changed(event);
                ++i;
            }
        };
        this.browser.getDisplay().asyncExec(fireTitleListener);
        return 0L;
    }

    long webkit_context_menu(long web_view, long context_menu, long eventXXX, long hit_test_result) {
        Point pt = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = pt.x;
        event.y = pt.y;
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            return 1L;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (pt.x != event.x || pt.y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 1L;
        }
        return 0L;
    }

    private void addRequestHeaders(long requestHeaders, String[] headers) {
        int i = 0;
        while (i < headers.length) {
            int index;
            String current = headers[i];
            if (current != null && (index = current.indexOf(58)) != -1) {
                String key = current.substring(0, index).trim();
                String value = current.substring(index + 1).trim();
                if (key.length() > 0 && value.length() > 0) {
                    byte[] nameBytes = Converter.wcsToMbcs(key, true);
                    byte[] valueBytes = Converter.wcsToMbcs(value, true);
                    WebKitGTK.soup_message_headers_append(requestHeaders, nameBytes, valueBytes);
                }
            }
            ++i;
        }
    }

    long webkit_web_view_ready(long web_view) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        long properties = WebKitGTK.webkit_web_view_get_window_properties(this.webView);
        newEvent.addressBar = this.webkit_settings_get(properties, WebKitGTK.locationbar_visible) != 0;
        newEvent.menuBar = this.webkit_settings_get(properties, WebKitGTK.menubar_visible) != 0;
        newEvent.statusBar = this.webkit_settings_get(properties, WebKitGTK.statusbar_visible) != 0;
        newEvent.toolBar = this.webkit_settings_get(properties, WebKitGTK.toolbar_visible) != 0;
        GdkRectangle rect = new GdkRectangle();
        WebKitGTK.webkit_window_properties_get_geometry(properties, rect);
        newEvent.location = new Point(Math.max(0, rect.x), Math.max(0, rect.y));
        int width = rect.width;
        int height = rect.height;
        if (height == 100 && width == 100) {
            Rectangle primaryMonitorBounds = this.browser.getDisplay().getPrimaryMonitor().getBounds();
            height = (int)((double)primaryMonitorBounds.height * 0.66);
            width = (int)((double)primaryMonitorBounds.width * 0.66);
        }
        newEvent.size = new Point(width, height);
        Runnable fireVisibilityListeners = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            int i = 0;
            while (i < this.visibilityWindowListeners.length) {
                this.visibilityWindowListeners[i].show(newEvent);
                ++i;
            }
        };
        this.browser.getDisplay().asyncExec(fireVisibilityListeners);
        return 0L;
    }

    private int webkit_settings_get(byte[] property) {
        if (this.webView == 0L) {
            return -1;
        }
        long settings = WebKitGTK.webkit_web_view_get_settings(this.webView);
        return this.webkit_settings_get(settings, property);
    }

    private int webkit_settings_get(long settings, byte[] property) {
        int[] result = new int[1];
        OS.g_object_get(settings, property, result, 0L);
        return result[0];
    }

    private void webkit_settings_set(byte[] property, int value) {
        if (this.webView == 0L) {
            return;
        }
        long settings = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(settings, property, value, 0L);
    }

    long convertToJS(long ctx, Object value) {
        if (value == null) {
            return WebKitGTK.JSValueMakeUndefined(ctx);
        }
        if (value instanceof String) {
            byte[] bytes = (String.valueOf((String)value) + '\u0000').getBytes(StandardCharsets.UTF_8);
            long stringRef = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
            long result = WebKitGTK.JSValueMakeString(ctx, stringRef);
            WebKitGTK.JSStringRelease(stringRef);
            return result;
        }
        if (value instanceof Boolean) {
            return WebKitGTK.JSValueMakeBoolean(ctx, (Boolean)value != false ? 1 : 0);
        }
        if (value instanceof Number) {
            return WebKitGTK.JSValueMakeNumber(ctx, ((Number)value).doubleValue());
        }
        if (value instanceof Object[]) {
            Object[] arrayValue = (Object[])value;
            int length = arrayValue.length;
            long[] arguments = new long[length];
            int i = 0;
            while (i < length) {
                long jsObject;
                Object javaObject = arrayValue[i];
                arguments[i] = jsObject = this.convertToJS(ctx, javaObject);
                ++i;
            }
            return WebKitGTK.JSObjectMakeArray(ctx, length, arguments, null);
        }
        SWT.error(51);
        return 0L;
    }

    static Object convertToJava(long ctx, long value) {
        int type = WebKitGTK.JSValueGetType(ctx, value);
        switch (type) {
            case 2: {
                int result = (int)WebKitGTK.JSValueToNumber(ctx, value, null);
                if (result != 0) {
                    return true;
                }
                return false;
            }
            case 3: {
                double result = WebKitGTK.JSValueToNumber(ctx, value, null);
                return result;
            }
            case 4: {
                long string = WebKitGTK.JSValueToStringCopy(ctx, value, null);
                if (string == 0L) {
                    return "";
                }
                long length = WebKitGTK.JSStringGetMaximumUTF8CStringSize(string);
                byte[] bytes = new byte[(int)length];
                length = WebKitGTK.JSStringGetUTF8CString(string, bytes, length);
                WebKitGTK.JSStringRelease(string);
                return new String(bytes, 0, (int)length - 1, StandardCharsets.UTF_8);
            }
            case 0: 
            case 1: {
                return null;
            }
            case 5: {
                byte[] bytes = "length\u0000".getBytes(StandardCharsets.UTF_8);
                long propertyName = WebKitGTK.JSStringCreateWithUTF8CString(bytes);
                long valuePtr = WebKitGTK.JSObjectGetProperty(ctx, value, propertyName, null);
                WebKitGTK.JSStringRelease(propertyName);
                type = WebKitGTK.JSValueGetType(ctx, valuePtr);
                if (type != 3) break;
                int length = (int)WebKitGTK.JSValueToNumber(ctx, valuePtr, null);
                Object[] result = new Object[length];
                int i = 0;
                while (i < length) {
                    long current = WebKitGTK.JSObjectGetPropertyAtIndex(ctx, value, i, null);
                    if (current != 0L) {
                        result[i] = WebKit.convertToJava(ctx, current);
                    }
                    ++i;
                }
                return result;
            }
        }
        SWT.error(5);
        return null;
    }

    static class WebKitExtension {
        private static final String javaScriptFunctionName = "webkit2callJava";
        private static final String webkitWebExtensionIdentifier = "webkitWebExtensionIdentifier";
        private static Callback initializeWebExtensions_callback;
        private static long dBusServer;
        private static boolean loadFailed;

        static {
            dBusServer = 0L;
        }

        WebKitExtension() {
        }

        static String getJavaScriptFunctionName() {
            return javaScriptFunctionName;
        }

        static String getWebExtensionIdentifier() {
            return webkitWebExtensionIdentifier;
        }

        static String getJavaScriptFunctionDeclaration(long webView) {
            return "if (!window.callJava) {\n\t\twindow.callJava = function callJava(index, token, args) {\n          return webkit2callJava('" + String.valueOf(webView) + "', index, token, args);\n" + "\t\t}\n" + "};\n";
        }

        static void init() {
            dBusServer = WebKitExtension.gdbus_init();
            if (dBusServer == 0L) {
                System.err.println("SWT WebKit: error initializing DBus server, dBusServer == 0");
            }
            initializeWebExtensions_callback = new Callback(WebKitExtension.class, "initializeWebExtensions_callback", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            if (WebKitGTK.webkit_get_minor_version() >= 4) {
                OS.g_signal_connect(WebKitGTK.webkit_web_context_get_default(), WebKitGTK.initialize_web_extensions, initializeWebExtensions_callback.getAddress(), 0L);
            }
        }

        static long gdbus_init() {
            if (WebKitGTK.webkit_get_minor_version() < 4) {
                System.err.println("SWT Webkit: Warning, You are using an old version of webkitgtk. (pre 2.4) BrowserFunction functionality will not be avaliable");
                return 0L;
            }
            if (!loadFailed) {
                return WebkitGDBus.init();
            }
            return 0L;
        }

        private static void initializeWebExtensions_callback(long WebKitWebContext, long user_data) {
            File extension;
            String swtVersion = Library.getVersionString();
            try {
                extension = Library.findResource("webkitextensions" + swtVersion, "swt-webkit2extension", true);
                if (extension == null) {
                    throw new UnsatisfiedLinkError("SWT Webkit could not find it's webextension");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println("SWT Webkit.java Error: Could not find webkit extension. BrowserFunction functionality will not be available. \n(swt version: " + swtVersion + ")" + " SWT Glue code version: 56.0" + " info: +BrowserFunction with private GDBus, +WebKitExtension Folder versioning, +WebKitExtension OSGI support, +setUrl(..postData..), setCookie(), getCookie +mouseDown/Focus +WebKit2 only");
                int[] vers = WebKit.internalGetWebkitVersion();
                System.err.println(String.format("WebKit2Gtk version %s.%s.%s", vers[0], vers[1], vers[2]));
                System.err.println(WebKit.getInternalErrorMsg());
                loadFailed = true;
                return;
            }
            String extensionsFolder = extension.getParent();
            WebKitGTK.webkit_web_context_set_web_extensions_directory(WebKitGTK.webkit_web_context_get_default(), Converter.wcsToMbcs(extensionsFolder, true));
            long clientAddress = OS.g_dbus_server_get_client_address(dBusServer);
            Converter.cCharPtrToJavaString(clientAddress, false);
            long gvariantUserData = OS.g_variant_new_string(clientAddress);
            WebKitGTK.webkit_web_context_set_web_extensions_initialization_user_data(WebKitGTK.webkit_web_context_get_default(), gvariantUserData);
        }

        static Object webkit2callJavaCallback(Object[] cb_args) {
            assert (cb_args.length == 4);
            Object returnValue = null;
            Long webViewLocal = Double.valueOf((String)cb_args[0]).longValue();
            Browser browser = WebKit.FindBrowser(webViewLocal);
            Integer functionIndex = ((Double)cb_args[1]).intValue();
            String token = (String)cb_args[2];
            BrowserFunction function = browser.webBrowser.functions.get(functionIndex);
            if (function == null) {
                System.err.println("SWT Webkit Error: Failed to find function with index: " + functionIndex);
                return null;
            }
            if (!function.token.equals(token)) {
                System.err.println("SWT Webkit Error: token mismatch for function with index: " + functionIndex);
                return null;
            }
            try {
                try {
                    ++nonBlockingEvaluate;
                    Object[] user_args = (Object[])cb_args[3];
                    returnValue = function.function(user_args);
                }
                catch (Exception e) {
                    System.err.println("SWT Webkit: Exception occured in user code of function: " + function.name);
                    returnValue = WebBrowser.CreateErrorString(e.getLocalizedMessage());
                    --nonBlockingEvaluate;
                }
            }
            finally {
                --nonBlockingEvaluate;
            }
            return returnValue;
        }
    }

    private static class Webkit2AsyncToSync {
        private static Browser cookieBrowser;
        private static Callback runjavascript_callback;
        private static Callback getText_callback;
        private static Callback setCookie_callback;
        private static Callback getCookie_callback;

        static {
            runjavascript_callback = new Callback(Webkit2AsyncToSync.class, "runjavascript_callback", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
            getText_callback = new Callback(Webkit2AsyncToSync.class, "getText_callback", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
            setCookie_callback = new Callback(Webkit2AsyncToSync.class, "setCookie_callback", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
            getCookie_callback = new Callback(Webkit2AsyncToSync.class, "getCookie_callback", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
        }

        private Webkit2AsyncToSync() {
        }

        static Object evaluate(String script, Browser browser, long webView) {
            String swtUniqueExecFunc = "SWTWebkit2TempFunc" + CallBackMap.getNextId() + "()";
            String wrappedScript = "function " + swtUniqueExecFunc + "{" + script + "}; " + swtUniqueExecFunc;
            return Webkit2AsyncToSync.runjavascript(wrappedScript, browser, webView);
        }

        static Object runjavascript(String script, Browser browser, long webView) {
            if (nonBlockingEvaluate > 0) {
                WebKitGTK.webkit_web_view_run_javascript(webView, Converter.wcsToMbcs(script, true), 0L, 0L, 0L);
                return null;
            }
            Consumer<Integer> asyncFunc = callbackId -> WebKitGTK.webkit_web_view_run_javascript(webView, Converter.wcsToMbcs(script, true), 0L, runjavascript_callback.getAddress(), callbackId.intValue());
            Webkit2AsyncReturnObj retObj = Webkit2AsyncToSync.execAsyncAndWaitForReturn(browser, asyncFunc, " The following javascript was executed:\n" + script + "\n\n");
            if (retObj.swtAsyncTimeout) {
                return null;
            }
            if (retObj.errorNum != 0) {
                throw new SWTException(retObj.errorNum, String.valueOf(retObj.errorMsg) + "\nScript that was evaluated:\n" + script);
            }
            return retObj.returnValue;
        }

        private static void runjavascript_callback(long GObject_source, long GAsyncResult, long user_data) {
            int callbackId = (int)user_data;
            Webkit2AsyncReturnObj retObj = CallBackMap.getObj(callbackId);
            if (retObj != null) {
                long[] gerror = new long[1];
                long js_result = WebKitGTK.webkit_web_view_run_javascript_finish(GObject_source, GAsyncResult, gerror);
                if (js_result == 0L) {
                    long errMsg = OS.g_error_get_message(gerror[0]);
                    String msg = Converter.cCharPtrToJavaString(errMsg, false);
                    OS.g_error_free(gerror[0]);
                    retObj.errorNum = 50;
                    retObj.errorMsg = msg != null ? msg : "";
                } else {
                    long context = WebKitGTK.webkit_javascript_result_get_global_context(js_result);
                    long value = WebKitGTK.webkit_javascript_result_get_value(js_result);
                    try {
                        retObj.returnValue = WebKit.convertToJava(context, value);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        retObj.errorNum = 51;
                        retObj.errorMsg = "Type of return value not is not valid. For supported types see: Browser.evaluate() JavaDoc";
                    }
                    WebKitGTK.webkit_javascript_result_unref(js_result);
                }
                retObj.callbackFinished = true;
            }
            Display.getCurrent().wake();
        }

        static String getText(Browser browser, long webView) {
            long WebKitWebResource = WebKitGTK.webkit_web_view_get_main_resource(webView);
            if (WebKitWebResource == 0L) {
                return "";
            }
            if (nonBlockingEvaluate > 0) {
                System.err.println("SWT Webkit Warning: getText() called inside a synchronous callback, which can lead to a deadlock.\nAvoid using getText in OpenWindowListener, Authentication listener and when webkit is about to change to a new page\nReturn value is empty string '' instead of actual text");
                return "";
            }
            Consumer<Integer> asyncFunc = callbackId -> WebKitGTK.webkit_web_resource_get_data(WebKitWebResource, 0L, getText_callback.getAddress(), callbackId.intValue());
            Webkit2AsyncReturnObj retObj = Webkit2AsyncToSync.execAsyncAndWaitForReturn(browser, asyncFunc, " getText() was called");
            if (retObj.swtAsyncTimeout) {
                return "SWT WEBKIT TIMEOUT ERROR";
            }
            return (String)retObj.returnValue;
        }

        private static void getText_callback(long WebResource, long GAsyncResult, long user_data) {
            int callbackId = (int)user_data;
            Webkit2AsyncReturnObj retObj = CallBackMap.getObj(callbackId);
            long[] gsize_len = new long[1];
            long[] gerrorRes = new long[1];
            long guchar_data = WebKitGTK.webkit_web_resource_get_data_finish(WebResource, GAsyncResult, gsize_len, gerrorRes);
            if (gerrorRes[0] != 0L || guchar_data == 0L) {
                OS.g_error_free(gerrorRes[0]);
                retObj.returnValue = "";
            } else {
                int len = (int)gsize_len[0];
                byte[] buffer = new byte[len];
                C.memmove(buffer, guchar_data, (long)len);
                String text = Converter.byteToStringViaHeuristic(buffer);
                retObj.returnValue = text;
            }
            retObj.callbackFinished = true;
            Display.getCurrent().wake();
        }

        static void setCookieBrowser(Browser toSet) {
            if (toSet != null) {
                cookieBrowser = toSet;
            }
        }

        static boolean setCookie(String cookieUrl, String cookieValue) {
            long context = WebKitGTK.webkit_web_context_get_default();
            long cookieManager = WebKitGTK.webkit_web_context_get_cookie_manager(context);
            byte[] bytes = Converter.wcsToMbcs(cookieUrl, true);
            long uri = WebKitGTK.soup_uri_new(bytes);
            if (uri == 0L) {
                System.err.println("SWT WebKit: SoupURI == 0 when setting cookie");
                return false;
            }
            bytes = Converter.wcsToMbcs(cookieValue, true);
            long soupCookie = WebKitGTK.soup_cookie_parse(bytes, uri);
            if (nonBlockingEvaluate > 0) {
                System.err.println("SWT Webkit: setCookie() called inside a synchronous callback, which can lead to a deadlock.\nReturn value is false.");
                return false;
            }
            Consumer<Integer> asyncFunc = callbackID -> WebKitGTK.webkit_cookie_manager_add_cookie(cookieManager, soupCookie, 0L, setCookie_callback.getAddress(), callbackID.intValue());
            Webkit2AsyncReturnObj retObj = Webkit2AsyncToSync.execAsyncAndWaitForReturn(cookieBrowser, asyncFunc, " setCookie() was called");
            WebKitGTK.soup_uri_free(uri);
            if (retObj.swtAsyncTimeout) {
                return false;
            }
            return (Boolean)retObj.returnValue;
        }

        private static void setCookie_callback(long cookieManager, long result, long user_data) {
            int callbackID = (int)user_data;
            Webkit2AsyncReturnObj retObj = CallBackMap.getObj(callbackID);
            long[] error = new long[1];
            retObj.returnValue = WebKitGTK.webkit_cookie_manager_add_cookie_finish(cookieManager, result, error);
            if (error[0] != 0L) {
                long errorMessageC = OS.g_error_get_message(error[0]);
                String errorMessageStr = Converter.cCharPtrToJavaString(errorMessageC, false);
                System.err.println("SWT WebKit: error setting cookie: " + errorMessageStr);
                OS.g_error_free(error[0]);
            }
            retObj.callbackFinished = true;
            Display.getCurrent().wake();
        }

        static String getCookie(String cookieUrl, String cookieName) {
            long context = WebKitGTK.webkit_web_context_get_default();
            long cookieManager = WebKitGTK.webkit_web_context_get_cookie_manager(context);
            byte[] uri = Converter.wcsToMbcs(cookieUrl, true);
            if (nonBlockingEvaluate > 0) {
                System.err.println("SWT Webkit: getCookie() called inside a synchronous callback, which can lead to a deadlock.\nReturn value is an empty string '' instead of actual cookie value.");
                return "";
            }
            Consumer<Integer> asyncFunc = callbackID -> WebKitGTK.webkit_cookie_manager_get_cookies(cookieManager, uri, 0L, getCookie_callback.getAddress(), WebkitGDBus.convertJavaToGVariant(new Object[]{cookieName, callbackID}));
            Webkit2AsyncReturnObj retObj = Webkit2AsyncToSync.execAsyncAndWaitForReturn(cookieBrowser, asyncFunc, " getCookie() was called");
            if (retObj.swtAsyncTimeout) {
                return "SWT WEBKIT TIMEOUT ERROR";
            }
            return (String)retObj.returnValue;
        }

        private static void getCookie_callback(long cookieManager, long result, long user_data) {
            Object resultObject = WebkitGDBus.convertGVariantToJava(user_data);
            if (resultObject instanceof Object[]) {
                Object[] nameAndId = (Object[])resultObject;
                String cookieName = (String)nameAndId[0];
                int callbackId = ((Number)nameAndId[1]).intValue();
                Webkit2AsyncReturnObj retObj = CallBackMap.getObj(callbackId);
                long[] error = new long[1];
                long cookieList = WebKitGTK.webkit_cookie_manager_get_cookies_finish(cookieManager, result, error);
                if (error[0] != 0L) {
                    long errorMessageC = OS.g_error_get_message(error[0]);
                    String errorMessageStr = Converter.cCharPtrToJavaString(errorMessageC, false);
                    System.err.println("SWT WebKit: error getting cookie: " + errorMessageStr);
                    OS.g_error_free(error[0]);
                    retObj.returnValue = "";
                }
                int length = OS.g_slist_length(cookieList);
                long current = cookieList;
                int i = 0;
                while (i < length) {
                    long soupCookie = OS.g_slist_data(current);
                    long soupName = WebKitGTK.soup_cookie_get_name(soupCookie);
                    String soupNameStr = Converter.cCharPtrToJavaString(soupName, false);
                    if (soupNameStr != null && soupNameStr.equals(cookieName)) {
                        long soupValue = WebKitGTK.soup_cookie_get_value(soupCookie);
                        retObj.returnValue = Converter.cCharPtrToJavaString(soupValue, false);
                        break;
                    }
                    current = OS.g_slist_next(current);
                    ++i;
                }
                OS.g_slist_free(cookieList);
                retObj.callbackFinished = true;
                Display.getCurrent().wake();
            } else {
                System.err.println("SWT WebKit: something went wrong unpacking GVariant tuple for getCookie_callback");
            }
        }

        private static Webkit2AsyncReturnObj execAsyncAndWaitForReturn(Browser browser, Consumer<Integer> asyncFunc, String additionalErrorInfo) {
            Webkit2AsyncReturnObj retObj = new Webkit2AsyncReturnObj();
            int callbackId = CallBackMap.putObject(retObj);
            asyncFunc.accept(callbackId);
            Instant timeOut = Instant.now().plusMillis(10000L);
            while (!browser.isDisposed()) {
                if (retObj.callbackFinished) break;
                if (Instant.now().isAfter(timeOut)) {
                    System.err.println("SWT call to Webkit timed out after 10000ms. No return value will be provided.\nPossible reasons:\n1) Problem: Your javascript needs more than 10000ms to execute.\n   Solution: Don't run such javascript, it blocks Eclipse's UI. SWT currently allows such code to complete, but this error is thrown \n     and the return value of execute()/evalute() will be false/null.\n\n2) However, if you believe that your application should execute as expected (in under10000 ms),\n then it might be a deadlock in SWT/Browser/webkit2 logic.\n I.e, it might be a bug in SWT (e.g this does not occur on Windows/Cocoa, but occurs on Linux). If you believe it to be a bug in SWT, then\n" + WebKit.getInternalErrorMsg() + "\n Additional information about the error is as following:\n" + additionalErrorInfo);
                    retObj.swtAsyncTimeout = true;
                    break;
                }
                if (GTK.GTK4) {
                    OS.g_main_context_iteration(0L, true);
                    continue;
                }
                GTK3.gtk_main_iteration_do(true);
            }
            CallBackMap.removeObject(callbackId);
            return retObj;
        }

        private static class CallBackMap {
            private static HashMap<Integer, Webkit2AsyncReturnObj> callbackMap = new HashMap();
            private static int nextCallbackId = 1;
            private static HashSet<Integer> usedCallbackIds = new HashSet();

            private CallBackMap() {
            }

            static int putObject(Webkit2AsyncReturnObj obj) {
                int id = CallBackMap.getNextId();
                callbackMap.put(id, obj);
                return id;
            }

            static Webkit2AsyncReturnObj getObj(int id) {
                return callbackMap.get(id);
            }

            static void removeObject(int id) {
                callbackMap.remove(id);
                CallBackMap.removeId(id);
            }

            static int getNextId() {
                int value = 0;
                boolean unique = false;
                while (!unique) {
                    value = nextCallbackId;
                    boolean bl = unique = !usedCallbackIds.contains(value);
                    if (nextCallbackId != Integer.MAX_VALUE) {
                        ++nextCallbackId;
                        continue;
                    }
                    nextCallbackId = 1;
                }
                usedCallbackIds.add(value);
                return value;
            }

            private static void removeId(int id) {
                usedCallbackIds.remove(id);
            }
        }

        private static class Webkit2AsyncReturnObj {
            boolean callbackFinished = false;
            Object returnValue = null;
            int errorNum = 0;
            String errorMsg;
            boolean swtAsyncTimeout;

            private Webkit2AsyncReturnObj() {
            }
        }
    }
}

