/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.core.op.TagOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.commit.command.CherryPickUI;
import org.eclipse.egit.ui.internal.components.BranchNameNormalizer;
import org.eclipse.egit.ui.internal.dialogs.BranchEditDialog;
import org.eclipse.egit.ui.internal.dialogs.CancelableFuture;
import org.eclipse.egit.ui.internal.dialogs.NonBlockingWizardDialog;
import org.eclipse.egit.ui.internal.fetch.FetchHeadChangedEvent;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.egit.ui.internal.gerrit.GerritDialogSettings;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AbstractFetchFromHostPage
extends WizardPage {
    @NonNull
    private final Repository repository;
    private final IDialogSettings settings;
    private final String lastUriKey;
    private Combo uriCombo;
    private Map<String, CancelableFuture<Collection<Change>>> changeRefs = new HashMap<String, CancelableFuture<Collection<Change>>>();
    private Map<String, AtomicBoolean> gettingRefs = new HashMap<String, AtomicBoolean>();
    private Text refText;
    private Button createBranch;
    private Button createTag;
    private Button checkoutFetchHead;
    private Button cherryPickFetchHead;
    private Button updateFetchHead;
    private Label placeholder;
    private Label tagTextlabel;
    private Text tagText;
    private Label branchTextlabel;
    private Text branchText;
    private String initialRefText;
    private Composite warningAdditionalRefNotActive;
    private Button activateAdditionalRefs;
    private IInputValidator branchValidator;
    private IInputValidator tagValidator;
    private Button branchEditButton;
    private Button branchCheckoutButton;
    private UIUtils.ExplicitContentProposalAdapter contentProposer;
    private boolean branchTextEdited;
    private boolean refTextEdited;
    private boolean tagTextEdited;
    private boolean fetching;
    private boolean supportsCherryPick;
    private String changeLabel;
    private String changeNameSingular;
    private String changeNamePlural;

    public AbstractFetchFromHostPage(Repository repository, String initialText, String changeLabel, String changeNameSingular, String changeNamePlural, boolean supportsCherryPick) {
        super(AbstractFetchFromHostPage.class.getName());
        Assert.isNotNull((Object)repository);
        this.repository = repository;
        this.initialRefText = initialText;
        this.supportsCherryPick = supportsCherryPick;
        this.changeLabel = changeLabel;
        this.changeNameSingular = changeNameSingular;
        this.changeNamePlural = changeNamePlural;
        this.settings = this.getDialogSettings();
        this.lastUriKey = repository + ".lastUri";
        this.branchValidator = ValidationUtils.getRefNameInputValidator(repository, "refs/heads/", true);
        this.tagValidator = ValidationUtils.getRefNameInputValidator(repository, "refs/tags/", true);
        this.setTitle(MessageFormat.format(UIText.AbstractFetchFromHostPage_PageTitle, RepositoryUtil.INSTANCE.getRepositoryName(repository)));
        this.setMessage(MessageFormat.format(UIText.AbstractFetchFromHostPage_PageMessage, changeNameSingular));
    }

    protected IDialogSettings getDialogSettings() {
        return GerritDialogSettings.getSection(GerritDialogSettings.FETCH_FROM_GERRIT_SECTION);
    }

    public void createControl(Composite parent) {
        IWizardContainer container;
        Change defaultChange;
        CheckoutMode mode;
        parent.addDisposeListener(event -> {
            this.changeRefs.values().forEach(l -> {
                boolean bl = l.cancel(CancelableFuture.CancelMode.INTERRUPT);
            });
            this.changeRefs.clear();
        });
        Defaults defaults = null;
        if (this.initialRefText != null) {
            defaults = this.getDefaults(this.initialRefText);
        }
        SelectionAdapter validatePage = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractFetchFromHostPage.this.placeholder != null) {
                    AbstractFetchFromHostPage.this.placeholder.setVisible(false);
                    ((GridData)AbstractFetchFromHostPage.this.placeholder.getLayoutData()).exclude = true;
                }
                AbstractFetchFromHostPage.this.checkPage();
            }
        };
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        new Label(main, 0).setText(UIText.AbstractFetchFromHostPage_UriLabel);
        this.uriCombo = new Combo(main, 4);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.uriCombo);
        this.uriCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String uriText = AbstractFetchFromHostPage.this.uriCombo.getText();
                CancelableFuture<Collection<Change>> list = AbstractFetchFromHostPage.this.changeRefs.get(uriText);
                if (list != null) {
                    list.cancel(CancelableFuture.CancelMode.INTERRUPT);
                }
                list = AbstractFetchFromHostPage.this.createChangeList(AbstractFetchFromHostPage.this.repository, uriText);
                AbstractFetchFromHostPage.this.changeRefs.put(uriText, list);
                AbstractFetchFromHostPage.this.gettingRefs.put(uriText, new AtomicBoolean());
                AbstractFetchFromHostPage.this.preFetch(list);
            }
        });
        new Label(main, 0).setText(this.changeLabel);
        this.refText = new Text(main, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.refText);
        this.contentProposer = this.addRefContentProposalToText(this.refText);
        this.refText.addVerifyListener(event -> {
            String string = event.text = Utils.toSingleLine((String)event.text).trim();
        });
        final Group checkoutGroup = new Group(main, 16);
        checkoutGroup.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)checkoutGroup);
        checkoutGroup.setText(UIText.AbstractFetchFromHostPage_AfterFetchGroup);
        this.createBranch = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)this.createBranch);
        this.createBranch.setText(UIText.AbstractFetchFromHostPage_LocalBranchRadio);
        this.createBranch.addSelectionListener((SelectionListener)validatePage);
        this.branchCheckoutButton = new Button((Composite)checkoutGroup, 32);
        GridDataFactory.fillDefaults().span(2, 1).align(0x1000008, 0x1000000).applyTo((Control)this.branchCheckoutButton);
        this.branchCheckoutButton.setFont(JFaceResources.getDialogFont());
        this.branchCheckoutButton.setText(UIText.AbstractFetchFromHostPage_LocalBranchCheckout);
        this.branchCheckoutButton.setSelection(true);
        this.branchTextlabel = new Label((Composite)checkoutGroup, 0);
        GridDataFactory.defaultsFor((Control)this.branchTextlabel).exclude(false).applyTo((Control)this.branchTextlabel);
        this.branchTextlabel.setText(UIText.AbstractFetchFromHostPage_BranchNameText);
        this.branchText = new Text((Composite)checkoutGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.branchText);
        this.branchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AbstractFetchFromHostPage.this.branchTextEdited = true;
            }
        });
        this.branchText.addVerifyListener(event -> {
            if (event.text.isEmpty()) {
                this.branchTextEdited = false;
            }
        });
        this.branchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractFetchFromHostPage.this.checkPage();
            }
        });
        BranchNameNormalizer normalizer = new BranchNameNormalizer(this.branchText);
        normalizer.setVisible(false);
        this.branchEditButton = new Button((Composite)checkoutGroup, 8);
        this.branchEditButton.setFont(JFaceResources.getDialogFont());
        this.branchEditButton.setText(UIText.AbstractFetchFromHostPage_BranchEditButton);
        this.branchEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String txt = AbstractFetchFromHostPage.this.branchText.getText();
                String refToMark = txt.isEmpty() ? null : "refs/heads/" + txt;
                BranchEditDialog dlg = new BranchEditDialog(checkoutGroup.getShell(), AbstractFetchFromHostPage.this.repository, refToMark);
                if (dlg.open() == 0) {
                    AbstractFetchFromHostPage.this.branchText.setText(Repository.shortenRefName((String)dlg.getRefName()));
                    AbstractFetchFromHostPage.this.branchTextEdited = true;
                } else {
                    AbstractFetchFromHostPage.this.branchText.setText(AbstractFetchFromHostPage.this.branchText.getText());
                }
            }
        });
        GridDataFactory.defaultsFor((Control)this.branchEditButton).exclude(false).applyTo((Control)this.branchEditButton);
        this.createTag = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.createTag);
        this.createTag.setText(UIText.AbstractFetchFromHostPage_TagRadio);
        this.createTag.addSelectionListener((SelectionListener)validatePage);
        this.tagTextlabel = new Label((Composite)checkoutGroup, 0);
        GridDataFactory.defaultsFor((Control)this.tagTextlabel).exclude(true).applyTo((Control)this.tagTextlabel);
        this.tagTextlabel.setText(UIText.AbstractFetchFromHostPage_TagNameText);
        this.tagText = new Text((Composite)checkoutGroup, 2052);
        GridDataFactory.fillDefaults().exclude(true).grab(true, false).applyTo((Control)this.tagText);
        this.tagText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AbstractFetchFromHostPage.this.tagTextEdited = true;
            }
        });
        this.tagText.addVerifyListener(event -> {
            if (event.text.isEmpty()) {
                this.tagTextEdited = false;
            }
        });
        this.tagText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractFetchFromHostPage.this.checkPage();
            }
        });
        BranchNameNormalizer tagNormalizer = new BranchNameNormalizer(this.tagText, UIText.BranchNameNormalizer_TooltipForTag);
        tagNormalizer.setVisible(false);
        this.checkoutFetchHead = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.checkoutFetchHead);
        this.checkoutFetchHead.setText(UIText.AbstractFetchFromHostPage_CheckoutRadio);
        this.checkoutFetchHead.addSelectionListener((SelectionListener)validatePage);
        if (this.supportsCherryPick) {
            try {
                String headName = this.repository.getBranch();
                if (headName != null) {
                    this.cherryPickFetchHead = new Button((Composite)checkoutGroup, 16);
                    GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.cherryPickFetchHead);
                    this.cherryPickFetchHead.setText(MessageFormat.format(UIText.AbstractFetchFromHostPage_CherryPickRadio, headName));
                    this.cherryPickFetchHead.addSelectionListener((SelectionListener)validatePage);
                }
            }
            catch (IOException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        }
        this.updateFetchHead = new Button((Composite)checkoutGroup, 16);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.updateFetchHead);
        this.updateFetchHead.setText(UIText.AbstractFetchFromHostPage_UpdateRadio);
        this.updateFetchHead.addSelectionListener((SelectionListener)validatePage);
        CheckoutMode checkoutMode = mode = defaults == null ? null : defaults.getCommand();
        if (mode == null) {
            this.createBranch.setSelection(true);
        } else {
            switch (mode) {
                case CHECKOUT_FETCH_HEAD: {
                    this.checkoutFetchHead.setSelection(true);
                    this.placeholder = new Label(main, 0);
                    GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.placeholder);
                    break;
                }
                case CHERRY_PICK: {
                    if (this.cherryPickFetchHead != null) {
                        this.cherryPickFetchHead.setSelection(true);
                        this.placeholder = new Label(main, 0);
                        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.placeholder);
                        break;
                    }
                    this.createBranch.setSelection(true);
                    break;
                }
                default: {
                    this.createBranch.setSelection(true);
                }
            }
        }
        this.warningAdditionalRefNotActive = new Composite(main, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).exclude(true).applyTo((Control)this.warningAdditionalRefNotActive);
        this.warningAdditionalRefNotActive.setLayout((Layout)new GridLayout(2, false));
        this.warningAdditionalRefNotActive.setVisible(false);
        this.activateAdditionalRefs = new Button(this.warningAdditionalRefNotActive, 32);
        this.activateAdditionalRefs.setText(UIText.AbstractFetchFromHostPage_ActivateAdditionalRefsButton);
        this.activateAdditionalRefs.setToolTipText(UIText.AbstractFetchFromHostPage_ActivateAdditionalRefsTooltip);
        ActionUtils.setGlobalActions((Control)this.refText, ActionUtils.createGlobalAction(ActionFactory.PASTE, () -> {
            if (this.doPaste(this.refText) && this.contentProposer != null) {
                this.refText.getDisplay().asyncExec(() -> {
                    if (!this.refText.isDisposed()) {
                        this.contentProposer.openProposalPopup();
                    }
                });
            }
        }));
        this.refText.addModifyListener(event -> {
            this.refTextEdited = true;
            Change change = this.changeFromString(this.refText.getText());
            String suggestion = "";
            if (change != null) {
                suggestion = change.getBranchSuggestion();
            }
            if (!this.branchTextEdited) {
                this.branchText.setText(suggestion);
            }
            if (!this.tagTextEdited) {
                this.tagText.setText(suggestion);
            }
            this.checkPage();
        });
        Change change = defaultChange = defaults == null ? null : defaults.getChange();
        if (defaultChange != null) {
            String ref = defaultChange.getRefName();
            if (ref != null) {
                this.refText.setText(ref);
            } else {
                this.refText.setText(Long.toString(defaultChange.getChangeNumber()));
            }
        }
        this.refTextEdited = false;
        String defaultUri = defaults == null ? null : defaults.getUri();
        Set<String> upstream = this.determineUris(this.repository, defaultUri);
        upstream.stream().sorted().forEach(u -> {
            this.uriCombo.add(u);
            this.changeRefs.put((String)u, this.createChangeList(this.repository, (String)u));
            this.gettingRefs.put((String)u, new AtomicBoolean());
        });
        if (defaultUri != null) {
            this.uriCombo.setText(defaultUri);
        } else {
            this.selectLastUsedUri();
        }
        String currentUri = this.uriCombo.getText();
        CancelableFuture<Collection<Change>> list = this.changeRefs.get(currentUri);
        if (list == null) {
            list = this.createChangeList(this.repository, currentUri);
            this.changeRefs.put(currentUri, list);
            this.gettingRefs.put(currentUri, new AtomicBoolean());
        }
        this.preFetch(list);
        this.refText.setFocus();
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
        if (defaultChange != null && !defaultChange.isComplete() && (container = this.getContainer()) instanceof IPageChangeProvider) {
            ((IPageChangeProvider)container).addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (event.getSelectedPage() == AbstractFetchFromHostPage.this) {
                        event.getPageChangeProvider().removePageChangedListener((IPageChangedListener)this);
                        AbstractFetchFromHostPage.this.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Control control = AbstractFetchFromHostPage.this.getControl();
                                if (control != null && !control.isDisposed()) {
                                    (this).AbstractFetchFromHostPage.this.contentProposer.openProposalPopup();
                                }
                            }
                        });
                    }
                }
            });
        }
        this.checkPage();
    }

    abstract Set<String> determineUris(Repository var1, String var2);

    abstract CancelableFuture<Collection<Change>> createChangeList(Repository var1, String var2);

    abstract Change changeFromRef(String var1);

    abstract Change changeFromString(String var1);

    abstract Defaults getDefaults(String var1);

    abstract Pattern getProposalPattern(String var1);

    private void preFetch(CancelableFuture<?> list) {
        try {
            list.start();
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e.getLocalizedMessage(), e.getCause(), true);
        }
    }

    private boolean doPaste(Text text) {
        block9: {
            Clipboard clipboard = new Clipboard(text.getDisplay());
            try {
                String clipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (clipText == null) break block9;
                Change input = this.changeFromString(clipText.trim());
                if (input != null) {
                    String toInsert = Long.toString(input.getChangeNumber());
                    boolean replacesEverything = text.getText().trim().isEmpty() || text.getSelectionText().equals(text.getText());
                    boolean openContentAssist = false;
                    if (input.isComplete()) {
                        toInsert = replacesEverything ? input.getRefName() : input.completeId();
                    } else {
                        openContentAssist = replacesEverything;
                    }
                    clipboard.setContents(new Object[]{toInsert}, new Transfer[]{TextTransfer.getInstance()});
                    try {
                        text.paste();
                        this.refTextEdited = false;
                    }
                    catch (Throwable throwable) {
                        clipboard.setContents(new Object[]{clipText}, new Transfer[]{TextTransfer.getInstance()});
                        throw throwable;
                    }
                    clipboard.setContents(new Object[]{clipText}, new Transfer[]{TextTransfer.getInstance()});
                    boolean bl = openContentAssist;
                    return bl;
                }
                text.paste();
            }
            finally {
                clipboard.dispose();
            }
        }
        return false;
    }

    protected String getSettingsKey() {
        return "";
    }

    private void storeLastUsedUri(String uri) {
        this.settings.put(String.valueOf(this.lastUriKey) + this.getSettingsKey(), uri.trim());
    }

    private void selectLastUsedUri() {
        int i;
        String lastUri = this.settings.get(String.valueOf(this.lastUriKey) + this.getSettingsKey());
        if (lastUri != null && (i = this.uriCombo.indexOf(lastUri)) != -1) {
            this.uriCombo.select(i);
            return;
        }
        this.uriCombo.select(0);
    }

    /*
     * Exception decompiling
     */
    private void checkPage() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Collection<Change> getRefsForContentAssist() throws InvocationTargetException, InterruptedException {
        CancelableFuture<Collection<Change>> list;
        final String uriText = this.uriCombo.getText();
        if (!this.changeRefs.containsKey(uriText)) {
            this.changeRefs.put(uriText, this.createChangeList(this.repository, uriText));
            this.gettingRefs.put(uriText, new AtomicBoolean());
        }
        if (!(list = this.changeRefs.get(uriText)).isFinished()) {
            if (!this.gettingRefs.get(uriText).compareAndSet(false, true)) {
                return null;
            }
            final IWizardContainer container = this.getContainer();
            IRunnableWithProgress operation = monitor -> {
                monitor.beginTask(MessageFormat.format(UIText.AsynchronousRefProposalProvider_FetchingRemoteRefsMessage, uriText), -1);
                final Collection result = (Collection)list.get();
                if (monitor.isCanceled()) {
                    return;
                }
                if (result == null || result.isEmpty() || this.fetching) {
                    return;
                }
                WorkbenchJob showProposals = new WorkbenchJob(UIText.AsynchronousRefProposalProvider_ShowingProposalsJobName){

                    public IStatus runInUIThread(IProgressMonitor uiMonitor) {
                        try {
                            if (container instanceof NonBlockingWizardDialog) {
                                if (AbstractFetchFromHostPage.this.fetching) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                String uriNow = AbstractFetchFromHostPage.this.uriCombo.getText();
                                if (!uriNow.equals(uriText)) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                if (AbstractFetchFromHostPage.this.refText != AbstractFetchFromHostPage.this.refText.getDisplay().getFocusControl()) {
                                    AbstractFetchFromHostPage.this.refTextEdited = false;
                                    AbstractFetchFromHostPage.this.fillInPatchSet(result);
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                            }
                            try {
                                AbstractFetchFromHostPage.this.fillInPatchSet(result);
                                AbstractFetchFromHostPage.this.contentProposer.openProposalPopup();
                            }
                            catch (SWTException e) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                        }
                        finally {
                            uiMonitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                showProposals.schedule();
            };
            if (container instanceof NonBlockingWizardDialog) {
                NonBlockingWizardDialog dialog = (NonBlockingWizardDialog)container;
                dialog.run(operation, () -> {
                    if (!this.fetching) {
                        list.cancel(CancelableFuture.CancelMode.ABANDON);
                    }
                });
            } else {
                container.run(true, true, operation);
            }
            return null;
        }
        Collection<Change> changes = list.get();
        this.fillInPatchSet(changes);
        return changes;
    }

    private void fillInPatchSet(Collection<Change> changes) {
        Change fromGerrit;
        if (this.refTextEdited || this.contentProposer.isProposalPopupOpen()) {
            return;
        }
        Change change = this.changeFromString(this.refText.getText());
        if (change != null && !change.isComplete() && (fromGerrit = change.complete(changes)) != null) {
            String fullRef = fromGerrit.getRefName();
            this.refText.setText(fullRef);
            this.refTextEdited = false;
            this.refText.setSelection(fullRef.length());
        }
    }

    boolean doFetch() {
        CheckoutMode mode;
        CancelableFuture<Collection<Change>> changeList;
        this.fetching = true;
        final Change change = this.changeFromString(this.refText.getText());
        final String uri = this.uriCombo.getText();
        CancelableFuture<Collection<Change>> cancelableFuture = changeList = change.isComplete() ? null : this.changeRefs.remove(uri);
        if (changeList != null) {
            changeList.cancel(CancelableFuture.CancelMode.ABANDON);
        }
        final boolean doCheckoutNewBranch = (mode = this.getCheckoutMode()) == CheckoutMode.CREATE_BRANCH && this.branchCheckoutButton.getSelection();
        final boolean doActivateAdditionalRefs = this.showAdditionalRefs();
        final String textForTag = this.tagText.getText();
        final String textForBranch = this.branchText.getText();
        final String taskName = MessageFormat.format(UIText.AbstractFetchFromHostPage_GetChangeTaskName, this.changeNamePlural);
        Job job = new Job(taskName){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    final int steps = this.getTotalWork(mode);
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)(steps + 1));
                    Change finalChange = change;
                    if (changeList != null) {
                        finalChange = change.complete(changeList, uri, (IProgressMonitor)progress.newChild(1));
                    }
                    if (finalChange == null) {
                        Activator.showError(MessageFormat.format(UIText.AbstractFetchFromHostPage_NoSuchChangeMessage, AbstractFetchFromHostPage.this.changeNameSingular, Long.toString(change.getChangeNumber())), null);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    final RefSpec spec = new RefSpec().setSource(finalChange.getRefName()).setDestination("FETCH_HEAD");
                    if (progress.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        final RevCommit commit = AbstractFetchFromHostPage.this.fetchChange(uri, spec, (IProgressMonitor)progress.newChild(1));
                        if (mode != CheckoutMode.NOCHECKOUT && commit != null) {
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                                public void run(IProgressMonitor innerMonitor) throws CoreException {
                                    SubMonitor innerProgress = SubMonitor.convert((IProgressMonitor)innerMonitor, (int)steps);
                                    switch (mode) {
                                        case CHECKOUT_FETCH_HEAD: {
                                            AbstractFetchFromHostPage.this.checkout(commit.name(), (IProgressMonitor)innerProgress.newChild(1));
                                            break;
                                        }
                                        case CREATE_TAG: {
                                            if (!$assertionsDisabled && spec == null) {
                                                throw new AssertionError();
                                            }
                                            if (!$assertionsDisabled && textForTag == null) {
                                                throw new AssertionError();
                                            }
                                            AbstractFetchFromHostPage.this.createTag(spec, textForTag, commit, (IProgressMonitor)innerProgress.newChild(1));
                                            AbstractFetchFromHostPage.this.checkout(commit.name(), (IProgressMonitor)innerProgress.newChild(1));
                                            break;
                                        }
                                        case CREATE_BRANCH: {
                                            AbstractFetchFromHostPage.this.createBranch(textForBranch, doCheckoutNewBranch, commit, (IProgressMonitor)innerProgress.newChild(1));
                                            break;
                                        }
                                        case CHERRY_PICK: {
                                            AbstractFetchFromHostPage.this.cherryPick(commit, (IProgressMonitor)innerProgress.newChild(1));
                                            break;
                                        }
                                    }
                                }
                            };
                            workspace.run(operation, null, 1, (IProgressMonitor)progress.newChild(steps));
                        }
                        if (doActivateAdditionalRefs) {
                            AbstractFetchFromHostPage.this.activateAdditionalRefs();
                        }
                        if (mode == CheckoutMode.NOCHECKOUT) {
                            AbstractFetchFromHostPage.this.repository.fireEvent((RepositoryEvent)new FetchHeadChangedEvent());
                        }
                        AbstractFetchFromHostPage.this.storeLastUsedUri(uri);
                    }
                    catch (OperationCanceledException oe) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (CoreException ce) {
                        IStatus iStatus = ce.getStatus();
                        return iStatus;
                    }
                    catch (Exception e) {
                        IStatus iStatus = Activator.createErrorStatus(e.getLocalizedMessage(), e);
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                super.canceling();
                if (changeList != null) {
                    changeList.cancel(CancelableFuture.CancelMode.INTERRUPT);
                }
            }

            private int getTotalWork(CheckoutMode m) {
                switch (m) {
                    case CREATE_BRANCH: 
                    case CHECKOUT_FETCH_HEAD: 
                    case CHERRY_PICK: {
                        return 2;
                    }
                    case CREATE_TAG: {
                        return 3;
                    }
                }
                return 1;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.FETCH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }

    private boolean showAdditionalRefs() {
        return (this.checkoutFetchHead.getSelection() || this.cherryPickFetchHead != null && this.cherryPickFetchHead.getSelection() || this.updateFetchHead.getSelection()) && this.activateAdditionalRefs.getSelection();
    }

    private CheckoutMode getCheckoutMode() {
        if (this.createBranch.getSelection()) {
            return CheckoutMode.CREATE_BRANCH;
        }
        if (this.createTag.getSelection()) {
            return CheckoutMode.CREATE_TAG;
        }
        if (this.checkoutFetchHead.getSelection()) {
            return CheckoutMode.CHECKOUT_FETCH_HEAD;
        }
        if (this.cherryPickFetchHead != null && this.cherryPickFetchHead.getSelection()) {
            return CheckoutMode.CHERRY_PICK;
        }
        return CheckoutMode.NOCHECKOUT;
    }

    private RevCommit fetchChange(String uri, RefSpec spec, IProgressMonitor monitor) throws CoreException, URISyntaxException, IOException {
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>(1);
        specs.add(spec);
        String taskName = MessageFormat.format(UIText.AbstractFetchFromHostPage_FetchingTaskName, this.changeNameSingular, spec.getSource());
        monitor.subTask(taskName);
        FetchResult fetchRes = new FetchOperationUI(this.repository, new URIish(uri), specs, false).execute(monitor);
        monitor.worked(1);
        Throwable throwable = null;
        Object var8_9 = null;
        try (RevWalk rw = new RevWalk(this.repository);){
            return rw.parseCommit((AnyObjectId)fetchRes.getAdvertisedRef(spec.getSource()).getObjectId());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createTag(@NonNull RefSpec spec, @NonNull String textForTag, @NonNull RevCommit commit, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(UIText.AbstractFetchFromHostPage_CreatingTagTaskName);
        PersonIdent personIdent = new PersonIdent(this.repository);
        TagOperation operation = new TagOperation(this.repository).setAnnotated(true).setName(textForTag).setTagger(personIdent).setMessage(MessageFormat.format(UIText.AbstractFetchFromHostPage_GeneratedTagMessage, this.changeNameSingular, spec.getSource())).setTarget(commit).setSign(Boolean.FALSE);
        operation.execute(monitor);
        monitor.worked(1);
    }

    private void createBranch(String textForBranch, boolean doCheckout, RevCommit commit, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(doCheckout ? 10 : 2));
        progress.subTask(UIText.AbstractFetchFromHostPage_CreatingBranchTaskName);
        CreateLocalBranchOperation bop = new CreateLocalBranchOperation(this.repository, textForBranch, commit);
        bop.execute((IProgressMonitor)progress.newChild(2));
        if (doCheckout) {
            this.checkout(textForBranch, (IProgressMonitor)progress.newChild(8));
        }
    }

    private void checkout(String targetName, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(MessageFormat.format(UIText.AbstractFetchFromHostPage_CheckingOutTaskName, this.changeNameSingular));
        BranchOperationUI.checkout(this.repository, targetName).run(monitor);
        monitor.worked(1);
    }

    private void cherryPick(final @NonNull RevCommit commit, IProgressMonitor monitor) {
        String taskName = MessageFormat.format(UIText.AbstractFetchFromHostPage_CherryPickTaskName, this.changeNameSingular);
        monitor.subTask(taskName);
        WorkbenchJob job = new WorkbenchJob(PlatformUI.getWorkbench().getDisplay(), taskName){

            public IStatus runInUIThread(IProgressMonitor progress) {
                try {
                    try {
                        CherryPickUI ui = new CherryPickUI();
                        ui.run(AbstractFetchFromHostPage.this.repository, commit, false);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = Activator.createErrorStatus(e.getLocalizedMessage(), e);
                        progress.done();
                        return iStatus;
                    }
                }
                finally {
                    progress.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        monitor.worked(1);
    }

    private void activateAdditionalRefs() {
        Activator.getDefault().getPreferenceStore().setValue("resourcehistory_show_additionalrefs", true);
    }

    private UIUtils.ExplicitContentProposalAdapter addRefContentProposalToText(Text textField) {
        return UIUtils.addContentProposalToText(textField, () -> {
            try {
                return this.getRefsForContentAssist();
            }
            catch (InvocationTargetException e) {
                Activator.handleError(e.getMessage(), e, true);
                return null;
            }
            catch (InterruptedException e) {
                return null;
            }
        }, (pattern, change) -> {
            if (pattern == null || pattern.matcher(change.getRefName()).matches()) {
                return change.getProposal();
            }
            return null;
        }, this::getProposalPattern, null, MessageFormat.format(UIText.AbstractFetchFromHostPage_ContentAssistTooltip, this.changeNamePlural));
    }

    protected static interface Change
    extends Comparable<Change> {
        public String getRefName();

        public long getChangeNumber();

        public IContentProposal getProposal();

        public boolean isComplete();

        public Change complete(CancelableFuture<Collection<Change>> var1, String var2, IProgressMonitor var3);

        public Change complete(Collection<Change> var1);

        public String getBranchSuggestion();

        public String completeId();
    }

    static enum CheckoutMode {
        CREATE_BRANCH,
        CREATE_TAG,
        CHECKOUT_FETCH_HEAD,
        CHERRY_PICK,
        NOCHECKOUT;

    }

    static class Defaults {
        private final String uri;
        private final CheckoutMode command;
        private final Change change;

        public Defaults(String uri, CheckoutMode command, Change change) {
            this.uri = uri;
            this.command = command;
            this.change = change;
        }

        public String getUri() {
            return this.uri;
        }

        public CheckoutMode getCommand() {
            return this.command;
        }

        public Change getChange() {
            return this.change;
        }
    }
}

