/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.ui.IEditorReference;

public class EnableDisableLSJob
extends Job {
    private final List<ContentTypeToLanguageServerDefinition> serverDefinitions;
    private final IEditorReference[] editors;

    public EnableDisableLSJob(List<ContentTypeToLanguageServerDefinition> serverDefinitions, IEditorReference[] editors) {
        super(Messages.enableDisableLSJob);
        this.serverDefinitions = serverDefinitions;
        this.editors = editors;
    }

    protected IStatus run(IProgressMonitor monitor) {
        for (ContentTypeToLanguageServerDefinition changedDefinition : this.serverDefinitions) {
            LanguageServersRegistry.LanguageServerDefinition serverDefinition = (LanguageServersRegistry.LanguageServerDefinition)changedDefinition.getValue();
            if (serverDefinition == null) continue;
            if (!changedDefinition.isEnabled()) {
                LanguageServiceAccessor.disableLanguageServerContentType(changedDefinition);
                continue;
            }
            if (this.editors == null) continue;
            LanguageServiceAccessor.enableLanguageServerContentType(changedDefinition, this.editors);
        }
        return Status.OK_STATUS;
    }
}

