/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.linkedediting;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class LSPLinkedEditingBase
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String LINKED_EDITING_PREFERENCE = "org.eclipse.ui.genericeditor.linkedediting";
    protected LinkedEditingRanges fLinkedEditingRanges;
    private CompletableFuture<Void> request;
    protected boolean fEnabled;

    protected void install() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.fEnabled = preferences.getBoolean(LINKED_EDITING_PREFERENCE, true);
    }

    protected void uninstall() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.cancel();
    }

    protected CompletableFuture<LinkedEditingRanges> collectLinkedEditingRanges(IDocument document, int offset) {
        Position position;
        this.fLinkedEditingRanges = null;
        this.cancel();
        if (document == null) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            position = LSPEclipseUtils.toPosition(offset, document);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return CompletableFuture.completedFuture(null);
        }
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return CompletableFuture.completedFuture(null);
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri.toString());
        TextDocumentPositionParams params = new TextDocumentPositionParams(identifier, position);
        AtomicReference range = new AtomicReference();
        return ((CompletableFuture)LanguageServiceAccessor.getLanguageServers(document, capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getLinkedEditingRangeProvider())).thenComposeAsync(languageServers -> CompletableFuture.allOf((CompletableFuture[])languageServers.stream().map(ls -> ls.getTextDocumentService().linkedEditingRange(LSPEclipseUtils.toLinkedEditingRangeParams(params)).thenAcceptAsync(result -> {
            if (result != null && result.getRanges() != null && result.getRanges().size() > 1) {
                range.set(result);
            }
        })).toArray(CompletableFuture[]::new)))).thenApplyAsync(theVoid -> (LinkedEditingRanges)range.get());
    }

    private void cancel() {
        if (this.request != null && !this.request.isDone()) {
            this.request.cancel(true);
            this.request = null;
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(LINKED_EDITING_PREFERENCE)) {
            this.fEnabled = Boolean.valueOf(event.getNewValue().toString());
        }
    }
}

