/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.core.mapping.ResourceVariantFileRevision;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.internal.ui.synchronize.SynchronizeViewWorkbenchPart;
import org.eclipse.team.internal.ui.synchronize.WorkbenchPartSynchronizePageSite;
import org.eclipse.team.internal.ui.synchronize.actions.PasteAction;
import org.eclipse.team.internal.ui.synchronize.actions.PinParticipantAction;
import org.eclipse.team.internal.ui.synchronize.actions.RemoveSynchronizeParticipantAction;
import org.eclipse.team.internal.ui.synchronize.actions.SynchronizeAndRefreshAction;
import org.eclipse.team.internal.ui.synchronize.actions.SynchronizePageDropDownAction;
import org.eclipse.team.internal.ui.synchronize.actions.ToggleLinkingAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantListener;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SynchronizeView
extends PageBookView
implements ISynchronizeView,
ISynchronizeParticipantListener,
IPropertyChangeListener,
ISaveablesSource,
ISaveablePart,
IShowInTarget {
    public static final int MAX_NAME_LENGTH = 100;
    private ISynchronizeParticipant activeParticipantRef = null;
    private Map<ISynchronizeParticipant, IWorkbenchPart> fParticipantToPart;
    private Map<IWorkbenchPart, ISynchronizeParticipant> fPartToParticipant;
    private SynchronizePageDropDownAction fPageDropDown;
    private PinParticipantAction fPinAction;
    private RemoveSynchronizeParticipantAction fRemoveCurrentAction;
    private RemoveSynchronizeParticipantAction fRemoveAllAction;
    private ToggleLinkingAction fToggleLinkingAction;
    private SynchronizeAndRefreshAction fRefreshAction;
    private PasteAction fPastePatchAction;
    private boolean fLinkingEnabled;
    private OpenAndLinkWithEditorHelper fOpenAndLinkWithEditorHelper;
    private static final String KEY_LAST_ACTIVE_PARTICIPANT_ID = "lastactiveparticipant_id";
    private static final String KEY_LAST_ACTIVE_PARTICIPANT_SECONDARY_ID = "lastactiveparticipant_sec_id";
    private static final String KEY_LINK_WITH_EDITOR = "linkWithEditor";
    private static final String KEY_SETTINGS_SECTION = "SynchronizeViewSettings";
    private IPartListener2 fLinkWithEditorListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                SynchronizeView.this.editorActivated(((IEditorReference)partRef).getEditor(true));
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                SynchronizeView.this.editorActivated(((IEditorReference)partRef).getEditor(true));
            }
        }
    };
    private static IElementComparer COMPARER = new IElementComparer(){

        private Object getContributedResourceOrResourceVariant(Object o) {
            IResource[] resources = Utils.getContributedResources(new Object[]{o});
            if (resources.length > 0) {
                return resources[0];
            }
            if (o instanceof SyncInfoModelElement) {
                SyncInfoModelElement sime = (SyncInfoModelElement)o;
                return sime.getSyncInfo().getRemote();
            }
            return null;
        }

        public int hashCode(Object element) {
            Object r = this.getContributedResourceOrResourceVariant(element);
            if (r != null) {
                return r.hashCode();
            }
            return element.hashCode();
        }

        public boolean equals(Object a, Object b) {
            if (a instanceof IResource || a instanceof IResourceVariant) {
                b = this.getContributedResourceOrResourceVariant(b);
            } else if (b instanceof IResource || b instanceof IResourceVariant) {
                a = this.getContributedResourceOrResourceVariant(a);
                return b.equals(a);
            }
            return a.equals(b);
        }
    };

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof ISynchronizeParticipant) {
            IWorkbenchSiteProgressService ps;
            if (event.getProperty().equals("org.eclipse.jface.text")) {
                if (source.equals(this.getParticipant())) {
                    this.updateTitle();
                }
            } else if (event.getProperty().equals("org.eclipse.team.ui.DIRTY")) {
                Display.getDefault().asyncExec(() -> this.firePropertyChange(257));
            } else if (event.getProperty().equals("org.eclipse.team.ui.ACTIVE_SAVEABLE")) {
                Saveable oldSaveable = (Saveable)event.getOldValue();
                Saveable newSaveable = (Saveable)event.getNewValue();
                ISaveablesLifecycleListener listener = (ISaveablesLifecycleListener)this.getSite().getPage().getWorkbenchWindow().getService(ISaveablesLifecycleListener.class);
                if (listener != null && oldSaveable != null) {
                    listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 3, new Saveable[]{oldSaveable}, false));
                }
                if (listener != null && newSaveable != null) {
                    listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 1, new Saveable[]{newSaveable}, false));
                }
            } else if (event.getProperty().equals("org.eclipse.team.ui.content") && (ps = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class)) != null) {
                Display.getDefault().asyncExec(() -> ps.warnOfContentChange());
            }
        }
        if (source instanceof ISynchronizePageConfiguration) {
            ISynchronizePageConfiguration configuration = (ISynchronizePageConfiguration)source;
            if (event.getProperty().equals("org.eclipse.team.ui.P_PAGE_DESCRIPTION")) {
                if (configuration.getParticipant().equals(this.getParticipant())) {
                    this.updateTitle();
                }
            } else if (event.getProperty().equals("org.eclipse.team.ui.P_SYNCVIEWPAGE_MODE") && configuration.getParticipant().equals(this.getParticipant())) {
                this.updateTitle();
            }
        }
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
    }

    @Override
    public ISynchronizeParticipant getParticipant() {
        return this.activeParticipantRef;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        this.activeParticipantRef = this.fPartToParticipant.get(pageRec.part);
        this.updateActionEnablements();
        this.updateTitle();
    }

    protected void updateTitle() {
        ISynchronizeParticipant participant = this.getParticipant();
        if (participant == null) {
            this.setContentDescription("");
        } else {
            SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)this.fParticipantToPart.get(participant);
            ISynchronizePageConfiguration configuration = part.getConfiguration();
            String description = (String)configuration.getProperty("org.eclipse.team.ui.P_PAGE_DESCRIPTION");
            if (description == null) {
                description = part.getParticipant().getName();
            }
            this.setContentDescription(Utils.shortenText(100, description));
            this.setStatusLineMessage(description, configuration.getMode());
        }
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        SynchronizeViewWorkbenchPart syncPart = (SynchronizeViewWorkbenchPart)part;
        ISynchronizeParticipant participant = syncPart.getParticipant();
        this.clearCrossReferenceCache(part, participant);
    }

    private void clearCrossReferenceCache(IWorkbenchPart part, ISynchronizeParticipant participant) {
        participant.removePropertyChangeListener(this);
        if (part == null) {
            return;
        }
        ISynchronizePageConfiguration configuration = ((SynchronizeViewWorkbenchPart)part).getConfiguration();
        if (configuration != null) {
            configuration.removePropertyChangeListener(this);
        }
        this.fPartToParticipant.remove(part);
        this.fParticipantToPart.remove(participant);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart dummyPart) {
        SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)dummyPart;
        ISynchronizeParticipant participant = part.getParticipant();
        participant.addPropertyChangeListener(this);
        ISynchronizePageConfiguration configuration = participant.createPageConfiguration();
        part.setConfiguration(configuration);
        configuration.addPropertyChangeListener(this);
        IPageBookViewPage page = participant.createPage(configuration);
        if (page != null) {
            this.initPage(page);
            this.initPage(configuration, page);
            page.createControl((Composite)this.getPageBook());
            PageBookView.PageRec rec = new PageBookView.PageRec(dummyPart, (IPage)page);
            return rec;
        }
        return null;
    }

    protected void initPage(ISynchronizePageConfiguration configuration, IPageBookViewPage page) {
        ((SynchronizePageConfiguration)configuration).setSite(new WorkbenchPartSynchronizePageSite((IWorkbenchPart)this, page.getSite(), this.getDialogSettings(configuration.getParticipant())));
        if (page instanceof ISynchronizePage) {
            try {
                ((ISynchronizePage)page).init(configuration.getSite());
            }
            catch (PartInitException e) {
                TeamUIPlugin.log(4, e.getMessage(), e);
            }
        }
        page.getSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fRefreshAction);
        page.getSite().getActionBars().updateActionBars();
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof SynchronizeViewWorkbenchPart;
    }

    public void dispose() {
        super.dispose();
        TeamUI.getSynchronizeManager().removeSynchronizeParticipantListener(this);
        this.fPinAction.dispose();
        this.fPastePatchAction.dispose();
        if (this.activeParticipantRef != null) {
            this.rememberCurrentParticipant();
        }
        this.fParticipantToPart = null;
        this.fPartToParticipant = null;
        this.getSite().getPage().removePartListener(this.fLinkWithEditorListener);
    }

    private void rememberCurrentParticipant() {
        IDialogSettings section = this.getDialogSettings();
        section.put(KEY_LAST_ACTIVE_PARTICIPANT_ID, this.activeParticipantRef.getId());
        section.put(KEY_LAST_ACTIVE_PARTICIPANT_SECONDARY_ID, this.activeParticipantRef.getSecondaryId());
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    @Override
    public void participantsAdded(ISynchronizeParticipant[] participants) {
        ISynchronizeParticipant[] iSynchronizeParticipantArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            ISynchronizeParticipant participant = iSynchronizeParticipantArray[n2];
            if (this.isAvailable() && this.select(TeamUI.getSynchronizeManager().get(participant.getId(), participant.getSecondaryId()))) {
                SynchronizeViewWorkbenchPart part = new SynchronizeViewWorkbenchPart(participant, this.getSite());
                this.fParticipantToPart.put(participant, part);
                this.fPartToParticipant.put(part, participant);
            }
            ++n2;
        }
        Display.getDefault().asyncExec(() -> this.firePropertyChange(257));
    }

    @Override
    public void participantsRemoved(ISynchronizeParticipant[] participants) {
        if (this.isAvailable()) {
            Runnable r = () -> {
                ISynchronizeParticipant[] iSynchronizeParticipantArray2 = participants;
                int n = participants.length;
                int n2 = 0;
                while (n2 < n) {
                    ISynchronizeParticipant participant = iSynchronizeParticipantArray2[n2];
                    if (this.isAvailable()) {
                        SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)this.fParticipantToPart.get(participant);
                        if (part != null) {
                            this.partClosed(part);
                            this.clearCrossReferenceCache(part, participant);
                        }
                        this.removeDialogSettings(participant);
                        if (this.getParticipant() == null) {
                            ISynchronizeParticipantReference[] available = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
                            if (available.length > 0) {
                                ISynchronizeParticipant p;
                                try {
                                    p = available[available.length - 1].getParticipant();
                                }
                                catch (TeamException teamException) {
                                    return;
                                }
                                this.display(p);
                            } else {
                                this.getSite().getPage().removePartListener(this.fLinkWithEditorListener);
                            }
                        }
                    }
                    ++n2;
                }
                this.firePropertyChange(257);
            };
            this.asyncExec(r);
        }
    }

    public SynchronizeView() {
        this.fParticipantToPart = new HashMap<ISynchronizeParticipant, IWorkbenchPart>();
        this.fPartToParticipant = new HashMap<IWorkbenchPart, ISynchronizeParticipant>();
        this.updateTitle();
    }

    protected void createActions() {
        this.fPageDropDown = new SynchronizePageDropDownAction(this);
        this.fRefreshAction = new SynchronizeAndRefreshAction(this);
        this.fPinAction = new PinParticipantAction();
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
        this.fRemoveCurrentAction = new RemoveSynchronizeParticipantAction(this, false);
        this.fRemoveAllAction = new RemoveSynchronizeParticipantAction(this, true);
        this.fPastePatchAction = new PasteAction((IWorkbenchPart)this);
        this.updateActionEnablements();
    }

    private void updateActionEnablements() {
        if (this.fPinAction != null) {
            this.fPinAction.setParticipant(this.activeParticipantRef);
        }
        if (this.fToggleLinkingAction != null) {
            this.fToggleLinkingAction.setEnabled(this.getParticipant() != null);
        }
        if (this.fRemoveAllAction != null) {
            this.fRemoveAllAction.setEnabled(this.getParticipant() != null);
        }
        if (this.fRemoveCurrentAction != null) {
            this.fRemoveCurrentAction.setEnabled(this.getParticipant() != null);
        }
        if (this.fPastePatchAction != null) {
            this.fPastePatchAction.setEnabled(true);
        }
    }

    protected void configureToolBar(IActionBars bars) {
        IToolBarManager mgr = bars.getToolBarManager();
        mgr.add((IAction)this.fPageDropDown);
        mgr.add((IAction)this.fPinAction);
        IMenuManager menu = bars.getMenuManager();
        menu.add((IAction)this.fPinAction);
        menu.add((IAction)this.fToggleLinkingAction);
        menu.add((IAction)this.fRemoveCurrentAction);
        menu.add((IAction)this.fRemoveAllAction);
        IHandlerService handlerService = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.navigate.linkWithEditor", (IHandler)new ActionHandler((IAction)this.fToggleLinkingAction));
        handlerService.activateHandler(ActionFactory.PASTE.getCommandId(), (IHandler)new ActionHandler((IAction)this.fPastePatchAction));
    }

    @Override
    public void display(ISynchronizeParticipant participant) {
        SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)this.fParticipantToPart.get(participant);
        if (part != null) {
            this.partActivated(part);
            this.fPageDropDown.update();
            this.createOpenAndLinkWithEditorHelper((StructuredViewer)this.getViewer());
            this.rememberCurrentParticipant();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getPageBook().getParent(), participant.getHelpContextId());
        }
    }

    private void createOpenAndLinkWithEditorHelper(StructuredViewer viewer) {
        if (this.fOpenAndLinkWithEditorHelper != null) {
            this.fOpenAndLinkWithEditorHelper.dispose();
        }
        this.fOpenAndLinkWithEditorHelper = new OpenAndLinkWithEditorHelper(viewer){

            protected void activate(ISelection selection) {
                try {
                    Object selectedElement = SynchronizeView.getSingleElement(selection);
                    if (SynchronizeView.isOpenInEditor(selectedElement) != null && selectedElement instanceof IFile) {
                        SynchronizeView.openInEditor((IFile)selectedElement, true);
                    }
                }
                catch (PartInitException partInitException) {}
            }

            protected void linkToEditor(ISelection selection) {
                SynchronizeView.this.linkToEditor(selection);
            }

            protected void open(ISelection selection, boolean activate) {
            }
        };
        this.fOpenAndLinkWithEditorHelper.setLinkWithEditor(this.isLinkingEnabled());
        this.setLinkingEnabled(this.isLinkingEnabled());
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isAvailable()) {
            this.getPageBook().getDisplay().asyncExec(runnable);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.restoreLinkingEnabled();
        this.createActions();
        this.configureToolBar(this.getViewSite().getActionBars());
        this.updateForExistingParticipants();
        this.getViewSite().getActionBars().updateActionBars();
        this.updateTitle();
        IWorkbenchSiteProgressService progress = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (progress != null) {
            progress.showBusyForFamily(ISynchronizeManager.FAMILY_SYNCHRONIZE_OPERATION);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.ui.sync_view_context");
    }

    private void updateForExistingParticipants() {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        List<ISynchronizeParticipantReference> participants = Arrays.asList(this.getParticipants());
        boolean errorOccurred = false;
        for (ISynchronizeParticipantReference participant : participants) {
            try {
                ISynchronizeParticipantReference ref = participant;
                this.participantsAdded(new ISynchronizeParticipant[]{ref.getParticipant()});
            }
            catch (TeamException teamException) {
                errorOccurred = true;
            }
        }
        if (errorOccurred) {
            participants = Arrays.asList(this.getParticipants());
        }
        try {
            if (participants.size() > 0) {
                ISynchronizeParticipantReference selectedParticipant;
                ISynchronizeParticipantReference participantToSelect = participants.get(0);
                IDialogSettings section = this.getDialogSettings();
                String selectedParticipantId = section.get(KEY_LAST_ACTIVE_PARTICIPANT_ID);
                String selectedParticipantSecId = section.get(KEY_LAST_ACTIVE_PARTICIPANT_SECONDARY_ID);
                if (selectedParticipantId != null && (selectedParticipant = manager.get(selectedParticipantId, selectedParticipantSecId)) != null) {
                    participantToSelect = selectedParticipant;
                }
                this.display(participantToSelect.getParticipant());
            }
            manager.addSynchronizeParticipantListener(this);
        }
        catch (TeamException e) {
            Utils.handle(e);
        }
    }

    private ISynchronizeParticipantReference[] getParticipants() {
        ISynchronizeParticipantReference[] refs;
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        ArrayList<ISynchronizeParticipantReference> participants = new ArrayList<ISynchronizeParticipantReference>();
        ISynchronizeParticipantReference[] iSynchronizeParticipantReferenceArray = refs = manager.getSynchronizeParticipants();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ISynchronizeParticipantReference ref = iSynchronizeParticipantReferenceArray[n2];
            if (this.select(ref)) {
                participants.add(ref);
            }
            ++n2;
        }
        return participants.toArray(new ISynchronizeParticipantReference[participants.size()]);
    }

    private boolean isAvailable() {
        return this.getPageBook() != null && !this.getPageBook().isDisposed();
    }

    public IPage getPage(ISynchronizeParticipant participant) {
        IWorkbenchPart part = this.fParticipantToPart.get(participant);
        if (part == null) {
            return null;
        }
        try {
            return this.getPageRec((IWorkbenchPart)part).page;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected boolean select(ISynchronizeParticipantReference ref) {
        return true;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(SynchronizeView.class)).getDialogSettings();
        IDialogSettings syncViewSettings = workbenchSettings.getSection(KEY_SETTINGS_SECTION);
        if (syncViewSettings == null) {
            syncViewSettings = workbenchSettings.addNewSection(KEY_SETTINGS_SECTION);
        }
        return syncViewSettings;
    }

    private String getSettingsKey(ISynchronizeParticipant participant) {
        String id = participant.getId();
        String secondaryId = participant.getSecondaryId();
        return secondaryId == null ? id : String.valueOf(id) + '.' + secondaryId;
    }

    private IDialogSettings getDialogSettings(ISynchronizeParticipant participant) {
        String key = this.getSettingsKey(participant);
        IDialogSettings viewsSettings = this.getDialogSettings();
        IDialogSettings settings = viewsSettings.getSection(key);
        if (settings == null) {
            settings = viewsSettings.addNewSection(key);
        }
        return settings;
    }

    private void removeDialogSettings(ISynchronizeParticipant participant) {
        String key = this.getSettingsKey(participant);
        IDialogSettings settings = this.getDialogSettings();
        if (settings.getSection(key) != null) {
            this.getDialogSettings().addSection((IDialogSettings)new DialogSettings(key));
        }
    }

    public Saveable[] getSaveables() {
        HashSet<Saveable> result = new HashSet<Saveable>();
        for (IWorkbenchPart element : this.fPartToParticipant.keySet()) {
            SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)element;
            Saveable saveable = this.getSaveable(part.getParticipant());
            if (saveable == null) continue;
            result.add(saveable);
        }
        return result.toArray(new Saveable[result.size()]);
    }

    private Saveable getSaveable(ISynchronizeParticipant participant) {
        if (participant instanceof ModelSynchronizeParticipant) {
            ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)participant;
            return msp.getActiveSaveable();
        }
        return null;
    }

    public Saveable[] getActiveSaveables() {
        ISynchronizeParticipant participant = this.getParticipant();
        Saveable s = this.getSaveable(participant);
        if (s != null) {
            return new Saveable[]{s};
        }
        return new Saveable[0];
    }

    public void doSave(IProgressMonitor monitor) {
        Saveable[] saveables = this.getSaveables();
        if (saveables.length == 0) {
            return;
        }
        monitor.beginTask(null, 100 * saveables.length);
        Saveable[] saveableArray = saveables;
        int n = saveables.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable saveable = saveableArray[n2];
            try {
                saveable.doSave(Policy.subMonitorFor(monitor, 100));
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage(), (IStatus)e.getStatus());
            }
            Policy.checkCanceled(monitor);
            ++n2;
        }
        monitor.done();
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        Saveable[] saveables;
        Saveable[] saveableArray = saveables = this.getSaveables();
        int n = saveables.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable saveable = saveableArray[n2];
            if (saveable.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private void setStatusLineMessage(String description, int mode) {
        String syncMode = null;
        ResourceBundle bundle = Policy.getActionBundle();
        switch (mode) {
            case 1: {
                syncMode = Utils.getString("action.directionFilterIncoming.tooltip", bundle);
                break;
            }
            case 2: {
                syncMode = Utils.getString("action.directionFilterOutgoing.tooltip", bundle);
                break;
            }
            case 4: {
                syncMode = Utils.getString("action.directionFilterBoth.tooltip", bundle);
                break;
            }
            case 8: {
                syncMode = Utils.getString("action.directionFilterConflicts.tooltip", bundle);
            }
        }
        IViewSite viewSite = this.getViewSite();
        if (viewSite != null && syncMode != null) {
            viewSite.getActionBars().getStatusLineManager().setMessage(NLS.bind((String)TeamUIMessages.SynchronizeView_statusLine, (Object[])new String[]{description, syncMode}));
        }
    }

    public boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    public void setLinkingEnabled(boolean enabled) {
        this.fLinkingEnabled = enabled;
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(KEY_LINK_WITH_EDITOR, this.fLinkingEnabled);
        IWorkbenchPage page = this.getSite().getPage();
        if (enabled) {
            page.addPartListener(this.fLinkWithEditorListener);
            IEditorPart editor = page.getActiveEditor();
            if (editor != null) {
                this.editorActivated(editor);
            }
        } else {
            page.removePartListener(this.fLinkWithEditorListener);
        }
        this.fOpenAndLinkWithEditorHelper.setLinkWithEditor(enabled);
    }

    private void restoreLinkingEnabled() {
        this.fLinkingEnabled = this.getDialogSettings().getBoolean(KEY_LINK_WITH_EDITOR);
    }

    private void linkToEditor(ISelection selection) {
        IEditorPart part;
        Object obj = SynchronizeView.getSingleElement(selection);
        if (obj != null && (part = SynchronizeView.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
        }
    }

    private void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        Object input = this.getInputFromEditor(editorInput);
        if (input == null) {
            return;
        }
        if (!this.inputIsSelected(editorInput)) {
            this.showInput(input);
        } else {
            this.getViewer().getTree().showSelection();
        }
    }

    boolean showInput(Object input) {
        Object element = input;
        if (element != null) {
            IElementComparer previousComparer = this.getViewer().getComparer();
            this.getViewer().setComparer(COMPARER);
            try {
                StructuredSelection newSelection = new StructuredSelection(element);
                if (this.getViewer().getSelection().equals(newSelection)) {
                    this.getViewer().reveal(element);
                } else {
                    this.getViewer().setSelection((ISelection)newSelection, true);
                    while (element != null && this.getViewer().getSelection().isEmpty()) {
                        if ((element = this.getParent(element)) != null) {
                            newSelection = new StructuredSelection(element);
                            this.getViewer().setSelection((ISelection)newSelection, true);
                            continue;
                        }
                        return false;
                    }
                }
                return true;
            }
            finally {
                this.getViewer().setComparer(previousComparer);
            }
        }
        return false;
    }

    private Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    private TreeViewer getViewer() {
        IPage currentPage = this.getCurrentPage();
        if (currentPage instanceof ISynchronizePage) {
            return (TreeViewer)((ISynchronizePage)currentPage).getViewer();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private boolean inputIsSelected(IEditorInput input) {
        ITreeSelection selection = this.getViewer().getStructuredSelection();
        if (selection.size() != 1) {
            return false;
        }
        IEditorInput selectionAsInput = SynchronizeView.getEditorInput(selection.getFirstElement());
        return input.equals(selectionAsInput);
    }

    private static IEditorInput getEditorInput(Object input) {
        IResource[] resources = Utils.getContributedResources(new Object[]{input});
        if (resources.length > 0) {
            input = resources[0];
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        return null;
    }

    private Object getInputFromEditor(IEditorInput editorInput) {
        IFileRevision fileRevision;
        Object input = editorInput.getAdapter(IFile.class);
        if (input == null && editorInput instanceof FileRevisionEditorInput && (fileRevision = ((FileRevisionEditorInput)editorInput).getFileRevision()) instanceof ResourceVariantFileRevision) {
            return ((ResourceVariantFileRevision)fileRevision).getVariant();
        }
        if (input == null && editorInput instanceof IStorageEditorInput) {
            try {
                input = ((IStorageEditorInput)editorInput).getStorage();
            }
            catch (CoreException coreException) {}
        }
        return input;
    }

    private static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = SynchronizeView.getEditorInput(inputElement);
        if (input != null && (p = TeamUIPlugin.getActivePage()) != null) {
            IEditorPart editor = p.findEditor(input);
            if (editor == null) {
                IEditorReference[] er;
                IEditorReference[] iEditorReferenceArray = er = p.getEditorReferences();
                int n = er.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference e = iEditorReferenceArray[n2];
                    if (e.getId().equals("org.eclipse.compare.CompareEditor") && SynchronizeView.matches(e, input)) {
                        editor = e.getEditor(false);
                    }
                    ++n2;
                }
            }
            return editor;
        }
        return null;
    }

    private static boolean matches(IEditorReference editorRef, IEditorInput input) {
        if (input instanceof FileEditorInput) {
            IResource r;
            IFile file = ((FileEditorInput)input).getFile();
            CompareEditorInput cei = (CompareEditorInput)((EditorPart)editorRef.getPart(false)).getEditorInput();
            Object compareResult = cei.getCompareResult();
            if (compareResult instanceof IAdaptable && (r = (IResource)((IAdaptable)compareResult).getAdapter(IResource.class)) != null) {
                return file.equals((Object)r);
            }
            if (compareResult instanceof ICompareInput) {
                ICompareInput compareInput = (ICompareInput)compareResult;
                ITypedElement left = compareInput.getLeft();
                if (left instanceof ResourceNode && file.equals((Object)((ResourceNode)left).getResource())) {
                    return true;
                }
                ITypedElement right = compareInput.getRight();
                if (right instanceof ResourceNode && file.equals((Object)((ResourceNode)right).getResource())) {
                    return true;
                }
            }
        }
        return false;
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file == null) {
            SynchronizeView.throwPartInitException(TeamUIMessages.SynchronizeView_fileMustNotBeNull);
        }
        if ((p = TeamUIPlugin.getActivePage()) == null) {
            SynchronizeView.throwPartInitException(TeamUIMessages.SynchronizeView_noActiveWorkbenchPage);
        }
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
        return editorPart;
    }

    private static void throwPartInitException(String message) throws PartInitException {
        Status status = new Status(4, "org.eclipse.team.ui", 0, message, null);
        throw new PartInitException((IStatus)status);
    }

    private static Object getSingleElement(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return null;
        }
        return selection.getFirstElement();
    }

    public boolean show(ShowInContext context) {
        Object selection = SynchronizeView.getSingleElement(context.getSelection());
        if (selection != null && this.showInput(selection)) {
            return true;
        }
        Object input = context.getInput();
        if (input != null) {
            if (input instanceof IEditorInput) {
                return this.showInput(this.getInputFromEditor((IEditorInput)input));
            }
            return this.showInput(input);
        }
        return false;
    }

    public IAction getPastePatchAction() {
        return this.fPastePatchAction;
    }
}

