/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;

public class HelpUi {
    private static final Pattern LET_PATTERN = Pattern.compile("<%(string|html|js):([^%>]++)%>");
    private static final String[] KEEP_PLACEHOLDERS = new String[]{"{0}", "{1}", "{2}"};

    public static String resolve(String template, HttpServletRequest request) {
        Matcher matcher = LET_PATTERN.matcher(template);
        boolean found = matcher.find();
        if (found) {
            StringBuilder result = new StringBuilder();
            do {
                String resolved;
                String func = matcher.group(1);
                String param = matcher.group(2);
                if ("string".equals(func)) {
                    resolved = ServletResources.getString(param, KEEP_PLACEHOLDERS, request);
                    HelpUi.append(matcher, result, resolved);
                    continue;
                }
                if ("html".equals(func)) {
                    resolved = ServletResources.getString(param, KEEP_PLACEHOLDERS, request);
                    HelpUi.append(matcher, result, UrlUtil.htmlEncode(resolved));
                    continue;
                }
                if ("js".equals(func)) {
                    resolved = ServletResources.getString(param, KEEP_PLACEHOLDERS, request);
                    String encoded = UrlUtil.JavaScriptEncode(resolved).replace("\\u0020", " ");
                    HelpUi.append(matcher, result, encoded);
                    continue;
                }
                matcher.appendReplacement(result, "");
            } while (found = matcher.find());
            matcher.appendTail(result);
            return result.toString();
        }
        return template;
    }

    private static void append(Matcher matcher, StringBuilder result, String string) {
        matcher.appendReplacement(result, Matcher.quoteReplacement(string));
    }
}

