/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.debug;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.debug.messages.DebugNotificationMessage;
import org.eclipse.lsp4j.jsonrpc.debug.messages.DebugRequestMessage;
import org.eclipse.lsp4j.jsonrpc.debug.messages.DebugResponseMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;

public class DebugRemoteEndpoint
extends RemoteEndpoint {
    private final AtomicInteger nextSeqId = new AtomicInteger();

    public DebugRemoteEndpoint(MessageConsumer out, Endpoint localEndpoint) {
        super(out, localEndpoint);
    }

    public DebugRemoteEndpoint(MessageConsumer out, Endpoint localEndpoint, Function<Throwable, ResponseError> exceptionHandler) {
        super(out, localEndpoint, exceptionHandler);
    }

    protected DebugRequestMessage createRequestMessage(String method, Object parameter) {
        DebugRequestMessage requestMessage = new DebugRequestMessage();
        requestMessage.setId(this.nextSeqId.incrementAndGet());
        requestMessage.setMethod(method);
        requestMessage.setParams(parameter);
        return requestMessage;
    }

    protected DebugResponseMessage createResponseMessage(RequestMessage requestMessage) {
        DebugResponseMessage responseMessage = new DebugResponseMessage();
        responseMessage.setResponseId(this.nextSeqId.incrementAndGet());
        responseMessage.setRawId(requestMessage.getRawId());
        responseMessage.setMethod(requestMessage.getMethod());
        return responseMessage;
    }

    protected DebugNotificationMessage createNotificationMessage(String method, Object parameter) {
        DebugNotificationMessage notificationMessage = new DebugNotificationMessage();
        notificationMessage.setId(this.nextSeqId.incrementAndGet());
        notificationMessage.setMethod(method);
        notificationMessage.setParams(parameter);
        return notificationMessage;
    }
}

