/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;
import org.eclipse.wildwebdeveloper.xml.internal.XMLExtensionRegistry;
import org.eclipse.wildwebdeveloper.xml.internal.ui.preferences.XMLPreferenceConstants;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class XMLLanguageServer
extends ProcessStreamConnectionProvider {
    private static final String SETTINGS_KEY = "settings";
    private static final String XML_KEY = "xml";
    private static final XMLExtensionRegistry extensionJarRegistry = new XMLExtensionRegistry();
    private static final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private static final LanguageServersRegistry.LanguageServerDefinition lemminxDefinition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.wildwebdeveloper.xml");
    private static final IPropertyChangeListener psListener = event -> XMLPreferenceConstants.getLemminxPreference(event).ifPresent(pref -> {
        Map<String, Object> config = XMLLanguageServer.mergeCustomInitializationOptions(extensionJarRegistry.getInitiatizationOptions());
        DidChangeConfigurationParams params = new DidChangeConfigurationParams(Collections.singletonMap(XML_KEY, ((Map)config.get(SETTINGS_KEY)).get(XML_KEY)));
        LanguageServiceAccessor.getActiveLanguageServers(null).stream().filter(server -> lemminxDefinition.equals(LanguageServiceAccessor.resolveServerDefinition((LanguageServer)server).get())).forEach(ls -> ls.getWorkspaceService().didChangeConfiguration(params));
    });

    public XMLLanguageServer() {
        ArrayList<? extends String> commands = new ArrayList<String>();
        ArrayList<String> jarPaths = new ArrayList<String>();
        commands.add(this.computeJavaPath());
        commands.addAll(this.getProxySettings());
        String debugPortString = System.getProperty(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".debugPort");
        if (debugPortString != null) {
            commands.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debugPortString);
        }
        commands.add("-classpath");
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/language-servers/server/org.eclipse.lemminx-uber.jar"));
            List<String> extensionJarPaths = this.getExtensionJarPaths();
            String uberJarPath = new File(url.getPath()).getAbsolutePath();
            jarPaths.add(uberJarPath);
            jarPaths.addAll(extensionJarPaths);
            commands.add(String.join((CharSequence)System.getProperty("path.separator"), jarPaths));
            commands.add("org.eclipse.lemminx.XMLServerLauncher");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    private Collection<? extends String> getProxySettings() {
        IProxyService service;
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry2 : System.getProperties().entrySet()) {
            String property;
            if (!(entry2.getKey() instanceof String) || !(entry2.getValue() instanceof String) || !(property = (String)entry2.getKey()).toLowerCase().contains("proxy") && !property.toLowerCase().contains("proxies")) continue;
            res.put(property, (String)entry2.getValue());
        }
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceRef = bundleContext.getServiceReference(IProxyService.class);
        if (serviceRef != null && (service = (IProxyService)bundleContext.getService(serviceRef)) != null) {
            IProxyData[] iProxyDataArray = service.getProxyData();
            int n = iProxyDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData data = iProxyDataArray[n2];
                if (data.getHost() != null) {
                    res.put(String.valueOf(data.getType().toLowerCase()) + ".proxyHost", data.getHost());
                    res.put(String.valueOf(data.getType().toLowerCase()) + ".proxyPort", Integer.toString(data.getPort()));
                }
                if (data.getUserId() != null) {
                    res.put(String.valueOf(data.getType().toLowerCase()) + ".proxyUser", data.getUserId());
                }
                if (data.getPassword() != null) {
                    res.put(String.valueOf(data.getType().toLowerCase()) + ".proxyPassword", data.getPassword());
                }
                ++n2;
            }
            String nonProxiedHosts = String.join((CharSequence)"|", service.getNonProxiedHosts());
            if (!nonProxiedHosts.isEmpty()) {
                res.put("http.nonProxyHosts", nonProxiedHosts);
                res.put("https.nonProxyHosts", nonProxiedHosts);
            }
        }
        return res.entrySet().stream().map(entry -> "-D" + (String)entry.getKey() + '=' + (String)entry.getValue()).collect(Collectors.toSet());
    }

    private List<String> getExtensionJarPaths() {
        List<String> extensionJarPaths = extensionJarRegistry.getXMLExtensionJars();
        extensionJarPaths.addAll(extensionJarRegistry.getXMLLSClassPathExtensions());
        return extensionJarPaths;
    }

    private String computeJavaPath() {
        return new File(System.getProperty("java.home"), "bin/java" + (Platform.getOS().equals("win32") ? ".exe" : "")).getAbsolutePath();
    }

    public String toString() {
        return "XML Language Server: " + super.toString();
    }

    public Object getInitializationOptions(URI rootUri) {
        return XMLLanguageServer.mergeCustomInitializationOptions(extensionJarRegistry.getInitiatizationOptions());
    }

    private static Map<String, Object> mergeCustomInitializationOptions(Map<String, Object> defaults) {
        HashMap<String, Object> xmlOpts = new HashMap<String, Object>(defaults);
        XMLPreferenceConstants.storePreferencesToLemminxOptions(store, xmlOpts);
        return Map.of(SETTINGS_KEY, Map.of(XML_KEY, xmlOpts));
    }

    public void start() throws IOException {
        super.start();
        store.addPropertyChangeListener(psListener);
    }

    public void stop() {
        store.removePropertyChangeListener(psListener);
        super.stop();
    }
}

