/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.internal.ui.SearchDialog;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OpenSearchDialogAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private String fPageId;

    public OpenSearchDialogAction() {
        super(SearchMessages.OpenSearchDialogAction_label);
        SearchPluginImages.setImageDescriptors((IAction)this, "tool16/", "org.eclipse.search.ui.search.png");
        this.setToolTipText(SearchMessages.OpenSearchDialogAction_tooltip);
    }

    public OpenSearchDialogAction(IWorkbenchWindow window, String pageId) {
        this();
        this.fPageId = pageId;
        this.fWindow = window;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (this.getWorkbenchWindow().getActivePage() == null) {
            SearchPlugin.beep();
            return;
        }
        SearchDialog dialog = new SearchDialog(this.getWorkbenchWindow(), this.fPageId);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        if (this.fWindow == null) {
            this.fWindow = SearchPlugin.getActiveWorkbenchWindow();
        }
        return this.fWindow;
    }

    public void dispose() {
        this.fWindow = null;
    }
}

