/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.ISystemModifiableContainer;
import org.eclipse.rse.core.model.ISystemViewInputProvider;
import org.eclipse.rse.core.model.SystemChildrenContentsType;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemHelpers;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemComboBoxPropertyDescriptor;
import org.eclipse.rse.internal.ui.view.SystemSelectRemoteObjectAPIProviderImpl;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFilterName;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemViewFilterAdapter
extends AbstractSystemViewAdapter {
    private static PropertyDescriptor[] propertyDescriptorArray = null;
    private SystemComboBoxPropertyDescriptor filterStringsDescriptor;
    static /* synthetic */ Class class$0;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        ISubSystemConfigurationAdapter adapter;
        IAction[] actions;
        ISystemFilter filter = (ISystemFilter)selection.getFirstElement();
        if (filter.isTransient()) {
            return;
        }
        ISubSystemConfiguration ssFactory = SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilter)filter);
        ssFactory.setConnection(null);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((actions = (adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz)).getFilterActions(menu, selection, shell, menuGroup, ssFactory, filter)) != null) {
            int idx = 0;
            while (idx < actions.length) {
                IAction action = actions[idx];
                menu.add(menuGroup, action);
                ++idx;
            }
        }
    }

    private ISystemFilter getFilter(Object element) {
        return (ISystemFilter)element;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ImageDescriptor filterImage = null;
        ISystemFilter filter = this.getFilter(element);
        if (filter.getProvider() != null) {
            ISubSystemConfigurationAdapter adapter;
            ISystemFilterPoolManagerProvider iSystemFilterPoolManagerProvider = filter.getProvider();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISubSystemConfigurationAdapter)iSystemFilterPoolManagerProvider.getAdapter((Class)clazz)) != null) {
                filterImage = adapter.getSystemFilterImage(filter);
            }
        }
        if (filterImage == null) {
            filterImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterIcon");
        }
        return filterImage;
    }

    public String getText(Object element) {
        return this.getFilter(element).getName();
    }

    public String getName(Object element) {
        return this.getFilter(element).getName();
    }

    public String getAbsoluteName(Object element) {
        ISystemFilter filter = this.getFilter(element);
        if (filter.isTransient()) {
            return filter.getName();
        }
        return String.valueOf(filter.getSystemFilterPoolManager().getName()) + "." + filter.getParentFilterPool().getName() + "." + filter.getName();
    }

    public String getType(Object element) {
        ISystemFilter filter = this.getFilter(element);
        if (filter.isTransient()) {
            return SystemResources.RESID_PP_FILTER_TYPE_VALUE;
        }
        ISubSystemConfiguration ssParentFactory = SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilter)filter);
        return ssParentFactory.getTranslatedFilterTypeProperty(filter);
    }

    public Object getParent(Object element) {
        ISystemFilter filter = this.getFilter(element);
        if (filter.isTransient()) {
            return filter.getSubSystem();
        }
        return filter.getParentFilterContainer();
    }

    public boolean isPromptable(Object element) {
        ISystemFilter filter = this.getFilter(element);
        if (filter != null && filter.isPromptable()) {
            return true;
        }
        return super.isPromptable(element);
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        ISystemFilter filter = this.getFilter(element);
        if (filter.isTransient()) {
            if (filter.isPromptable()) {
                return this.checkForEmptyList(this.processPromptingFilter(filter), element, true);
            }
            Object[] children = null;
            String[] filterStrings = filter.getFilterStrings();
            ISubSystem ss = (ISubSystem)filter.getSubSystem();
            String preSelectName = null;
            try {
                ISystemViewInputProvider inputProvider = this.getInput();
                if (inputProvider instanceof SystemSelectRemoteObjectAPIProviderImpl && filterStrings != null && filterStrings.length > 0) {
                    SystemSelectRemoteObjectAPIProviderImpl ip = (SystemSelectRemoteObjectAPIProviderImpl)inputProvider;
                    if (ip.filtersNeedDecoration(element)) {
                        String[] adorned = new String[filterStrings.length];
                        int idx = 0;
                        while (idx < filterStrings.length) {
                            adorned[idx] = ip.decorateFilterString(element, filterStrings[idx]);
                            ++idx;
                        }
                        filterStrings = adorned;
                    }
                    preSelectName = ip.getPreSelectFilterChild();
                }
                if (filter instanceof ISystemModifiableContainer) {
                    ISystemModifiableContainer containingFilter = (ISystemModifiableContainer)filter;
                    if (ss.getSubSystemConfiguration().supportsFilterCaching() && !containingFilter.isStale() && containingFilter.hasContents((ISystemContentsType)SystemChildrenContentsType.getInstance())) {
                        children = containingFilter.getContents((ISystemContentsType)SystemChildrenContentsType.getInstance());
                    } else {
                        children = this.checkForEmptyList(ss.resolveFilterStrings(filterStrings, monitor), element, true);
                        if (ss.getSubSystemConfiguration().supportsFilterCaching()) {
                            containingFilter.setContents((ISystemContentsType)SystemChildrenContentsType.getInstance(), children);
                        }
                    }
                }
                if (children != null && preSelectName != null) {
                    Object match = null;
                    int idx = 0;
                    while (match == null && idx < children.length) {
                        Object child = children[idx];
                        String objName = SystemAdapterHelpers.getViewAdapter(child, this.getViewer()).getName(child);
                        if (objName != null && objName.equals(preSelectName)) {
                            match = child;
                        }
                        ++idx;
                    }
                    if (inputProvider instanceof SystemSelectRemoteObjectAPIProviderImpl) {
                        ((SystemSelectRemoteObjectAPIProviderImpl)inputProvider).setPreSelectFilterChildObject(match);
                    }
                }
            }
            catch (InterruptedException exc) {
                children = this.getCancelledMessageObject();
            }
            catch (Exception exc) {
                children = this.getFailedMessageObject();
                SystemBasePlugin.logError("Exception resolving filters' strings ", exc);
            }
            return children;
        }
        if (filter.isPromptable()) {
            return this.checkForEmptyList(null, element, false);
        }
        ISystemFilterString[] filterStrings = filter.getSystemFilterStrings();
        ISystemFilter[] filters = filter.getSystemFilters();
        Vector<Object> vChildren = new Vector<Object>();
        int idx = 0;
        while (idx < filters.length) {
            vChildren.addElement(filters[idx]);
            ++idx;
        }
        idx = 0;
        while (idx < filterStrings.length) {
            vChildren.addElement(filterStrings[idx]);
            ++idx;
        }
        Object[] children = new Object[vChildren.size()];
        int idx2 = 0;
        while (idx2 < vChildren.size()) {
            children[idx2] = vChildren.elementAt(idx2);
            ++idx2;
        }
        return children;
    }

    private Object[] processPromptingFilter(ISystemFilter filter) {
        Object[] children = new SystemMessageObject[1];
        ISystemViewInputProvider inputProvider = this.getInput();
        if (inputProvider != null && inputProvider instanceof SystemSelectRemoteObjectAPIProviderImpl) {
            try {
                SystemSelectRemoteObjectAPIProviderImpl ip = (SystemSelectRemoteObjectAPIProviderImpl)inputProvider;
                ISystemFilter newFilter = ip.createFilterByPrompting(filter, this.getShell());
                if (newFilter == null) {
                    children = this.getCancelledMessageObject();
                } else {
                    children[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1102"), 4, (Object)filter);
                    Viewer v = (Viewer)inputProvider.getViewer();
                    if (v instanceof ISystemResourceChangeListener) {
                        SystemResourceChangeEvent event = new SystemResourceChangeEvent((Object)newFilter, 105, null);
                        RSEUIPlugin.getTheSystemRegistryUI().postEvent((ISystemResourceChangeListener)v, (ISystemResourceChangeEvent)event);
                    }
                }
            }
            catch (Exception exc) {
                children = this.getFailedMessageObject();
                SystemBasePlugin.logError("Exception prompting for filter ", exc);
            }
        }
        return children;
    }

    public boolean hasChildren(IAdaptable element) {
        ISystemFilter filter = this.getFilter(element);
        if (filter.getFilterStringCount() > 0) {
            return true;
        }
        return filter.getSystemFilterCount() > 0;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = new PropertyDescriptor[3];
            int idx = 0;
            SystemViewFilterAdapter.propertyDescriptorArray[idx] = SystemViewFilterAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterParentPool", SystemViewResources.RESID_PROPERTY_FILTERPARENTPOOL_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPARENTPOOL_TOOLTIP);
            SystemViewFilterAdapter.propertyDescriptorArray[++idx] = SystemViewFilterAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterParent", SystemViewResources.RESID_PROPERTY_FILTERPARENTFILTER_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPARENTFILTER_TOOLTIP);
            SystemViewFilterAdapter.propertyDescriptorArray[++idx] = SystemViewFilterAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterstringsCount", SystemViewResources.RESID_PROPERTY_FILTERSTRINGS_COUNT_LABEL, SystemViewResources.RESID_PROPERTY_FILTERSTRINGS_COUNT_TOOLTIP);
        }
        return propertyDescriptorArray;
    }

    protected Object internalGetPropertyValue(Object key) {
        String name = (String)key;
        ISystemFilter filter = this.getFilter(this.propertySourceInput);
        if (name.equals("org.eclipse.rse.ui.filterstrings")) {
            String[] filterStrings = filter.getFilterStrings();
            this.filterStringsDescriptor.setValues(filterStrings);
            if (filterStrings != null && filterStrings.length > 0) {
                return filterStrings[0];
            }
            return "null";
        }
        if (name.equals("org.eclipse.rse.ui.filterstringsCount")) {
            int nbrFilterStrings = filter.getFilterStringCount();
            return Integer.toString(nbrFilterStrings);
        }
        if (name.equals("org.eclipse.rse.ui.filterParent")) {
            if (filter.isTransient()) {
                return this.getTranslatedNotApplicable();
            }
            ISystemFilter parent = filter.getParentFilter();
            if (parent != null) {
                return parent.getName();
            }
            return this.getTranslatedNotApplicable();
        }
        if (name.equals("org.eclipse.rse.ui.filterParentPool")) {
            if (filter.isTransient()) {
                return this.getTranslatedNotApplicable();
            }
            ISystemFilterPool parent = filter.getParentFilterPool();
            if (parent != null) {
                return parent.getName();
            }
            return null;
        }
        return null;
    }

    public boolean showDelete(Object element) {
        return !this.getFilter(element).isTransient();
    }

    public boolean canDelete(Object element) {
        return true;
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) throws Exception {
        ISystemFilter filter = this.getFilter(element);
        ISystemFilterPoolManager fpMgr = filter.getSystemFilterPoolManager();
        fpMgr.deleteSystemFilter(filter);
        return true;
    }

    public boolean showRename(Object element) {
        return !this.getFilter(element).isTransient();
    }

    public boolean canRename(Object element) {
        return true;
    }

    public boolean doRename(Shell shell, Object element, String name, IProgressMonitor monitor) throws Exception {
        ISystemFilter filter = this.getFilter(element);
        ISystemFilterPoolManager fpMgr = filter.getSystemFilterPoolManager();
        fpMgr.renameSystemFilter(filter, name);
        return true;
    }

    public ISystemValidator getNameValidator(Object element) {
        ISystemFilter filter = null;
        ISystemFilterPool pool = null;
        String[] filterNames = null;
        if (element instanceof ISystemFilter) {
            filter = (ISystemFilter)element;
            pool = filter.getParentFilterPool();
            if (pool != null) {
                filterNames = pool.getSystemFilterNames();
            } else {
                ISystemFilter parentFilter = filter.getParentFilter();
                filterNames = parentFilter.getSystemFilterNames();
            }
        } else {
            pool = (ISystemFilterPool)element;
            filterNames = pool.getSystemFilterNames();
        }
        Vector<String> names = new Vector<String>(filterNames.length);
        names.addAll(Arrays.asList(filterNames));
        ValidatorFilterName nameValidator = new ValidatorFilterName(filterNames);
        return nameValidator;
    }

    public String getCanonicalNewName(Object element, String newName) {
        ISystemFilter filter = (ISystemFilter)element;
        if (!filter.isTransient()) {
            String mgrName = filter.getSystemFilterPoolManager().getName();
            return (String.valueOf(mgrName) + "." + filter.getParentFilterPool().getName() + "." + newName).toUpperCase();
        }
        return newName.toUpperCase();
    }

    public boolean showRefresh(Object element) {
        return !this.getFilter(element).isTransient();
    }

    public boolean showOpenViewActions(Object element) {
        return !this.getFilter(element).isTransient();
    }

    public boolean testAttribute(Object target, String name, String value) {
        ISubSystemConfiguration ssf;
        ISystemFilter filter;
        String type;
        boolean result = false;
        result = name.equalsIgnoreCase("filterType") ? (type = (filter = this.getFilter(target)).getType()) != null && type.length() > 0 && value.equals(type) : (name.equalsIgnoreCase("showChangeFilterStringPropertyPage") ? (ssf = SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilter)(filter = this.getFilter(target)))) != null && ssf.showChangeFilterStringsPropertyPage(filter) && value.equals("true") : super.testAttribute(target, name, value));
        return result;
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

