/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.core.registry.Registry;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.internal.GrammarCache;

public abstract class AbstractGrammarRegistryManager
extends Registry
implements IGrammarRegistryManager {
    private final GrammarCache pluginCache = new GrammarCache();
    final GrammarCache userCache = new GrammarCache();

    protected AbstractGrammarRegistryManager() {
        this(new EclipseRegistryOptions());
        ((EclipseRegistryOptions)this.getLocator()).setRegistry(this);
    }

    protected AbstractGrammarRegistryManager(IRegistryOptions locator) {
        super(locator);
    }

    @Override
    public @Nullable IGrammar getGrammarFor(IContentType @Nullable [] contentTypes) {
        if (contentTypes == null) {
            return null;
        }
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IGrammar grammar;
            IContentType contentType = iContentTypeArray[n2];
            String scopeName = this.getScopeNameForContentType(contentType);
            if (scopeName != null && (grammar = this.getGrammarForScope(scopeName)) != null) {
                return grammar;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public @Nullable IGrammar getGrammarForScope(String scopeName) {
        return this.getGrammar(scopeName);
    }

    @Override
    public @Nullable IGrammar getGrammarForFileType(String fileType) {
        IGrammarDefinition[] definitions = this.getDefinitions();
        if (fileType.startsWith(".")) {
            fileType = fileType.substring(1);
        }
        IGrammarDefinition[] iGrammarDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            Collection fileTypes;
            IGrammarDefinition definition = iGrammarDefinitionArray[n2];
            IGrammar grammar = this.getGrammarForScope(definition.getScopeName());
            if (grammar != null && (fileTypes = grammar.getFileTypes()).contains(fileType)) {
                return grammar;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public @Nullable IGrammarDefinition[] getDefinitions() {
        Collection<IGrammarDefinition> pluginDefinitions = this.pluginCache.getDefinitions();
        Collection<IGrammarDefinition> userDefinitions = this.userCache.getDefinitions();
        ArrayList<IGrammarDefinition> definitions = new ArrayList<IGrammarDefinition>(pluginDefinitions);
        definitions.addAll(userDefinitions);
        return (IGrammarDefinition[])definitions.toArray(IGrammarDefinition[]::new);
    }

    private @Nullable IGrammar getGrammar(@Nullable String scopeName) {
        if (scopeName == null) {
            return null;
        }
        IGrammar grammar = super.grammarForScopeName(scopeName);
        if (grammar != null) {
            return grammar;
        }
        return super.loadGrammar(scopeName);
    }

    @Override
    public @Nullable Collection<String> getInjections(String scopeName) {
        return this.pluginCache.getInjections(scopeName);
    }

    protected void registerInjection(String scopeName, String injectTo) {
        this.pluginCache.registerInjection(scopeName, injectTo);
    }

    private @Nullable String getScopeNameForContentType(@Nullable IContentType contentType) {
        while (contentType != null) {
            String scopeName = this.pluginCache.getScopeNameForContentType(contentType);
            if (scopeName != null) {
                return scopeName;
            }
            contentType = contentType.getBaseType();
        }
        return null;
    }

    @Override
    public @Nullable List<IContentType> getContentTypesForScope(String scopeName) {
        return this.pluginCache.getContentTypesForScope(scopeName);
    }

    protected void registerContentTypeBinding(IContentType contentType, String scopeName) {
        this.pluginCache.registerContentTypeBinding(contentType, scopeName);
    }

    @Override
    public void registerGrammarDefinition(IGrammarDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userCache.registerGrammarDefinition(definition);
        } else {
            this.pluginCache.registerGrammarDefinition(definition);
        }
    }

    @Override
    public void unregisterGrammarDefinition(IGrammarDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userCache.unregisterGrammarDefinition(definition);
        } else {
            this.pluginCache.unregisterGrammarDefinition(definition);
        }
    }

    private static final class EclipseRegistryOptions
    implements IRegistryOptions {
        private @Nullable AbstractGrammarRegistryManager registry;

        private EclipseRegistryOptions() {
        }

        private void setRegistry(AbstractGrammarRegistryManager registry) {
            this.registry = registry;
        }

        public @Nullable Collection<String> getInjections(String scopeName) {
            AbstractGrammarRegistryManager registry = this.registry;
            if (registry == null) {
                return null;
            }
            return registry.getInjections(scopeName);
        }

        public @Nullable String getFilePath(String scopeName) {
            IGrammarDefinition info = this.getDefinition(scopeName);
            return info != null ? info.getPath() : null;
        }

        public @Nullable InputStream getInputStream(String scopeName) throws IOException {
            IGrammarDefinition info = this.getDefinition(scopeName);
            return info != null ? info.getInputStream() : null;
        }

        private @Nullable IGrammarDefinition getDefinition(String scopeName) {
            AbstractGrammarRegistryManager registry = this.registry;
            if (registry == null) {
                return null;
            }
            IGrammarDefinition definition = registry.userCache.getDefinition(scopeName);
            if (definition != null) {
                return definition;
            }
            return registry.pluginCache.getDefinition(scopeName);
        }
    }
}

