/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.processes;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.clientserver.processes.ISystemProcessRemoteConstants;

public class HostProcessFilterImpl
implements IHostProcessFilter,
Cloneable {
    public static final String ALL = "*";
    protected static final char WILDCARD = '*';
    protected String name;
    protected String username;
    protected String gid;
    protected String ppid;
    protected String pid;
    protected long minVM;
    protected long maxVM;
    protected boolean anystatus;
    protected String status;
    protected HashMap states;
    protected boolean _resolveVariables;

    public HostProcessFilterImpl() {
        this._resolveVariables = false;
        this.init();
    }

    public HostProcessFilterImpl(boolean resolveVariables) {
        this._resolveVariables = resolveVariables;
        this.init();
    }

    protected void initStates() {
        this.states = new HashMap();
        int i = 0;
        while (i < ISystemProcessRemoteConstants.ALL_STATES_STR.length) {
            this.states.put(ISystemProcessRemoteConstants.ALL_STATES_STR[i], new Boolean(false));
            ++i;
        }
    }

    public HostProcessFilterImpl(String input) {
        this._resolveVariables = false;
        this.initInput(input);
    }

    public HostProcessFilterImpl(String input, boolean resolveVariables) {
        this._resolveVariables = resolveVariables;
        this.initInput(input);
    }

    protected void init() {
        this.name = ALL;
        this.username = ALL;
        this.gid = ALL;
        this.ppid = ALL;
        this.pid = ALL;
        this.minVM = 0L;
        this.maxVM = -1L;
        this.anystatus = true;
        this.initStates();
        this.status = "";
    }

    protected void initInput(String input) {
        String[] allStates;
        this.anystatus = true;
        StringTokenizer tz = new StringTokenizer(input, "|");
        String strMinVM = "0";
        String strMaxVM = "-1";
        if (tz.hasMoreTokens()) {
            this.name = tz.nextToken();
            if (tz.hasMoreTokens()) {
                this.username = tz.nextToken();
                if (tz.hasMoreTokens()) {
                    this.gid = tz.nextToken();
                    if (tz.hasMoreTokens()) {
                        this.status = tz.nextToken().trim();
                        if (tz.hasMoreTokens()) {
                            this.ppid = tz.nextToken();
                            if (tz.hasMoreTokens()) {
                                this.pid = tz.nextToken();
                                if (tz.hasMoreTokens()) {
                                    strMinVM = tz.nextToken();
                                    if (tz.hasMoreTokens()) {
                                        strMaxVM = tz.nextToken();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.status != null && !this.status.equals("") && (allStates = this.status.split(",")) != null) {
            this.initStates();
            this.anystatus = false;
            int i = 0;
            while (i < allStates.length) {
                this.states.put(allStates[i], new Boolean(true));
                ++i;
            }
        }
        if (this.name == null || this.name.equals("")) {
            this.name = ALL;
        }
        if (this.username == null || this.username.equals("")) {
            this.username = ALL;
        }
        if (this.gid == null || this.gid.equals("")) {
            this.gid = ALL;
        }
        if (this.ppid == null || this.ppid.equals("")) {
            this.ppid = ALL;
        }
        if (this.pid == null || this.pid.equals("")) {
            this.pid = ALL;
        }
        try {
            this.minVM = Long.parseLong(strMinVM);
        }
        catch (Exception e) {
            this.minVM = 0L;
        }
        try {
            this.maxVM = Long.parseLong(strMaxVM);
        }
        catch (Exception e) {
            this.maxVM = -1L;
        }
        if (this.minVM < 0L) {
            this.minVM = 0L;
        }
        if (this.maxVM < 0L) {
            this.maxVM = -1L;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        if (this._resolveVariables && this.username.equals("${user.id}")) {
            return ALL;
        }
        return this.username;
    }

    public String getGid() {
        return this.gid;
    }

    public String getPpid() {
        return this.ppid;
    }

    public String getPid() {
        return this.pid;
    }

    public boolean getAnyStatus() {
        return this.anystatus;
    }

    public String getMinVM() {
        return "" + this.minVM;
    }

    public String getMaxVM() {
        return "" + this.maxVM;
    }

    public void setName(String obj) {
        this.name = obj;
    }

    public void setUsername(String obj) {
        this.username = obj;
    }

    public void setGid(String obj) {
        this.gid = obj;
    }

    public void setPpid(String obj) {
        this.ppid = obj;
    }

    public void setPid(String obj) {
        this.pid = obj;
    }

    public void setAnyStatus() {
        this.anystatus = true;
        this.initStates();
    }

    public void setMinVM(String strMinVM) {
        try {
            this.minVM = Long.parseLong(strMinVM);
        }
        catch (Exception e) {
            this.minVM = 0L;
        }
    }

    public void setMaxVM(String strMaxVM) {
        try {
            this.maxVM = Long.parseLong(strMaxVM);
        }
        catch (Exception e) {
            this.maxVM = 0L;
        }
    }

    public String toString() {
        return String.valueOf(this.name) + "|" + this.username + "|" + this.gid + "|" + this.toStateString() + "|" + this.ppid + "|" + this.pid + "|" + this.minVM + "|" + this.maxVM;
    }

    protected String toStateString() {
        String s = " ";
        if (!this.anystatus) {
            int i = 0;
            while (i < ISystemProcessRemoteConstants.ALL_STATES_STR.length) {
                Boolean currentState = (Boolean)this.states.get(ISystemProcessRemoteConstants.ALL_STATES_STR[i]);
                if (currentState.booleanValue()) {
                    s = String.valueOf(s) + ISystemProcessRemoteConstants.ALL_STATES_STR[i];
                }
                if (currentState.booleanValue()) {
                    s = String.valueOf(s) + ",";
                }
                ++i;
            }
            if (!s.trim().equals("")) {
                s = s.trim();
            }
            if (s.endsWith(",")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public boolean allows(String status) {
        NamePatternMatcher matcher = null;
        String[] tokens = status.split("\\|");
        if (tokens.length < 10) {
            return false;
        }
        matcher = new NamePatternMatcher(this.gid, true, false);
        if (!matcher.matches(tokens[8])) {
            return false;
        }
        matcher = new NamePatternMatcher(this.name, true, false);
        if (!matcher.matches(tokens[1])) {
            return false;
        }
        String state = tokens[2].trim();
        if (!this.satisfiesState(state)) {
            return false;
        }
        matcher = this.getUsername().equals("${user.id}") ? new NamePatternMatcher(ALL, true, false) : new NamePatternMatcher(this.getUsername(), true, false);
        if (!matcher.matches(tokens[7])) {
            return false;
        }
        matcher = new NamePatternMatcher(this.ppid, true, false);
        if (!matcher.matches(tokens[4])) {
            return false;
        }
        matcher = new NamePatternMatcher(this.pid, true, false);
        if (!matcher.matches(tokens[0])) {
            return false;
        }
        long vmSize = 0L;
        try {
            vmSize = Long.parseLong(tokens[9]);
        }
        catch (Exception e) {
            if (tokens[9].trim().equals("")) {
                vmSize = 0L;
            }
            return false;
        }
        if (vmSize < this.minVM) {
            return false;
        }
        return this.maxVM <= -1L || vmSize <= this.maxVM;
    }

    public boolean getSpecificState(String stateCode) {
        if (this.anystatus) {
            return true;
        }
        Boolean state = (Boolean)this.states.get(stateCode);
        if (state == null) {
            return false;
        }
        return state;
    }

    public void setSpecificState(String stateCode) {
        this.anystatus = false;
        this.states.put(stateCode, new Boolean(true));
    }

    public boolean satisfiesState(String stateString) {
        if (!this.anystatus) {
            String[] allStates = stateString.split(",");
            if (allStates == null) {
                return false;
            }
            if (allStates.length == 0) {
                return false;
            }
            boolean satisfied = false;
            int i = 0;
            while (i < allStates.length) {
                String nextState = allStates[i];
                satisfied = this.getSpecificState(nextState);
                if (satisfied) break;
                ++i;
            }
            if (!satisfied) {
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        HostProcessFilterImpl clone = null;
        try {
            clone = (HostProcessFilterImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.states != null) {
            clone.states = (HashMap)this.states.clone();
        }
        return clone;
    }
}

