/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.trace;

import org.eclipse.egit.ui.internal.trace.ITraceLocation;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;

public enum GitTraceLocation implements ITraceLocation
{
    UI("/debug/ui"),
    HISTORYVIEW("/debug/ui/historyview"),
    REPOSITORIESVIEW("/debug/ui/repositoriesview"),
    REPOSITORYCHANGESCANNER("/debug/repochangescanner"),
    DECORATION("/debug/ui/decoration"),
    QUICKDIFF("/debug/quickdiff"),
    PROPERTIESTESTER("/debug/ui/propertiestesters"),
    SELECTION("/debug/ui/selection");

    private final String location;
    private final String fullPath;
    private boolean active = false;
    private static volatile DebugTrace myTrace;
    private static volatile DebugOptions currentOptions;

    public static void initializeFromOptions(DebugOptions options) {
        currentOptions = options;
        boolean pluginIsDebugging = options.getBooleanOption("org.eclipse.egit.ui/debug", false);
        if (pluginIsDebugging) {
            myTrace = options.newDebugTrace("org.eclipse.egit.ui");
            GitTraceLocation[] gitTraceLocationArray = GitTraceLocation.values();
            int n = gitTraceLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                GitTraceLocation loc = gitTraceLocationArray[n2];
                boolean active = options.getBooleanOption(loc.getFullPath(), false);
                loc.setActive(active);
                ++n2;
            }
        } else {
            GitTraceLocation[] gitTraceLocationArray = GitTraceLocation.values();
            int n = gitTraceLocationArray.length;
            int n3 = 0;
            while (n3 < n) {
                GitTraceLocation loc = gitTraceLocationArray[n3];
                loc.setActive(false);
                ++n3;
            }
        }
    }

    public static DebugOptions getOptions() {
        return currentOptions;
    }

    private GitTraceLocation(String path) {
        this.fullPath = "org.eclipse.egit.ui" + path;
        this.location = path;
    }

    public static DebugTrace getTrace() {
        return myTrace;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    private String getFullPath() {
        return this.fullPath;
    }

    private void setActive(boolean active) {
        this.active = active;
    }
}

