/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.breakpoints;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.lsp4e.debug.DSPPlugin;
import org.eclipse.lsp4e.debug.breakpoints.DocumentUtils;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4e.debug.debugmodel.DSPStackFrame;

public class TextSelectionToIVariable
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof TextSelection var3_4 && IVariable.class.isAssignableFrom(adapterType)) {
            return adapterType.cast(this.getVariableFor((TextSelection)textSelection));
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IVariable.class};
    }

    private IVariable getVariableFor(TextSelection selection) {
        if (!this.hasDAPTarget()) {
            return null;
        }
        IDocument document = this.getDocument(selection);
        if (document == null) {
            return null;
        }
        DSPStackFrame frame = this.getFrame();
        if (frame == null || !this.match(document, frame)) {
            return null;
        }
        String variableName = null;
        try {
            variableName = document.get(selection.getOffset(), selection.getLength());
            if (variableName.isEmpty()) {
                variableName = this.findVariableName(document, selection.getOffset());
            }
        }
        catch (BadLocationException e) {
            DSPPlugin.logError(e);
        }
        if (variableName == null || variableName.isEmpty() || !Character.isJavaIdentifierStart(variableName.charAt(0))) {
            return null;
        }
        try {
            IVariable[] iVariableArray = frame.getVariables();
            int n = iVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable scopeVariable = iVariableArray[n2];
                IValue scope = scopeVariable.getValue();
                if (scope != null) {
                    IVariable[] vars;
                    IVariable[] iVariableArray2 = vars = scope.getVariables();
                    int n3 = vars.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IVariable var = iVariableArray2[n4];
                        if (var.getName().equals(variableName)) {
                            return var;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (DebugException de) {
            DSPPlugin.logError(de);
        }
        if (Boolean.TRUE.equals(frame.getDebugTarget().getCapabilities().getSupportsEvaluateForHovers())) {
            try {
                return frame.evaluate(variableName).get();
            }
            catch (ExecutionException de) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                DSPPlugin.logError(e);
            }
        }
        return null;
    }

    private boolean hasDAPTarget() {
        return Stream.of(DebugPlugin.getDefault().getLaunchManager().getLaunches()).filter(Predicate.not(ITerminate::isTerminated)).filter(launch -> "debug".equals(launch.getLaunchMode())).flatMap(launch -> Stream.of(launch.getDebugTargets())).anyMatch(DSPDebugTarget.class::isInstance);
    }

    private boolean match(IDocument document, DSPStackFrame frame) {
        Object sourceElement = frame.getLaunch().getSourceLocator().getSourceElement((IStackFrame)frame);
        if (sourceElement instanceof String) {
            return Objects.equals(DocumentUtils.toUri(document).getPath(), sourceElement);
        }
        return false;
    }

    private String findVariableName(IDocument document, int offset) {
        block5: {
            if (Character.isJavaIdentifierPart(document.getChar(offset))) break block5;
            return null;
        }
        try {
            int startOffset = offset;
            while (startOffset - 1 >= 0 && Character.isJavaIdentifierPart(document.getChar(startOffset - 1))) {
                --startOffset;
            }
            int endOffset = offset;
            while (endOffset + 1 < document.getLength() && Character.isJavaIdentifierPart(document.getChar(endOffset + 1))) {
                ++endOffset;
            }
            return document.get(startOffset, endOffset - startOffset + 1);
        }
        catch (BadLocationException ex) {
            DSPPlugin.logError(ex);
            return null;
        }
    }

    protected DSPStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            return (DSPStackFrame)((Object)Adapters.adapt((Object)adaptable, DSPStackFrame.class));
        }
        return null;
    }

    private IDocument getDocument(TextSelection sel) {
        try {
            Method documentMethod = TextSelection.class.getDeclaredMethod("getDocument", new Class[0]);
            documentMethod.setAccessible(true);
            return (IDocument)documentMethod.invoke((Object)sel, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            DSPPlugin.logError(e);
            return null;
        }
    }
}

