/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.embedder.node;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.dump.UnsupportedCompressionAlgorithmException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class CompressUtils {
    public static void unarchive(URL archiveURL, File baseDir) throws IOException {
        if (archiveURL == null || baseDir == null) {
            return;
        }
        TarArchiveInputStream archive = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream input = archiveURL.openStream();){
            if (archiveURL.getFile().endsWith(".tar.gz")) {
                GzipCompressorInputStream gz = new GzipCompressorInputStream(input);
                archive = new TarArchiveInputStream((InputStream)gz);
            } else if (archiveURL.getFile().endsWith(".tar.xz")) {
                XZCompressorInputStream xz = new XZCompressorInputStream(input);
                archive = new TarArchiveInputStream((InputStream)xz);
            } else if (archiveURL.getFile().endsWith(".zip")) {
                archive = new ZipArchiveInputStream(input);
            } else {
                throw new UnsupportedCompressionAlgorithmException("Unsupported archive file extension: " + archive);
            }
            try {
                CompressUtils.extractArchive((ArchiveInputStream)archive, baseDir);
            }
            finally {
                IOUtils.closeQuietly((Closeable)archive);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void extractArchive(ArchiveInputStream in, File destination) throws IOException {
        ArchiveEntry entry = null;
        while ((entry = in.getNextEntry()) != null) {
            void tarEntry;
            Object linkName;
            void tarEntry2;
            TarArchiveEntry tarArchiveEntry;
            boolean symlink;
            if (!in.canReadEntryData(entry)) continue;
            File f = new File(destination, entry.getName());
            f.delete();
            ArchiveEntry archiveEntry = entry;
            boolean bl = symlink = archiveEntry instanceof TarArchiveEntry && (tarArchiveEntry = (TarArchiveEntry)archiveEntry) == (TarArchiveEntry)archiveEntry && tarEntry2.isSymbolicLink();
            if (entry.isDirectory()) {
                if (f.isDirectory() || f.mkdirs()) continue;
                throw new IOException("failed to create directory " + f);
            }
            File parent = f.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IOException("failed to create directory " + parent);
            }
            if (symlink) {
                linkName = ((TarArchiveEntry)entry).getLinkName();
                Files.createSymbolicLink(f.toPath(), Paths.get((String)linkName, new String[0]), new FileAttribute[0]);
            } else {
                linkName = null;
                Object var10_10 = null;
                try (OutputStream o = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
                    IOUtils.copy((InputStream)in, (OutputStream)o);
                }
                catch (Throwable throwable) {
                    if (linkName == null) {
                        linkName = throwable;
                    } else if (linkName != throwable) {
                        ((Throwable)linkName).addSuppressed(throwable);
                    }
                    throw linkName;
                }
            }
            ArchiveEntry archiveEntry2 = entry;
            if (!(archiveEntry2 instanceof TarArchiveEntry) || (linkName = (TarArchiveEntry)archiveEntry2) != (TarArchiveEntry)archiveEntry2) continue;
            f.setExecutable((tarEntry.getMode() & 0x100) != 0);
        }
    }
}

