/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public final class LSPImages {
    private static ImageRegistry imageRegistry;
    private static final Map<java.awt.Color, Image> colorToImageCache;
    private static final String ICONS_PATH = "$nl$/icons/full/";
    private static final String OBJECT = "$nl$/icons/full/obj16/";
    private static final Image EMPTY_IMAGE;
    public static final String IMG_MODULE = "IMG_MODULE";
    public static final String IMG_NAMESPACE = "IMG_NAMESPACE";
    public static final String IMG_PACKAGE = "IMG_PACKAGE";
    public static final String IMG_CLASS = "IMG_CLASS";
    public static final String IMG_METHOD = "IMG_METOHD";
    public static final String IMG_PROPERTY = "IMG_PROPERTY";
    public static final String IMG_FIELD = "IMG_FIELD";
    public static final String IMG_CONSTRUCTOR = "IMG_CONSTRUCTOR";
    public static final String IMG_ENUM = "IMG_ENUM";
    public static final String IMG_ENUM_MEMBER = "IMG_ENUM_MEMBER";
    public static final String IMG_STRUCT = "IMG_STRUCT";
    public static final String IMG_INTERACE = "IMG_INTERFACE";
    public static final String IMG_FUNCTION = "IMG_FUNCTION";
    public static final String IMG_VARIABLE = "IMG_VARIABLE";
    public static final String IMG_CONSTANT = "IMG_CONSTANT";
    public static final String IMG_TEXT = "IMG_TEXT";
    public static final String IMG_STRING = "IMG_TEXT";
    public static final String IMG_NUMBER = "IMG_NUMBER";
    public static final String IMG_BOOLEAN = "IMG_BOOLEAN";
    public static final String IMG_ARRAY = "IMG_ARRAY";
    public static final String IMG_NULL = "IMG_NULL";
    public static final String IMG_UNIT = "IMG_UNIT";
    public static final String IMG_VALUE = "IMG_VALUE";
    public static final String IMG_KEYWORD = "IMG_KEYWORD";
    public static final String IMG_SNIPPET = "IMG_SNIPPET";
    public static final String IMG_COLOR = "IMG_COLOR";
    public static final String IMG_REFERENCE = "IMG_REFERENCE";

    static {
        colorToImageCache = new HashMap<java.awt.Color, Image>();
        EMPTY_IMAGE = new Image((Device)UI.getDisplay(), 16, 16);
    }

    private LSPImages() {
    }

    public static void initalize(ImageRegistry registry) {
        imageRegistry = registry;
        LSPImages.declareRegistryImage(IMG_MODULE, "$nl$/icons/full/obj16/module.png");
        LSPImages.declareRegistryImage(IMG_NAMESPACE, "$nl$/icons/full/obj16/namespace.png");
        LSPImages.declareRegistryImage(IMG_PACKAGE, "$nl$/icons/full/obj16/package.png");
        LSPImages.declareRegistryImage(IMG_CLASS, "$nl$/icons/full/obj16/class.png");
        LSPImages.declareRegistryImage(IMG_METHOD, "$nl$/icons/full/obj16/method.png");
        LSPImages.declareRegistryImage(IMG_PROPERTY, "$nl$/icons/full/obj16/property.png");
        LSPImages.declareRegistryImage(IMG_FIELD, "$nl$/icons/full/obj16/field.png");
        LSPImages.declareRegistryImage(IMG_CONSTRUCTOR, "$nl$/icons/full/obj16/constructor.png");
        LSPImages.declareRegistryImage(IMG_ENUM, "$nl$/icons/full/obj16/enum.png");
        LSPImages.declareRegistryImage(IMG_ENUM_MEMBER, "$nl$/icons/full/obj16/enum_member.png");
        LSPImages.declareRegistryImage(IMG_STRUCT, "$nl$/icons/full/obj16/struct.png");
        LSPImages.declareRegistryImage(IMG_INTERACE, "$nl$/icons/full/obj16/interface.png");
        LSPImages.declareRegistryImage(IMG_FUNCTION, "$nl$/icons/full/obj16/function.png");
        LSPImages.declareRegistryImage(IMG_VARIABLE, "$nl$/icons/full/obj16/variable.png");
        LSPImages.declareRegistryImage(IMG_CONSTANT, "$nl$/icons/full/obj16/constant.png");
        LSPImages.declareRegistryImage("IMG_TEXT", "$nl$/icons/full/obj16/string.png");
        LSPImages.declareRegistryImage(IMG_NUMBER, "$nl$/icons/full/obj16/number.png");
        LSPImages.declareRegistryImage(IMG_BOOLEAN, "$nl$/icons/full/obj16/boolean.png");
        LSPImages.declareRegistryImage(IMG_ARRAY, "$nl$/icons/full/obj16/array.png");
        LSPImages.declareRegistryImage(IMG_NULL, "$nl$/icons/full/obj16/null.png");
        LSPImages.declareRegistryImage("IMG_TEXT", "$nl$/icons/full/obj16/text.png");
        LSPImages.declareRegistryImage(IMG_UNIT, "$nl$/icons/full/obj16/unit.png");
        LSPImages.declareRegistryImage(IMG_VALUE, "$nl$/icons/full/obj16/value.png");
        LSPImages.declareRegistryImage(IMG_KEYWORD, "$nl$/icons/full/obj16/keyword.png");
        LSPImages.declareRegistryImage(IMG_SNIPPET, "$nl$/icons/full/obj16/snippet.png");
        LSPImages.declareRegistryImage(IMG_COLOR, "$nl$/icons/full/obj16/color.png");
        LSPImages.declareRegistryImage(IMG_REFERENCE, "$nl$/icons/full/obj16/reference.png");
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.lsp4e");
        URL url = null;
        if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null)) != null) {
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        imageRegistry.put(key, desc);
    }

    public static Image getImage(String key) {
        return LSPImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return LSPImages.getImageRegistry().getDescriptor(key);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = LanguageServerPlugin.getDefault().getImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getSharedImage(String imageId) {
        if (imageId == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage(imageId);
    }

    public static ImageDescriptor getSharedImageDescriptor(String imageId) {
        if (imageId == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageId);
    }

    public static Image imageFromSymbolKind(SymbolKind kind) {
        if (kind == null) {
            return EMPTY_IMAGE;
        }
        return switch (kind) {
            case SymbolKind.Array -> LSPImages.getImage(IMG_ARRAY);
            case SymbolKind.Boolean -> LSPImages.getImage(IMG_BOOLEAN);
            case SymbolKind.Class -> LSPImages.getImage(IMG_CLASS);
            case SymbolKind.Constant -> LSPImages.getImage(IMG_CONSTANT);
            case SymbolKind.Constructor -> LSPImages.getImage(IMG_CONSTRUCTOR);
            case SymbolKind.Enum -> LSPImages.getImage(IMG_ENUM);
            case SymbolKind.EnumMember -> LSPImages.getImage(IMG_ENUM_MEMBER);
            case SymbolKind.Struct -> LSPImages.getImage(IMG_STRUCT);
            case SymbolKind.Field -> LSPImages.getImage(IMG_FIELD);
            case SymbolKind.File -> LSPImages.getSharedImage("IMG_OBJ_FILE");
            case SymbolKind.Function -> LSPImages.getImage(IMG_FUNCTION);
            case SymbolKind.Interface -> LSPImages.getImage(IMG_INTERACE);
            case SymbolKind.Method -> LSPImages.getImage(IMG_METHOD);
            case SymbolKind.Module -> LSPImages.getImage(IMG_MODULE);
            case SymbolKind.Namespace -> LSPImages.getImage(IMG_NAMESPACE);
            case SymbolKind.Number -> LSPImages.getImage(IMG_NUMBER);
            case SymbolKind.Package -> LSPImages.getImage(IMG_PACKAGE);
            case SymbolKind.Property -> LSPImages.getImage(IMG_PROPERTY);
            case SymbolKind.String -> LSPImages.getImage("IMG_TEXT");
            case SymbolKind.Variable -> LSPImages.getImage(IMG_VARIABLE);
            case SymbolKind.Null -> LSPImages.getImage(IMG_NULL);
            default -> EMPTY_IMAGE;
        };
    }

    public static Image imageFromCompletionItem(CompletionItem completionItem) {
        return switch (completionItem.getKind()) {
            case CompletionItemKind.Text -> LSPImages.getImage("IMG_TEXT");
            case CompletionItemKind.Method -> LSPImages.getImage(IMG_METHOD);
            case CompletionItemKind.Function -> LSPImages.getImage(IMG_FUNCTION);
            case CompletionItemKind.Constructor -> LSPImages.getImage(IMG_CONSTRUCTOR);
            case CompletionItemKind.Field -> LSPImages.getImage(IMG_FIELD);
            case CompletionItemKind.Variable -> LSPImages.getImage(IMG_VARIABLE);
            case CompletionItemKind.Class -> LSPImages.getImage(IMG_CLASS);
            case CompletionItemKind.Interface -> LSPImages.getImage(IMG_INTERACE);
            case CompletionItemKind.Module -> LSPImages.getImage(IMG_MODULE);
            case CompletionItemKind.Property -> LSPImages.getImage(IMG_PROPERTY);
            case CompletionItemKind.Unit -> LSPImages.getImage(IMG_UNIT);
            case CompletionItemKind.Value -> LSPImages.getImage(IMG_VALUE);
            case CompletionItemKind.Enum -> LSPImages.getImage(IMG_ENUM);
            case CompletionItemKind.EnumMember -> LSPImages.getImage(IMG_ENUM_MEMBER);
            case CompletionItemKind.Struct -> LSPImages.getImage(IMG_STRUCT);
            case CompletionItemKind.Keyword -> LSPImages.getImage(IMG_KEYWORD);
            case CompletionItemKind.Snippet -> LSPImages.getImage(IMG_SNIPPET);
            case CompletionItemKind.Color -> LSPImages.getImageForColor(completionItem);
            case CompletionItemKind.File -> LSPImages.getSharedImage("IMG_OBJ_FILE");
            case CompletionItemKind.Folder -> LSPImages.getSharedImage("IMG_OBJ_FOLDER");
            case CompletionItemKind.Reference -> LSPImages.getImage(IMG_REFERENCE);
            default -> null;
        };
    }

    private static Image getImageForColor(CompletionItem completionItem) {
        String hexValue = null;
        String docString = LSPEclipseUtils.getDocString((Either<String, MarkupContent>)completionItem.getDocumentation());
        if (docString != null && docString.startsWith("#")) {
            hexValue = docString;
        } else if (completionItem.getLabel().startsWith("#")) {
            hexValue = completionItem.getLabel();
        }
        if (hexValue == null) {
            return null;
        }
        java.awt.Color decodedColor = null;
        try {
            decodedColor = java.awt.Color.decode(hexValue);
        }
        catch (NumberFormatException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
        return colorToImageCache.computeIfAbsent(decodedColor, key -> {
            Image image = new Image((Device)Display.getDefault(), 16, 16);
            GC gc = new GC((Drawable)image);
            Color color = new Color((Device)Display.getDefault(), key.getRed(), key.getGreen(), key.getBlue(), key.getAlpha());
            gc.setBackground(color);
            gc.fillRectangle(0, 0, 16, 16);
            gc.dispose();
            return image;
        });
    }
}

