/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.internal.signing.GpgConfigurationException;
import org.eclipse.egit.core.op.RewordCommitOperation;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.handler.SelectionHandler;
import org.eclipse.egit.ui.internal.jobs.GpgConfigProblemReportAction;
import org.eclipse.egit.ui.internal.jobs.RepositoryJob;
import org.eclipse.egit.ui.internal.rebase.CommitMessageEditorDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jgit.lib.CommitConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.widgets.Shell;

public class RewordHandler
extends SelectionHandler {
    public static final String ID = "org.eclipse.egit.ui.commit.Reword";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RevCommit commit = this.getSelectedItem(RevCommit.class, event);
        if (commit == null) {
            return null;
        }
        Repository repo = this.getSelectedItem(Repository.class, event);
        if (repo == null) {
            return null;
        }
        Shell shell = this.getPart(event).getSite().getShell();
        CommitConfig config = (CommitConfig)repo.getConfig().get(CommitConfig.KEY);
        CommitConfig.CleanupMode mode = config.resolve(CommitConfig.CleanupMode.DEFAULT, true);
        String oldMessage = commit.getFullMessage();
        CommitMessageEditorDialog dialog = new CommitMessageEditorDialog(shell, repo, oldMessage, mode, config.getCommentChar(oldMessage));
        if (dialog.open() != 0) {
            return null;
        }
        String newMessage = dialog.getCommitMessage();
        if (StringUtils.isEmptyOrNull((String)newMessage) || newMessage.equals(oldMessage)) {
            return null;
        }
        final RewordCommitOperation op = new RewordCommitOperation(repo, commit, newMessage, dialog.isWithChangeId());
        RepositoryJob job = new RepositoryJob(MessageFormat.format(UIText.RewordHandler_JobName, commit.name()), null){
            private IStatus gpgConfigProblem;

            @Override
            protected IStatus performJob(IProgressMonitor monitor) {
                try {
                    try {
                        op.execute(monitor);
                    }
                    catch (CoreException e) {
                        IStatus status = e.getStatus();
                        if (status.getException() instanceof GpgConfigurationException) {
                            this.gpgConfigProblem = e.getStatus();
                            IStatus iStatus = Status.OK_STATUS;
                            monitor.done();
                            return iStatus;
                        }
                        IStatus iStatus = status;
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.REWORD.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }

            @Override
            protected IAction getAction() {
                if (this.gpgConfigProblem == null || this.gpgConfigProblem.isOK()) {
                    return null;
                }
                return new GpgConfigProblemReportAction(this.gpgConfigProblem, UIText.RewordHandler_GpgConfigProblem);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return null;
    }
}

