/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.ui.widgets.ISystemCollapsableSectionListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SystemCollapsableSection
extends Composite
implements MouseListener,
PaintListener {
    public static final String Copyright = "(C) Copyright IBM Corp. 2002, 2003.  All Rights Reserved.";
    protected boolean _bCollapsed = false;
    protected boolean _bMouseOver = false;
    protected Composite _compositePage = null;
    protected String _strText = null;
    protected String _strExpandedText = null;
    protected String _strCollapsedText = null;
    protected String _strExpandedToolTip = null;
    protected String _strCollapsedToolTip = null;
    protected Label _labelTitle = null;
    protected static Color _colorCollapsable = null;
    private List listeners = new ArrayList(5);

    public SystemCollapsableSection(Composite compositeParent) {
        super(compositeParent, 0);
        this.setLayout(new RTwisteeLayout());
        this._compositePage = new Composite((Composite)this, 0);
        GridData gridData = new GridData();
        this.setLayoutData(gridData);
        this.addPaintListener(this);
        this.addMouseListener(this);
    }

    private static Color getCollapsableColour() {
        if (_colorCollapsable == null || _colorCollapsable.isDisposed()) {
            Display display = Display.getCurrent();
            _colorCollapsable = new Color((Device)display, 0, 140, 140);
        }
        return _colorCollapsable;
    }

    public Composite getPageComposite() {
        return this._compositePage;
    }

    private Point getTitleSize(String strText) {
        if (strText == null || strText.length() == 0) {
            strText = "MMMMMMMMMMMM";
        }
        GC gc = new GC((Drawable)this);
        Point ptSize = gc.textExtent(strText);
        ptSize.y = Math.max(ptSize.y, gc.getFontMetrics().getHeight());
        ptSize.x += 20;
        ptSize.y = Math.max(ptSize.y, 20);
        gc.dispose();
        return ptSize;
    }

    public boolean getCollapsed() {
        return this._bCollapsed;
    }

    public String getText() {
        return this._strText;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        boolean bl = this._bCollapsed = !this._bCollapsed;
        if (this._bCollapsed) {
            this.setToolTipText(this._strCollapsedToolTip);
        } else {
            this.setToolTipText(this._strExpandedToolTip);
        }
        ArrayList<SystemCollapsableSection> list = new ArrayList<SystemCollapsableSection>();
        SystemCollapsableSection compositeParent = this;
        do {
            list.add(compositeParent);
        } while (!((compositeParent = compositeParent.getParent()) instanceof Shell));
        int i = list.size() - 1;
        while (i >= 0) {
            compositeParent = (Composite)list.get(i);
            compositeParent.layout();
            --i;
        }
        this.fireCollapseEvent(this._bCollapsed);
    }

    public void paintControl(PaintEvent e) {
        SystemCollapsableSection.paintCollapsable(e.gc, 0, 2, this._bCollapsed);
        if (this._bCollapsed) {
            this.setToolTipText(this._strCollapsedToolTip);
            if (this._strCollapsedText != null) {
                this._strText = this._strCollapsedText;
            }
        } else {
            this.setToolTipText(this._strExpandedToolTip);
            if (this._strExpandedText != null) {
                this._strText = this._strExpandedText;
            }
        }
        if (this._strText == null) {
            return;
        }
        e.gc.setForeground(this.getDisplay().getSystemColor(2));
        e.gc.drawString(this._strText, 17, 0, true);
    }

    public static void paintCollapsable(GC gc, int iX, int iY, boolean bCollapsed) {
        Color ccolour = SystemCollapsableSection.getCollapsableColour();
        if (!bCollapsed) {
            gc.setForeground(ccolour);
            int iA = iX;
            int iB = iY + 3;
            gc.drawLine(iA, iB, iA + 10, iB);
            gc.drawLine(++iA, ++iB, iA + 8, iB);
            gc.drawLine(++iA, ++iB, iA + 6, iB);
            gc.drawLine(++iA, ++iB, iA + 4, iB);
            gc.drawLine(++iA, ++iB, iA + 2, iB);
            gc.drawLine(++iA, ++iB, iA, iB);
            iA = iX;
            iB = iY;
        } else {
            gc.setForeground(ccolour);
            int iA = iX + 2;
            int iB = iY;
            gc.drawLine(iA, iB, iA, iB + 10);
            gc.drawLine(++iA, ++iB, iA, iB + 8);
            gc.drawLine(++iA, ++iB, iA, iB + 6);
            gc.drawLine(++iA, ++iB, iA, iB + 4);
            gc.drawLine(++iA, ++iB, iA, iB + 2);
            gc.drawLine(++iA, ++iB, iA, iB);
        }
        ccolour.dispose();
    }

    public void setCollapsed(boolean bCollapsed) {
        this._bCollapsed = bCollapsed;
        if (this._bCollapsed) {
            this.setToolTipText(this._strCollapsedToolTip);
        } else {
            this.setToolTipText(this._strExpandedToolTip);
        }
        this.redraw();
        this.fireCollapseEvent(bCollapsed);
    }

    public void setText(String strText) {
        this._strText = strText;
        this.redraw();
    }

    public void setExpandedText(String strText) {
        this._strExpandedText = strText;
    }

    public void setCollapsedText(String strText) {
        this._strCollapsedText = strText;
    }

    public void setToolTips(String strExpandedToolTip, String strCollapsedToolTip) {
        this._strCollapsedToolTip = strCollapsedToolTip;
        this._strExpandedToolTip = strExpandedToolTip;
    }

    public void addCollapseListener(ISystemCollapsableSectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeCollapseListener(ISystemCollapsableSectionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireCollapseEvent(boolean collapsed) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ISystemCollapsableSectionListener)this.listeners.get(i)).sectionCollapsed(collapsed);
            ++i;
        }
    }

    protected class RTwisteeLayout
    extends Layout {
        protected RTwisteeLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            SystemCollapsableSection.this.checkWidget();
            Point ptSize = SystemCollapsableSection.this.getTitleSize(SystemCollapsableSection.this._strText);
            Point ptPageSize = SystemCollapsableSection.this._compositePage.computeSize(-1, -1, true);
            ptSize.x = Math.max(ptSize.x, ptPageSize.x + 8);
            if (!SystemCollapsableSection.this._bCollapsed) {
                ptSize.y += ptPageSize.y;
            }
            return ptSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Point ptTitleSize = SystemCollapsableSection.this.getTitleSize(SystemCollapsableSection.this._strText);
            SystemCollapsableSection.this.getLocation();
            if (SystemCollapsableSection.this._bCollapsed) {
                Rectangle rectClient = SystemCollapsableSection.this.getClientArea();
                Point ptPageSize = new Point(rectClient.width - 16, rectClient.height - ptTitleSize.y);
                SystemCollapsableSection.this._compositePage.setBounds(16, ptTitleSize.y, ptPageSize.x, 4);
                SystemCollapsableSection.this.setSize(Math.max(ptTitleSize.x, ptPageSize.x + 16), ptTitleSize.y);
            } else {
                Rectangle rectClient = SystemCollapsableSection.this.getClientArea();
                Point ptPageSize = new Point(rectClient.width - 16, rectClient.height - ptTitleSize.y);
                SystemCollapsableSection.this._compositePage.setBounds(16, ptTitleSize.y, ptPageSize.x, ptPageSize.y);
                SystemCollapsableSection.this.setSize(Math.max(ptTitleSize.x, ptPageSize.x + 16), ptTitleSize.y + ptPageSize.y);
            }
        }
    }
}

