/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.ui.internal.themes.AbstractThemeManager;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.osgi.service.prefs.BackingStoreException;

public final class WorkingCopyThemeManager
extends AbstractThemeManager {
    private final IThemeManager manager;
    private @Nullable List<ITheme> themeAdded;
    private @Nullable List<ITheme> themeRemoved;
    private @Nullable List<IThemeAssociation> associationAdded;
    private @Nullable List<IThemeAssociation> associationRemoved;

    public WorkingCopyThemeManager(IThemeManager manager) {
        this.manager = manager;
        this.load();
    }

    private void load() {
        IThemeAssociation[] associations;
        ITheme[] themes;
        ITheme[] iThemeArray = themes = this.manager.getThemes();
        int n = themes.length;
        int n2 = 0;
        while (n2 < n) {
            ITheme theme = iThemeArray[n2];
            super.registerTheme(theme);
            ++n2;
        }
        IThemeAssociation[] iThemeAssociationArray = associations = this.manager.getAllThemeAssociations();
        int n3 = associations.length;
        n = 0;
        while (n < n3) {
            IThemeAssociation association = iThemeAssociationArray[n];
            super.registerThemeAssociation(association);
            ++n;
        }
    }

    @Override
    public void registerTheme(ITheme theme) {
        super.registerTheme(theme);
        List<ITheme> themeAdded = this.themeAdded;
        if (themeAdded == null) {
            themeAdded = this.themeAdded = new ArrayList<ITheme>();
        }
        themeAdded.add(theme);
    }

    @Override
    public void unregisterTheme(ITheme theme) {
        super.unregisterTheme(theme);
        List<ITheme> themeAdded = this.themeAdded;
        if (themeAdded != null && themeAdded.contains(theme)) {
            themeAdded.remove(theme);
        } else {
            List<ITheme> themeRemoved = this.themeRemoved;
            if (themeRemoved == null) {
                themeRemoved = this.themeRemoved = new ArrayList<ITheme>();
            }
            themeRemoved.add(theme);
        }
    }

    @Override
    public void registerThemeAssociation(IThemeAssociation association) {
        super.registerThemeAssociation(association);
        List<IThemeAssociation> associationAdded = this.associationAdded;
        if (associationAdded == null) {
            associationAdded = this.associationAdded = new ArrayList<IThemeAssociation>();
        }
        associationAdded.add(association);
    }

    @Override
    public void unregisterThemeAssociation(IThemeAssociation association) {
        super.unregisterThemeAssociation(association);
        List<IThemeAssociation> associationAdded = this.associationAdded;
        if (associationAdded != null && associationAdded.contains(association)) {
            associationAdded.remove(association);
        } else {
            List<IThemeAssociation> associationRemoved = this.associationRemoved;
            if (associationRemoved == null) {
                associationRemoved = this.associationRemoved = new ArrayList<IThemeAssociation>();
            }
            associationRemoved.add(association);
        }
    }

    @Override
    public void save() throws BackingStoreException {
        if (this.themeAdded != null) {
            for (ITheme theme : this.themeAdded) {
                this.manager.registerTheme(theme);
            }
        }
        if (this.themeRemoved != null) {
            for (ITheme theme : this.themeRemoved) {
                this.manager.unregisterTheme(theme);
            }
        }
        if (this.associationAdded != null) {
            for (IThemeAssociation association : this.associationAdded) {
                this.manager.registerThemeAssociation(association);
            }
        }
        if (this.associationRemoved != null) {
            for (IThemeAssociation association : this.associationRemoved) {
                this.manager.unregisterThemeAssociation(association);
            }
        }
        if (this.themeAdded != null || this.themeRemoved != null || this.associationAdded != null || this.associationRemoved != null) {
            this.manager.save();
        }
    }
}

