/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.rse.services.clientserver.archiveutils.TarEntry;

public class TarFile {
    private File file;
    private Vector blockHeaders;

    public TarFile(File file) throws FileNotFoundException, IOException {
        this.file = file;
        this.loadTarEntries();
    }

    public TarFile(String name) throws FileNotFoundException, IOException {
        this(new File(name));
    }

    private void loadTarEntries() throws FileNotFoundException, IOException {
        InputStream stream = this.getInputStream();
        this.blockHeaders = new Vector();
        byte[] blockData = this.readBlock(stream);
        while (blockData.length != 0) {
            TarEntry header = this.extractBlockHeader(blockData);
            if (header != null) {
                long fileSize = 0L;
                try {
                    fileSize = header.getSize();
                }
                catch (NumberFormatException e) {
                    break;
                }
                this.blockHeaders.add(header);
                int numFileBlocks = (int)(fileSize / 512L);
                numFileBlocks += fileSize % 512L > 0L ? 1 : 0;
                if (header.getTypeFlag() == '2') {
                    numFileBlocks = 0;
                }
                stream.skip(numFileBlocks * 512);
            }
            blockData = this.readBlock(stream);
        }
        stream.close();
    }

    protected InputStream getInputStream() throws FileNotFoundException {
        FileInputStream stream = new FileInputStream(this.file);
        return stream;
    }

    private byte[] readBlock(InputStream stream) throws IOException {
        byte[] blockData = new byte[512];
        int byteRead = 0;
        int i = 0;
        while (i < 512) {
            byteRead = stream.read();
            if (byteRead == -1) break;
            blockData[i] = (byte)byteRead;
            ++i;
        }
        if (byteRead == -1) {
            return new byte[0];
        }
        return blockData;
    }

    private TarEntry extractBlockHeader(byte[] blockData) throws IOException {
        TarEntry entry = new TarEntry(blockData);
        if (entry.getName().equals("")) {
            return null;
        }
        return entry;
    }

    public Enumeration entries() {
        return this.blockHeaders.elements();
    }

    public int size() {
        return this.blockHeaders.size();
    }

    public TarEntry getEntry(String name) {
        Enumeration headers = this.entries();
        while (headers.hasMoreElements()) {
            TarEntry entry = (TarEntry)headers.nextElement();
            String entryName = entry.getName();
            if (!entryName.equals(name) && !entryName.equals(String.valueOf(name) + "/")) continue;
            return entry;
        }
        return null;
    }

    public InputStream getInputStream(TarEntry entry) throws IOException {
        InputStream stream = this.getInputStream();
        byte[] blockData = this.readBlock(stream);
        while (blockData.length != 0) {
            TarEntry header = this.extractBlockHeader(blockData);
            if (header != null) {
                long fileSize = 0L;
                try {
                    fileSize = header.getSize();
                }
                catch (NumberFormatException e) {
                    break;
                }
                if (!header.getName().equals(entry.getName())) {
                    int numFileBlocks = (int)(fileSize / 512L);
                    numFileBlocks += fileSize % 512L > 0L ? 1 : 0;
                    if (header.getTypeFlag() == '2') {
                        numFileBlocks = 0;
                    }
                    stream.skip(numFileBlocks * 512);
                } else {
                    return new TarEntryInputStream(fileSize, stream);
                }
            }
            blockData = this.readBlock(stream);
        }
        return null;
    }

    private class TarEntryInputStream
    extends InputStream {
        private long size;
        private InputStream stream;
        private long numRead;

        public TarEntryInputStream(long size, InputStream stream) {
            this.size = size;
            this.stream = stream;
            this.numRead = 0L;
        }

        public int read() throws IOException {
            if (this.numRead >= this.size) {
                return -1;
            }
            ++this.numRead;
            return this.stream.read();
        }

        public int available() throws IOException {
            long diff = this.size - this.numRead;
            int av = this.stream.available();
            return (int)Math.min(diff, (long)av);
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public synchronized void mark(int readLimit) {
            this.stream.mark(readLimit);
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }

        public synchronized void reset() throws IOException {
            this.stream.reset();
        }
    }
}

