/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.symbols.LSPSymbolInWorkspaceDialog;
import org.eclipse.lsp4e.operations.symbols.WorkspaceSymbolQuickAccessElement;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.quickaccess.IQuickAccessComputer;
import org.eclipse.ui.quickaccess.IQuickAccessComputerExtension;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class WorkspaceSymbolsQuickAccessProvider
implements IQuickAccessComputer,
IQuickAccessComputerExtension {
    private List<@NonNull LanguageServerWrapper> usedLanguageServerWrappers;

    public QuickAccessElement[] computeElements() {
        return new QuickAccessElement[0];
    }

    public void resetState() {
    }

    public boolean needsRefresh() {
        return this.usedLanguageServerWrappers == null || !this.usedLanguageServerWrappers.equals(LanguageServiceAccessor.getStartedWrappers(capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getWorkspaceSymbolProvider()), true));
    }

    public QuickAccessElement[] computeElements(String query, IProgressMonitor monitor) {
        this.usedLanguageServerWrappers = LanguageServiceAccessor.getStartedWrappers(capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getWorkspaceSymbolProvider()), true);
        if (this.usedLanguageServerWrappers.isEmpty()) {
            return new QuickAccessElement[0];
        }
        WorkspaceSymbolParams params = new WorkspaceSymbolParams(query);
        List res = Collections.synchronizedList(new ArrayList());
        try {
            CompletableFuture.allOf((CompletableFuture[])this.usedLanguageServerWrappers.stream().map(w -> w.execute(ls -> ls.getWorkspaceService().symbol(params).thenAcceptAsync(symbols -> {
                if (symbols != null) {
                    res.addAll(LSPSymbolInWorkspaceDialog.eitherToWorkspaceSymbols((Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>)symbols).stream().map(WorkspaceSymbolQuickAccessElement::new).toList());
                }
            }))).toArray(CompletableFuture[]::new)).get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (TimeoutException e) {
            LanguageServerPlugin.logWarning("Could not get workspace symbols due to timeout after 1 second in `workspace/symbol`", e);
        }
        return res.toArray(new QuickAccessElement[res.size()]);
    }
}

